/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Igor kravtchenko <igor@obraz.net>
 *
 */

#ifndef maf_camera_h 
#define maf_camera_h

#ifndef MAF_USE_VS_PCH
#include <string>
#include <osg/Vec3>
#include <osg/Matrix>
#endif

#include <maf/model.h>
#include <maf/view.h>
#include <maf/controller.h>
#include <maf/mafexport.h>

class MAF_EXPORT MAFCameraModel : public MAFModel {
public:
  MAFCameraModel();
  inline const std::string& GetName() { return mName; }
  inline void SetName(const std::string& name) { mName = name; }

  inline const osg::Vec3& GetPosition() const { return mPosition; }
  inline void SetPosition(const osg::Vec3& position) { mPosition = position; }

  inline const osg::Vec3& GetTarget() const { return mTarget; }
  inline void SetTarget(const osg::Vec3& target) { mTarget = target; }

  inline const osg::Vec3& GetUp() const { return mUp; }
  inline void SetUp(const osg::Vec3& up) { mUp = up; }

  inline const osg::Vec3& GetEye() const { return mEye; }
  inline void SetEye(const osg::Vec3& eye) { mEye = eye; }

  inline float GetRoll() const { return mRoll; }
  inline void SetRoll(float roll) { mRoll = roll; }

  inline float GetFov() const { return mFov; }
  inline void SetFov(float fov) { mFov = fov; }

  inline bool GetSeeCone() const { return mSeeCone; }
  inline void SetSeeCone(bool seeCone) { mSeeCone = seeCone; }

  inline float GetNear() const { return mNear; }
  inline void SetNear(float _Near) { mNear = _Near; }

  inline float GetFar() const { return mFar; }
  inline void SetFar(float _Far) { mFar = _Far; }

  inline float GetFogNear() const { return mFogNear; }
  inline void SetFogNear(float _Near) { mFogNear = _Near; }

  inline float GetFogFar() const { return mFogFar; }
  inline void SetFogFar(float _Far) { mFogFar = _Far; }

  inline const osg::Matrixf& GetMatrix() const { return mMat; }
  inline void SetMatrix(const osg::Matrixf _mat) { mMat = _mat; }

private:
  std::string mName;
  osg::Vec3 mPosition;
  osg::Vec3 mTarget;
  osg::Vec3 mUp;
  osg::Vec3 mEye;
  float mRoll;
  float mFov;
  bool mSeeCone;
  float mNear;
  float mFar;
  float mFogNear;
  float mFogFar;
  osg::Matrixf mMat;
};

class MAF_EXPORT MAFCameraController : public MAFController {
public:
  MAFCameraController() {}
  virtual ~MAFCameraController() {}

  virtual void Init(void);

  MAFCameraModel* GetModel() { return dynamic_cast<MAFCameraModel*>(MAFController::GetModel()); }
};

#endif // maf_node_h
