/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Igor Kravtchenko <igor@obraz.net>
*
* Description:
* Precis clock to count ellapsed time.
* The clock's granularity is as precis as possible and thus can be
* massively used without worry for anything that requires precis timestep.
* The implementation uses the Cedric's timer class.
*/

#ifndef MAF_CLOCK_H
#define MAF_CLOCK_H

#ifndef MAF_USE_VS_PCH
#include <maf/mafexport.h>
#endif

class MAFClock {
public:
	MAF_EXPORT MAFClock();
	MAF_EXPORT ~MAFClock();

	// Resets the clocks.
	MAF_EXPORT void reset();

	// Retrieves the current elapsed time expressed in seconds.
	MAF_EXPORT float elapsed() const;

	// Pauses/unpauses the clock.
	MAF_EXPORT void pause();

	// Regulates the clock to a certain time. The time to set is expressed in seconds.
	MAF_EXPORT void set(float time);

	// Gets the progression of the clock. 
	// false for normal increasing timer, true otherwhise.
	// !warning! The progression is relative to the last time the clock was paused.
	inline bool getReverse() const { return bReverse_; }

	// Sets the progression of the clock. 
	// pass false for normal increasing timer, true otherwhise.
	// !warning! The progression is relative to the last time the clock was paused.
	inline void setReverse(bool bReverse) { bReverse_ = bReverse; }

	// Gets the multiplier.
	// It increases the elapsed time by n. Default value is 1.
	inline float getMultiplier() const { return mul_; }

	// Sets the multiplier.
	// It increases the elapsed time by n. Default value is 1.
	inline void setMultiplier(float mul) { mul_ = mul; }

	// Tells if the clock is halted.
	inline bool isHalted() const { return bHalted_; }

private:
	bool			bHalted_;
	bool			bReverse_;
	float			lastTime_;
	float			mul_;
	float			startCounter_;
};

#endif
