/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef maf_controller_h 
#define maf_controller_h

#ifndef MAF_USE_VS_PCH
#include <osg/Referenced>
#endif

#include <maf/model.h>
#include <maf/view.h>
#include <maf/mafexport.h>

class MAFApplication;

class MAF_EXPORT MAFController : public osg::Referenced
{
public:
  MAFController() : mModel(0), mView(0), mLastUpdate(0), mDelta(0), mDeltaFrame(0), mTimeout(0), mFrequency(0) { }
  virtual ~MAFController();

  virtual void Init(void);

  inline virtual void SetModel(MAFModel* model) { mModel = model; }
  inline MAFModel* GetModel(void) { return mModel; }
  inline const MAFModel* GetModel(void) const { return mModel; }

  inline virtual void SetView(MAFView* view) { mView = view; }
  inline MAFView* GetView(void) { return mView; }

  inline virtual bool Update(MAFApplication* application) { return false; }
  bool DoUpdate(MAFApplication* App);

  double GetDelta(void) { return mDelta; }
  double GetDeltaFrame(void) { return mDeltaFrame; }

private:
  MAFModel* mModel;
  MAFView*  mView;

  double mLastUpdate;
  double mDelta;
  double mDeltaFrame;

  int mTimeout;
  double mFrequency;
};

#endif // maf_controller_h
