/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *
 */

#ifndef maf_cursor_h
#define maf_cursor_h

#ifndef MAF_USE_VS_PCH
#include <osg/PositionAttitudeTransform>
#endif

#include <maf/controller.h>

class MAFCursorModel  : public MAFModel
{
public:
  virtual void Init() = 0;
  virtual void SetCursor(int cursor) = 0;
  virtual int GetNbCursor() = 0;
  virtual void ShowCursor(bool state) = 0;
  virtual void WarpMouse(int x,int y) = 0;
  virtual void Update() {}
  virtual void InitCursor() {}
  virtual void ReleaseCursor(){}
  virtual void UpdatePosition(int x,int y) {}
};


class MAFCursorModelSDL : public MAFCursorModel
{
public:
  MAFCursorModelSDL();
  void Init();
  void SetCursor(int cursor);
  int GetNbCursor();
  void ShowCursor(bool state);
  void WarpMouse(int x,int y);
  
  std::vector<SDL_Cursor*> mCursors;
};


class MAFSceneModel;
class MAFCursorModelGL : public MAFCursorModel
{
  MAFApplication* mApplication;
  osg::ref_ptr<osg::PositionAttitudeTransform> mPAT;
  osg::ref_ptr<osg::Node> mNode;
  osg::ref_ptr<osg::Node> mCursor;

  bool mWarpMouseOccur;
  int mWarpX,mWarpY;

public:
  MAFCursorModelGL(MAFApplication* application);
  void Init();
  void SetCursor(int cursor);
  int GetNbCursor();
  void InitCursor();
  void ReleaseCursor();
  void ShowCursor(bool state);
  void WarpMouse(int x,int y);
  void Update();
  void UpdatePosition(int x,int y);

  std::vector<osg::ref_ptr<osg::Node> > mCursors;
};



class MAFCursorController : public MAFController
{
  int mCurrentCursor;
  int mPreviousCursor;
  bool mShowCursor;
public:
  MAFCursorController();
  ~MAFCursorController();
  MAFCursorModel *GetModel(){return static_cast<MAFCursorModel *>(MAFController::GetModel());}
  void Init();
  bool Update(MAFApplication* application);

  void InitCursor();
  void ReleaseCursor();

  void RestoreCursor();
  void ShowCursor(bool state);

  void SetCursor(int);
  int GetNbCursors();
  void WarpMouse(int x,int y);

};


#endif //maf_cursor_h

