/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Igor Kravtchenko <igor@obraz.net>
*
*/

#ifndef MAF_DEPTHMASK_H
#define MAF_DEPTHMASK_H

#include <osg/StateAttribute>

// Encapsulate OpenGL glDepthRange function for OSG

const int DEPTHMASK = 0x1234;

class DepthMask : public osg::StateAttribute {
public:

	DepthMask(bool bWriteMask = true);

	/// Copy constructor using CopyOp to manage deep vs shallow copy.
	DepthMask(const DepthMask &dp,const osg::CopyOp &copyop = osg::CopyOp::SHALLOW_COPY):
	StateAttribute(dp, copyop),
	writeMask_(dp.writeMask_) {}

	META_StateAttribute(maf, DepthMask, (osg::StateAttribute::Type) DEPTHMASK);

	// return -1 if *this < *rhs, 0 if *this==*rhs, 1 if *this>*rhs.
	virtual int compare(const StateAttribute &sa) const
	{
		// check the types are equal and then create the rhs variable
		// used by the COMPARE_StateAttribute_Parameter macro's below.
		COMPARE_StateAttribute_Types(DepthMask, sa)

		// compare each parameter in turn against the rhs.
		COMPARE_StateAttribute_Parameter(writeMask_)

		return 0; // passed all the above comparison macro's, must be equal.
	}

	virtual bool getModeUsage(ModeUsage& usage) const
	{
		usage.usesMode(GL_DEPTH_TEST);
		return true;
	}

	inline void setWriteMask(GLboolean mask) { writeMask_ = mask; }
	inline GLboolean getWriteMask() const { return writeMask_; }

	virtual void apply(osg::State& state) const;

protected:

	virtual ~DepthMask();

	GLboolean writeMask_;
};

#endif
