/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Igor Kravtchenko <igor@obraz.net>
*
* Description:
* Generic class to move "ala Quake" a 3D item in world space.
*/

#ifndef MAF_FLYINGITEM_H
#define MAF_FLYINGITEM_H

#ifndef MAF_USE_VS_PCH
#include <osg/Matrix>

#include <maf/mafexport.h>
#endif

class MAFFlyingItem {
public:
	MAF_EXPORT static void goForward(osg::Matrixf &, float step);
	MAF_EXPORT static void goBackward(osg::Matrixf &, float step);
	MAF_EXPORT static void goLeft(osg::Matrixf &, float step);
	MAF_EXPORT static void goRight(osg::Matrixf &, float step);
	MAF_EXPORT static void goUp(osg::Matrixf &, float step);
	MAF_EXPORT static void goDown(osg::Matrixf &, float step);
};

#endif
