/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Igor Kravtchenko <igor@mekensleep.com>
 *  Henry Precheur <henry@precheur.org>
 *
 */

#ifndef MAF_OSGHELPER_H
#define MAF_OSGHELPER_H

#ifndef MAF_USE_VS_PCH
#include <maf/mafexport.h>
#include <osg/Vec4>
#include <osg/Vec3>
#include <osg/Array>
#include <osg/Group>
#include <osg/StateSet>
#include <osg/Matrix>
#include <exg/exg_matrix4.h>
#include <osg/Array>
#include <vector>
#endif

#define OSGVEC4F_BLACK osg::Vec4f(0, 0, 0, 1)
#define OSGVEC4F_RED osg::Vec4f(1, 0, 0, 1)
#define OSGVEC4F_GREEN osg::Vec4f(0, 1, 0, 1)
#define OSGVEC4F_BLUE osg::Vec4f(0, 0, 1, 1)
#define OSGVEC4F_WHITE osg::Vec4f(1, 1, 1, 1)

// !NOTE!
// OSG instanciates differently class for nodes that can have childrens (osg::Group) or not (osg::Node)

// get the number of different OSG items...
MAF_EXPORT int OSGHelper_getNbLightSourcesOf(const osg::Group &root);
MAF_EXPORT int OSGHelper_getNbGeodesOf(const osg::Group &root);

// get a pointer to some OSG items given their name
MAF_EXPORT osg::LightSource* OSGHelper_getLightSourceByName(const osg::Group &root, const std::string &);
MAF_EXPORT osg::Geode* OSGHelper_getGeodeByName(const osg::Group &root, const std::string &);
MAF_EXPORT osg::Node* OSGHelper_getNodeByName(const osg::Group &root, const std::string &name);

// turn off the entire lighting mechanism
MAF_EXPORT void OSGHelper_turnOffLighting(osg::StateSet &);

// turn on lighting mechanism
MAF_EXPORT void OSGHelper_turnOnLighting(osg::StateSet &);

// turn off a precis light
MAF_EXPORT void OSGHelper_turnLightOff(osg::StateSet &, int index);

// turn on a precis light
MAF_EXPORT void OSGHelper_turnLightOn(osg::StateSet &, int index);
MAF_EXPORT void OSGHelper_lookAt(const osg::Vec3f &from, const osg::Vec3f &target, osg::Matrixf &);

// return a rotation matrix that passes from a vector from one another
MAF_EXPORT osg::Matrix OSGHelper_getRotationMatrixFromVectorToVector(const osg::Vec3 &dir, const osg::Vec3 &wished_dir);

MAF_EXPORT void OSGHelper_getPointsEqualTo(const osg::Vec3Array &array, const osg::Vec3 &cmp, std::vector<int> &res, float tolerance = 0.01f);

MAF_EXPORT void OSGHelper_getPointsWithXOf(const osg::Vec3Array &array, float x, std::vector<int> &res, float tolerance = 0.01f);
MAF_EXPORT void OSGHelper_getPointsWithYOf(const osg::Vec3Array &array, float y, std::vector<int> &res, float tolerance = 0.01f);
MAF_EXPORT void OSGHelper_getPointsWithZOf(const osg::Vec3Array &array, float z, std::vector<int> &res, float tolerance = 0.01f);

MAF_EXPORT osg::Matrixf convert(const exg::Matrix4f &);
MAF_EXPORT exg::Matrix4f convert(const osg::Matrixf &);

#endif
