/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Henry Precheur <henry@precheur.org>
 *
 */

#ifndef maf_scene_h 
#define maf_scene_h

#ifndef MAF_USE_VS_PCH

#include <list>
#include <map>

#include <osg/Group>
#include <osg/Projection>
#include <osg/Geometry>
#include <osgUtil/SceneView>
#include <maf/mafexport.h>
 
#include <AL/al.h>

#endif

#include <maf/controller.h>
#include <maf/camera.h>
#include <maf/vision.h>

#define MAF_AUDIO_NB_CHANNELS 128
#define MAF_AUDIO_BUFFER_SIZE 2
#define MAF_AUDIO_SOURCE_SIZE 5

#define MAF_COLLISION_MASK 0x1
#define MAF_VISIBLE_MASK 0x4

//class MAFCameraController;


class MAFApplication2DController;
class MAFApplication;
//class MAFCursorController;

class XwncDesktop;

#define MAF_SCENE_PICK_CACHE_SIZE 100

class MAF_EXPORT MAFSceneModel : public MAFModel
{
public:
  typedef std::map<std::string,osg::ref_ptr<MAFVisionController> > Path2VisionController;

  MAFSceneModel() :
    mPickCacheSize(MAF_SCENE_PICK_CACHE_SIZE), mLastPicked(0),
    mAudio(true), mBufferIndex(0), mSourceIndex(0), mContext(0) {}
  virtual ~MAFSceneModel();

  virtual void Init(void);

  bool GetAudio(void) { return mAudio; }
  void SetAudio(bool audio) { mAudio = audio; }

  osg::ref_ptr<osg::Group> mGroup;
  osg::ref_ptr<osg::Projection> mHUDProjection;
  osg::ref_ptr<osg::Group> mHUDGroup;
  osg::ref_ptr<osgUtil::SceneView> mScene;
  osg::ref_ptr<MAFCameraController> mCamera;
  Path2VisionController mPath2VisionController;
  typedef std::pair<std::string, osg::ref_ptr<MAFVisionController> >	ControllerPair;
  typedef std::pair<std::string, ControllerPair > PickPair;
  typedef std::list<PickPair> PickCache;
  PickCache mPickCache;
  unsigned int mPickCacheSize;
  MAFVisionController*	mLastPicked;

  /*
   * To call HandleNotHit on the last hitten controller
   */
  MAFVisionController*	mLastHit;

  bool mAudio;
  ALuint mBuffers[MAF_AUDIO_BUFFER_SIZE];
  ALuint mSources[MAF_AUDIO_SOURCE_SIZE];
  int    mBufferIndex;
  int    mSourceIndex;
  void	*mContext;

private:
  void HUDCreate(void);
};

class MAF_EXPORT MAFSceneView : public MAFView
{

  unsigned int mFrameNumber;
  double mStartTime;

public:

  MAFSceneView() : mFrameNumber(0),mStartTime(0) {}

  virtual MAFSceneModel* GetModel(void) { return (MAFSceneModel*)mModel; }

  MAFVisionController* Pick( osgUtil::SceneView* scene, bool traverse_all, Uint16 x, Uint16 y);

  virtual void Init( void ); 

  void Update(MAFWindow* pWin);

};



class MAF_EXPORT MAFSceneController : public MAFController
{
public:
  virtual void Init(void);

  virtual MAFSceneModel* GetModel(void) { return dynamic_cast<MAFSceneModel*>(MAFController::GetModel()); }
  virtual MAFSceneView* GetView(void) { return dynamic_cast<MAFSceneView*>(MAFController::GetView()); }

  virtual bool Update(MAFApplication* application);

  void	DoIntersection(MAFApplication* application, int x, int y);

  void Insert(MAFVisionController* controller);
  void Remove(MAFVisionController* controller);
  void HUDInsert(MAFVisionController* controller);
  void HUDRemove(MAFVisionController* controller);
  void RegisterPickCallback(const std::string& path, MAFVisionController* controller);

  ALuint AllocateBuffer();
  ALuint AllocateSource();
};

#endif // maf_scene_h
