/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef maf_vision_h 
#define maf_vision_h

#ifndef MAF_USE_VS_PCH
#include <list>
#include <osg/NodeVisitor>
#include <maf/mafexport.h>
#endif

#include <maf/model.h>
#include <maf/controller.h>

class MAFVisionData;
class MAFHit;

MAF_EXPORT void RecursiveClearUserData(osg::Node* node);
MAF_EXPORT osg::NodeVisitor* RecursiveLeakCollect(osg::Node* node);
MAF_EXPORT void RecursiveLeakCheck(osg::NodeVisitor* visitor);
MAF_EXPORT osg::BoundingBox GetBoundingBox(osg::Node* node);

class MAF_EXPORT MAFVisionModel : public MAFModel
{
public:
  MAFVisionModel() : mData(0) {}
  virtual ~MAFVisionModel() { }

  virtual void Init(void) {}

  virtual void SetData(MAFVisionData* data) { mData = data; }
  MAFVisionData* GetData(void) { return mData; }

  virtual void SetNode(osg::Node* node) { mNode = node; }
  osg::Node* GetNode(void) { return mNode.get(); }

private:
  MAFVisionData* mData;
  osg::ref_ptr<osg::Node> mNode;
};

class MAF_EXPORT MAFVisionController : public MAFController
{
public:
  MAFVisionController() {}
  virtual ~MAFVisionController() {}

  MAFVisionModel* GetModel(void) { return dynamic_cast<MAFVisionModel*>(MAFController::GetModel()); }

  void BindToNode(osg::Node* node);

  virtual void HandleHit(MAFHit& hit) { }
  virtual void	HandleNotHit() {}
};

#endif // maf_vision_h
