/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *  Henry Precheur <henry at precheur dot org>
 *
 */
/*
 *
 * Copyright (C) Nicolas Roussel
 * Copyright (C) 2003 Olivier Chapuis
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */

#ifndef _XwncDesktop_H
#define _XwncDesktop_H

#ifndef MAF_USE_VS_PCH

#include <list>
#include <map>
#include <string>

#ifndef WIN32
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#else
#include <maf/wnc_win32x.h>
#endif

#include <SDL.h>

#include <osg/Node>
#include <osg/Group>

#include <maf/maferror.h>

#endif

class WncImage;
class XwncWindow;
class wncSource;
class MAFApplication2DAnimate;

class XwncDesktop
{
public:
  typedef std::map<Window, osg::ref_ptr<XwncWindow> > WindowMapping;
  typedef std::list<Window>	WindowOrder;

protected:
  std::map<std::string, MAFApplication2DAnimate*> mName2Animate;
  std::string _style;

  WindowMapping _windows;
  WindowOrder	_wo;

  wncSource*	_wncServer;
  osg::ref_ptr<osg::Group>	mDisplayGroup;
  osg::ref_ptr<osg::Group>	mHitGroup;

  // FIXME what is this for ?
#if 0
  bool _modifierPressed[256];
#endif

  void	_removeWindow(Window id);

  void	_redoGroup();
  void	_restack(Window up, Window down);
  void	_down(Window id);
  void	_up(Window id);
  void	_add(Window id);
  void	_remove(Window id);

public:
  std::map<std::string, MAFApplication2DAnimate*>& GetName2Animate() { return mName2Animate; }

  wncSource*	getServer()
  {
    return _wncServer;
  }

  // FIXME: for now i only return the fist one
  XwncWindow*	GetWindow()
  {
    if (_wo.size() != 0)
      {
	g_assert(_windows.find(_wo.back()) != _windows.end());
	return (_windows.find(_wo.back()))->second.get();
      }
    else
      return 0;
  }

  osg::Group*	GetMappedWindows()
  {
    return mDisplayGroup.get();
  }

  osg::Group*	GetHitableWindows()
  {
    return mHitGroup.get();
  }

  XwncWindow*	GetWindow(const std::string& name);
  XwncWindow*	GetWindow(Window id);

  void _addWindow(Window id,
		  int x, int y,
		  unsigned int width, unsigned int height,
		  bool map,
		  const char* window_name);
  
  void handleConfigureWindow(Window id, int isroot,
			     int x, int y,
			     int w, int h,
			     const char* window_name);
  // FIXME
  void handleCursorPosition(int x, int y) { }
  void handleImageFramebufferUpdate(XwncWindow* win,
				    bool isRoot,
				    WncImage* img,
				    int x, int y,
				    unsigned int w, unsigned int h);
#if 0
  // FIXME
  void handleWindowShape(XwncWindow* win, CARD16* buf, int size);
#endif
  void handleUnmapWindow(Window id);
  void handleDestroyWindow(Window id);
  void handleRestackWindow(Window id,
			   Window nextId, Window transientFor,
			   unsigned long flags);
  
  void rootPointerEvent(int x, int y, unsigned long button_mask);
  void rootKeyEvent(unsigned long key, bool down_flag);
#if 0
  void setModifiers(SDL_Event e, bool down_flag);
  void releaseModifiers(void);
#endif

  void getSize(unsigned int* width, unsigned int* height);

  void startRequest(void);
  
  XwncDesktop(const std::string& rfburl, const std::string& style);
  ~XwncDesktop();
};

#endif
