/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */
/*
 *
 * Copyright (C) Nicolas Roussel
 * Copyright (C) 2003 Olivier Chapuis
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */

#ifndef wncImageSource_H_
#define wncImageSource_H_

#ifdef WIN32
#include <maf/wnc_win32x.h>
#else
#include <X11/Xmd.h>
#include <X11/Xutil.h>
#endif

#ifndef MAF_USE_VS_PCH
#include <string>
#endif

class XwncDesktop;

extern "C" {
#include <maf/wnc_proto.h>
}

#include <maf/wnc_image.h>

class TcpConnection;
class URL;

// ------------------------------------------------------------------
// See wncauth/wncproto.h

class wncSource {

 private:

	std::string _hostname ;
	int _port ;
	std::string _password ;

	WncImage::Encoding _encoding ;
	WncImage::Encoding _rencoding ;

	TcpConnection *_conn ;

	XwncDesktop *_wncDesktop;

	bool _newImage ;
	unsigned int _width;
	unsigned int _height;

	void _receive(char *data, unsigned int length);
	bool _ReadFromRFBServer(char *out, unsigned int n);
	bool _framebufferUpdate(rfbServerToClientMsg msg);
	bool _readWNCServer(void) ;

#if 0
 protected:

	void prepare(MultiplexRoot *) ;
	void check(MultiplexRoot *) ;
#endif

public:

	wncSource(XwncDesktop *wncDesktop, WncImage::Encoding e, const URL& url) ;
	~wncSource(void);

 	bool start(void) ;
	bool isActive(void) { return (_conn!=0) ; }
	bool stop(void) ;

	void updateRequest(bool include=true) ;
	void updateRequest(int x, int y, int w, int h, bool incremental=true) ;
	void keyEvent(unsigned long keysym, bool down_flag=true) ;
	void pointerEvent(
		Window id, int x, int y, unsigned char button_mask=0) ;
	void pointerEvent(int x, int y, unsigned char button_mask=0) ;
	void getSize(unsigned int *width, unsigned int *height);
	void check() ;
} ;

#endif
