/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */
#ifndef vs_TcpUtils_H_
#define vs_TcpUtils_H_

/*
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */

#ifndef MAF_USE_VS_PCH
#include <string>
#endif

// ------------------------------------------------------------------

class TcpConnection
{

private:
    
  int _fd ;
  bool _close ;

public:

  TcpConnection(int fd, bool close=false) ;
  TcpConnection(const char *hostname, int port, bool close=false) ; 

  int getFd(void) { return _fd ; }

  void send(const char *data, unsigned int length) ;
  void receive(char *data, unsigned int length) ;
  void close(void) ;

  std::string machineLookUp(void) ;
  std::string userLookUp(int millisecs=500) ;
  ~TcpConnection(void) ;
} ;

void setblocking(int fd, int doblock) ;

// ------------------------------------------------------------------

#endif
