/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef ugame_artefact_h 
#define ugame_artefact_h

#include <ugame/ugameexport.h>
#include <osg/PositionAttitudeTransform>
#include <osg/Group>

#include <maf/vision.h>
#include <maf/anchor.h>

class UGAME_EXPORT UGAMEArtefactModel : public MAFVisionModel 
{
public:
  UGAMEArtefactModel();
  virtual ~UGAMEArtefactModel() { }

  virtual void Init(void);

  osg::PositionAttitudeTransform* GetPAT() { return dynamic_cast<osg::PositionAttitudeTransform*>(MAFVisionModel::GetNode()); }
  
  void SetArtefact(osg::Node* artefact);
  osg::Node* GetArtefact(void);

  void SetSelectable(bool selectable) { mSelectable = selectable; }
  bool GetSelectable(void) { return mSelectable; }

  void SetSelected(bool selected) { mSelected = selected; }
  bool GetSelected(void) { return mSelected; }

  MAFAnchor* GetAnchor(void) { return mAnchor.get(); }
  void SetAnchor(MAFAnchor* anchor) { mAnchor = anchor; }

protected:
  osg::ref_ptr<MAFAnchor> mAnchor;
  bool mSelectable;
  bool mSelected;
};

class UGAMEScene;

class UGAME_EXPORT UGAMEArtefactController : public MAFVisionController
{
public:
  UGAMEArtefactController() {}
  virtual ~UGAMEArtefactController();

  UGAMEArtefactModel* GetModel() { return dynamic_cast<UGAMEArtefactModel*>(MAFVisionController::GetModel()); }

  virtual void Init(void);
  virtual bool Update(MAFApplication* application);

  virtual void SetSelectable(bool selectable);
  bool GetSelectable(void) { return GetModel()->GetSelectable(); }

  virtual void SetSelected(bool selected);
  bool GetSelected(void) { return GetModel()->GetSelected(); }

  virtual void Anchor(MAFAnchor* anchor);
  void Displayed(bool displayed);

};


#endif // ugame_artefact_h
