/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef __UGAMEDEBUG_H__
#define __UGAMEDEBUG_H__

#include <vector>

#include <glib.h>

#include <ugame/artefact.h>
#include <osg/Geode>
#include <osg/ShapeDrawable>

struct UGAME_EXPORT UGAMEDebugObject : osg::Referenced
{
  UGAMEDebugObject() {}
  virtual ~UGAMEDebugObject() {}

  virtual void Init()
  {
    g_assert(mShape.get() != NULL);
    mDrawable = new osg::ShapeDrawable(mShape.get());
    mGeode = new osg::Geode;
    mGeode->addDrawable(mDrawable.get());
  }
  osg::ref_ptr<osg::Shape> mShape;
  osg::ref_ptr<osg::ShapeDrawable> mDrawable;
  osg::ref_ptr<osg::Geode> mGeode;
};


class UGAME_EXPORT UGAMEDebugModel : public UGAMEArtefactModel
{
 public:
  UGAMEDebugModel(osg::Group* group);
  virtual ~UGAMEDebugModel();
  virtual void Init(void);
  void Detach(void);
  void AddObject(UGAMEDebugObject *object);
  void AddObject(osg::Group *group, UGAMEDebugObject *object);
  void Clear(void);
 private:
  osg::ref_ptr<osg::Group> mGroup;
  std::vector<osg::ref_ptr<UGAMEDebugObject> > mObjects;
};


class UGAME_EXPORT UGAMEDebugController : public UGAMEArtefactController
{
 public:
  UGAMEDebugController(osg::Group* group);
  virtual ~UGAMEDebugController();
  UGAMEDebugModel* GetModel(void) { return dynamic_cast<UGAMEDebugModel*>(UGAMEArtefactController::GetModel()); }
  void AddDummy(const osg::Vec3 &position, float width = 10.0f);
  void AddVec3(const osg::Vec3 &from, const osg::Vec3 &to);
  void AddDummy(osg::Group *group, const osg::Vec3 &position, float width = 10.0f);
  void AddVec3(osg::Group *group, const osg::Vec3 &from, const osg::Vec3 &to);
  void Clear();
  UGAMEDebugModel *GetDebugModel() {return (UGAMEDebugModel *)GetModel();}
};


struct UGAME_EXPORT UGAMEDebugSingleton
{
  static void Init(osg::Group* group)
    {
      if (mController.get() == NULL)
	mController = new UGAMEDebugController(group);
    }
  static void Uninit()
    {
      if (mController.get() != NULL) {
	mController->GetModel()->Detach();
      }
    }
  static UGAMEDebugController *Get()
    {
      return mController.get();
    }
  private:
  static osg::ref_ptr<UGAMEDebugController> mController;
};
#endif
