/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Igor kravtchenko <igor@obraz.net>
 *
 */

#ifndef __MAFSTDAFX_H
#define __MAFSTDAFX_H

#ifdef MAF_USE_VS_PCH

#pragma warning(disable:4244)

// STANDARD SYSTEM INCLUDE
#include <algorithm>
#include <cmath>
#include <cstddef>
#include <cstdio>
#include <cstring>
#include <iostream>
#include <iomanip>
#include <list>
#include <map>
#include <ostream>
#include <stdexcept>
#include <sstream>
#include <string>
#include <vector>

// "OLD" STANDARD SYSTEM INCLUDE
#include <time.h>
#include <signal.h>
#include <sys/types.h>

// CONFIG INCLUDE
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

// OSG CORE
#include <osg/AutoTransform>
#include <osg/AnimationPath>
#include <osg/Billboard>
#include <osg/BlendFunc>
#include <osg/CullFace>
#include <osg/CullStack>
#include <osg/Drawable>
#include <osg/Geode>
#include <osg/Geometry>
#include <osg/Group>
#include <osg/Fog>
#include <osg/Light>
#include <osg/LightModel>
#include <osg/LineSegment>
#include <osg/LightSource>
#include <osg/Material>
#include <osg/Matrix>
#include <osg/Matrixd>
#include <osg/Matrixf>
#include <osg/MatrixTransform>
#include <osg/Node>
#include <osg/NodeCallback>
#include <osg/NodeVisitor>
#include <osg/PolygonOffset>
#include <osg/PositionAttitudeTransform>
#include <osg/Projection>
#include <osg/Quat>
#include <osg/ref_ptr>
#include <osg/Referenced>
#include <osg/TextureCubeMap>
#include <osg/TexEnvCombine>
#include <osg/TexGen>
#include <osg/TexMat>
#include <osg/Texture2D>
#include <osg/Transform>
#include <osg/ShapeDrawable>
#include <osg/State>
#include <osg/StateSet>
#include <osg/Stencil>
#include <osg/Vec2>
#include <osg/Vec3>
#include <osg/Viewport>

// OSG DB
#include <osgDB/Registry>
#include <osgDB/ReadFile>
#include <osgDB/WriteFile>

// OSG UTIL
#include <osgUtil/CullVisitor>
#include <osgUtil/IntersectVisitor>
#include <osgUtil/Optimizer>
#include <osgUtil/RenderToTextureStage>
#include <osgUtil/SceneView>
#include <osgUtil/TransformCallback>
#include <osgUtil/TriStripVisitor>

// OSG TEXT
#include <osgText/Font>

// OPEN AL
#include <AL/al.h>
#include <AL/alc.h>

// OPEN ALPP
//#include <openalpp/alpp.h>

// OSG AL
#include <osgAL/SoundNode>
#include <osgAL/SoundRoot>
#include <osgAL/SoundManager>
#include <osgAL/SoundState>

// OSG CAL
#include <osgCal/SubMeshSoftware>


// GLIB
#include <glib.h>


// TINY XML
#include <cal3d/tinyxml.h>

// SDL
#include <SDL.h>

// LIBXML
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

#ifdef WIN32
#include <io.h>
#include <process.h>
#include <windows.h>
#include <winsock.h>
#else
#include <sys/select.h>
#endif

#include <vorbis/vorbisfile.h>

// LIB EXG
#include <exg/exg_material.h>
#include <exg/exg_quaternion.h>
#include <exg/exg_mesh.h>
#include <exg/exg_polygon.h>
#include <exg/exg_matrix4.h>

// MAFEXPORT and MAFERROR first
#include <maf/mafexport.h>
#include <maf/maferror.h>

// MAF headers...
#include <maf/MultipleAnimationPathCallback.h>
#include <maf/anchor.h>
#include <maf/application.h>
#include <maf/application2d.h>
#include <maf/animate2d.h>
#include <maf/audio.h>
#include <maf/camera.h>
#include <maf/controller.h>
#include <maf/cursor.h>
#include <maf/data.h>
#include <maf/hit.h>
#include <maf/model.h>
#include <maf/packets.h>
#include <maf/profile.h>
#include <maf/profile_node.h>
#include <maf/timer.h>
#include <maf/scene.h>
#include <maf/split.h>
#include <maf/url.h>
#include <maf/utils.h>
#include <maf/view.h>
#include <maf/vision.h>
#include <maf/window.h>

#include <maf/wnc_auth.h>
#include <maf/wnc_conversion.h>
#include <maf/wnc_d3des.h>
#include <maf/wnc_desktop.h>
#include <maf/wnc_image.h>
#include <maf/wnc_proto.h>
#include <maf/wnc_source.h>
#include <maf/wnc_tcp.h>
#include <maf/wnc_win32x.h>
#include <maf/wnc_window.h>

#include <maf/clock.h>
#include <maf/depthmask.h>
#include <maf/flyingitem.h>
#include <maf/radixsort.h>
#include <maf/osghelper.h>
#include <maf/shadow.h>

#include <osgCal/SubMeshSoftware>

#endif // #ifdef MAF_USE_VS_PCH

#endif // #ifndef __MAFSTDAFX_H
