/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "gui.h"
#include "network.h"
#include "util.h"

static GtkWidget*	g_history_window = 0;
static GtkWidget*	g_entry_window = 0;
static GladeXML* 	g_history_xml = 0;
static GladeXML* 	g_entry_xml = 0;
static gboolean		chat_history_visible = FALSE;

static GtkWidget*	s_icon_up = 0;
static GtkWidget*	s_icon_down = 0;

static void	change_button_icon(GtkWidget* button, GtkWidget* new_icon)
{
  g_assert(GTK_IS_IMAGE(new_icon));
  gtk_container_remove(GTK_CONTAINER(button), gtk_bin_get_child(GTK_BIN(button)));
  gtk_container_add(GTK_CONTAINER(button), new_icon);
  gtk_widget_show(new_icon);
}

void	on_history_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) user_data;
  (void) widget;

  chat_history_visible = !chat_history_visible;

  set_string("chat");
  set_string("history");
  set_string(chat_history_visible ? "yes" : "no");
  flush_io_channel();
  change_button_icon(widget, (chat_history_visible ? s_icon_down : s_icon_up));
}

void	on_chat_done(GtkWidget *widget, gpointer user_data)
{
  (void) user_data;
  const gchar* line = gtk_entry_get_text(GTK_ENTRY(widget));
  if(strlen(line) > 0) {
    set_string("chat");
    set_string("line");
    set_string(line);
    gtk_entry_set_text(GTK_ENTRY(widget), "");
    flush_io_channel();
  }
}

int	handle_chat(void)
{
  char*	tag = get_string();
  
  if (!g_history_xml)
    {
      g_history_xml = gui_load_widget("chat_history_window");
      g_entry_xml = gui_load_widget("chat_entry_window");
      
      g_history_window = glade_xml_get_widget(g_history_xml,
					      "chat_history_window");
      g_assert(g_history_window);
      g_entry_window = glade_xml_get_widget(g_entry_xml,
					    "chat_entry_window");
      g_assert(g_entry_window);

      GUI_BRANCH(g_entry_xml, on_history_clicked);
      GUI_BRANCH(g_entry_xml, on_chat_done);

      gtk_widget_hide_all(GTK_WIDGET(g_entry_window)); // chat bar
						       // must be
						       // shown
						       // explicitely
						       // with a
						       // "show"
						       // packet
      s_icon_up = gtk_image_new_from_stock(GTK_STOCK_GO_UP, GTK_ICON_SIZE_BUTTON);
      g_assert(s_icon_up);
      g_object_ref(s_icon_up);
      s_icon_down = gtk_image_new_from_stock(GTK_STOCK_GO_DOWN, GTK_ICON_SIZE_BUTTON);
      g_assert(s_icon_down);
      g_object_ref(s_icon_down);

      {
	GtkWidget*	button = glade_xml_get_widget(g_entry_xml, "history_button");
	g_assert(button);
	gtk_container_remove(GTK_CONTAINER(button), gtk_bin_get_child(GTK_BIN(button)));
	gtk_container_add(GTK_CONTAINER(button), s_icon_up);
	gtk_widget_show(s_icon_up);
      }
    }

  if(!strcmp(tag, "show"))
    {
      int	window_width, window_height;
      int	screen_width = gdk_screen_width();
      int	screen_height = gdk_screen_height();
      int	chat_entry_window_height;

      {
	GtkWindow* window = GTK_WINDOW(g_entry_window);
	gtk_widget_show_all(GTK_WIDGET(window));
	gtk_window_get_size(window, &window_width, &window_height);
	gtk_window_move(window,
			(screen_width - window_width) / 2,
			screen_height - window_height);
	chat_entry_window_height = window_height;
      }
      {
	GtkWindow* window = GTK_WINDOW(g_history_window);
	gtk_widget_show_all(GTK_WIDGET(window));
	gtk_window_get_size(window, &window_width, &window_height);
	gtk_window_move(window,
			(screen_width - window_width) / 2,
			screen_height - (window_height + chat_entry_window_height));
      }
      /* reset previously inserted text */
      GtkTextView* history = GTK_TEXT_VIEW(glade_xml_get_widget(g_history_xml,
								"history"));
      GtkTextBuffer* buffer = gtk_text_view_get_buffer(history);
      gtk_text_buffer_set_text(buffer, "", sizeof (""));
    }
  else if(!strcmp(tag, "hide"))
    {
      gtk_widget_hide_all(g_entry_window); 
      gtk_widget_hide_all(g_history_window); 
    }
  else if(!strcmp(tag, "line"))
    {
      char*	line = get_string();
      GtkTextView* history = GTK_TEXT_VIEW(glade_xml_get_widget(g_history_xml,
								"history"));
      GtkTextBuffer* buffer = gtk_text_view_get_buffer(history);
      
      GtkTextIter end_iter;
      gtk_text_buffer_get_end_iter(buffer, &end_iter);
      gtk_text_buffer_insert(buffer, &end_iter, line, -1);
      gtk_text_buffer_get_end_iter(buffer, &end_iter);
      gtk_text_view_scroll_to_iter(history, &end_iter,
				   0.1,
				   FALSE,
				   0.0,
				   0.0);
      g_free(line);
    }
  
  g_free(tag);

  return TRUE;
}
