/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prêcheur <henry at precheur dot org>
 *
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "gui.h"
#include "network.h"
#include "util.h"

static GtkWidget*	g_slider_window = 0;
static GtkWidget*	g_slider_value_entry = 0;
static GtkWidget*	g_slider_value_scale = 0;
static GtkWidget*	g_slider_ok_button = 0;
static GtkWidget*	g_slider_cancel_button = 0;
static GladeXML*	g_glade_slider_xml = 0;
static guint g_call = 50;
static guint g_raise_min = 100;
static guint g_raise_max = 1000;
static guint g_step_raise = 10;
static guint g_value = 0;
static gboolean g_need_readjusting = FALSE;


static void set_entry_value(guint value)
{
  gchar buffer[1024];
  memset(buffer, 0, 1024);
  snprintf(buffer, 1024, "%i", value);
  gtk_entry_set_text(GTK_ENTRY(g_slider_value_entry), buffer);
}

static void set_slider_value(guint value)
{
  gtk_range_set_value(GTK_RANGE(g_slider_value_scale), value);
}

void on_slider_value_scale_value_changed(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;
  gdouble value_double = gtk_range_get_value(GTK_RANGE(g_slider_value_scale));
  guint value_uint = (guint)value_double;
  value_uint /= g_step_raise;
  value_uint *= g_step_raise;
  if (g_need_readjusting)
    {
      set_slider_value(g_value);
      g_need_readjusting = FALSE;
    }
  if (value_uint < g_raise_min)
    value_uint = g_call;
  g_value = value_uint;
  set_entry_value(g_value);
}

gboolean on_slider_value_scale_button_release_event(GtkWidget *widget,
						    GdkEventButton *event,
						    gpointer user_data)
{
  (void) widget;
  (void) event;
  (void) user_data;
  if (g_value < g_raise_min)
    {      
      g_value = g_call;
      set_slider_value(g_value);
      g_need_readjusting = TRUE;
    }
  return FALSE;
}

void on_slider_call_button_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;
  g_value = g_call;
  set_slider_value(g_call);
  set_entry_value(g_call);
}

void on_slider_raise_min_button_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;
  g_value = g_raise_min;
  set_slider_value(g_raise_min);
  set_entry_value(g_raise_min);
}

void on_slider_raise_max_button_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;
  g_value = g_raise_max;
  set_slider_value(g_raise_max);
  set_entry_value(g_raise_max);
}

void on_slider_value_entry_activate(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;
  const gchar *text = gtk_entry_get_text(GTK_ENTRY(widget));
  guint value = atoi(text);
  guint max = g_raise_max;
  guint min = g_raise_min;
  if (value > max)
    value = max;
  if (value < min)
    value = min;
  g_value = value;
  set_slider_value(g_value);
}

void on_slider_value_entry_changed(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;
}

void on_slider_ok_button_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;
  gtk_widget_hide_all(g_slider_window);
  set_string("slider");
  set_int(g_value);
  flush_io_channel();
}

void on_slider_cancel_button_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;  
  gtk_widget_hide_all(g_slider_window);
  set_string("slider");
  set_int(0);
  flush_io_channel();
}

void (*on_slider_value_entry_insert_text)(GtkEditable *editable,
					  gchar *new_text,
					  gint new_text_length,
					  gint *position,
					  gpointer user_data) = entry_numeric_constraint;

int handle_slider()
{
  if (!g_glade_slider_xml)
    {
      g_glade_slider_xml = gui_load_widget("slider_window");

      g_slider_window = glade_xml_get_widget(g_glade_slider_xml, "slider_window");
      g_assert(g_slider_window);

      g_slider_value_entry = glade_xml_get_widget(g_glade_slider_xml, "slider_value_entry");
      g_assert(g_slider_value_entry);
      
      g_slider_value_scale = glade_xml_get_widget(g_glade_slider_xml, "slider_value_scale");
      g_assert(g_slider_value_scale);
      
      g_slider_ok_button = glade_xml_get_widget(g_glade_slider_xml, "slider_ok_button");
      g_assert(g_slider_ok_button);
      
      g_slider_cancel_button = glade_xml_get_widget(g_glade_slider_xml, "slider_cancel_button");
      g_assert(g_slider_cancel_button);

      GUI_BRANCH(g_glade_slider_xml, on_slider_value_scale_value_changed);
      GUI_BRANCH(g_glade_slider_xml, on_slider_value_scale_button_release_event);
      GUI_BRANCH(g_glade_slider_xml, on_slider_value_entry_activate);
      GUI_BRANCH(g_glade_slider_xml, on_slider_value_entry_changed);
      GUI_BRANCH(g_glade_slider_xml, on_slider_value_entry_insert_text);
      GUI_BRANCH(g_glade_slider_xml, on_slider_call_button_clicked);
      GUI_BRANCH(g_glade_slider_xml, on_slider_raise_min_button_clicked);
      GUI_BRANCH(g_glade_slider_xml, on_slider_raise_max_button_clicked);
      GUI_BRANCH(g_glade_slider_xml, on_slider_ok_button_clicked);
      GUI_BRANCH(g_glade_slider_xml, on_slider_cancel_button_clicked);
    }

  g_call = get_int();
  g_raise_min = get_int();
  g_raise_max = get_int();
  g_step_raise = get_int();

  gtk_range_set_range(GTK_RANGE(g_slider_value_scale), g_call, g_raise_max);
  gtk_range_set_increments(GTK_RANGE(g_slider_value_scale), g_step_raise, g_step_raise * 10);

  if (g_call)
    g_value = g_call;
  else
    g_value = g_raise_min;
  g_need_readjusting = FALSE;
  set_entry_value(g_value);
  set_slider_value(g_value);
    
  gui_center_window(GTK_WINDOW(g_slider_window));    

  return TRUE;
}
