/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include "gui.h"
#include "network.h"

extern gboolean cashier_visible;
extern char* lobby_visible;

static GtkWidget*	g_top_menu_window;
static GladeXML*	g_glade_top_menu_xml = 0;
static gboolean		g_disable_toggle_callback = FALSE;

void refresh_top_menu(void);

/*
 * forward declaration of close_lobby in lobby.c
 */
void	close_lobby(void);
void	notify_caller_quit(void);

void	on_table_list_toggled(GtkWidget *widget, gpointer user_data)
{
  (void) user_data;

  if(g_disable_toggle_callback)
    return;

  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
    {
      set_string("top_menu");
      set_string("table_list");
      set_string("yes");
      flush_io_channel();
    }
  else
    {
      notify_caller_quit();
      close_lobby();
    }
  
  refresh_top_menu();
}

void	on_outfit_toggled(GtkWidget *widget, gpointer user_data)
{
  (void) user_data;

  if(g_disable_toggle_callback)
    return;

  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
    {
      set_string("top_menu");
      set_string("outfit");
      set_string("yes");
      flush_io_channel();
    }
  else
    {
      notify_caller_quit();
      close_lobby();
    }
  
  refresh_top_menu();
}

/*
 * user_info.c function declaration
 */
void	close_user_info(void);

void	on_cashier_toggled(GtkWidget *widget, gpointer user_data)
{
  (void) user_data;

  if (g_disable_toggle_callback)
    return;

  if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
    {
      set_string("top_menu");
      set_string("cashier");
      set_string("yes");
      flush_io_channel();
    }
  else
    {
      /* FIXME */
      close_user_info();
    }
  
  refresh_top_menu();
}

static void	redo_window(GtkWidget* win)
{
  gtk_widget_hide(win);
  gtk_widget_unrealize(win);
  gtk_widget_show(win);
}

void refresh_top_menu(void) 
{
  if(!g_glade_top_menu_xml)
    return;

  g_disable_toggle_callback = TRUE;

  GtkWidget* cashier = glade_xml_get_widget(g_glade_top_menu_xml,
					    "cashier");
  GtkWidget* table_list = glade_xml_get_widget(g_glade_top_menu_xml,
					       "table_list");
  GtkWidget* outfit = glade_xml_get_widget(g_glade_top_menu_xml,
					   "outfit");
  if (lobby_visible)
    {
      if (!strcmp(lobby_visible, "table_list"))
	{
	  gtk_widget_set_sensitive(table_list, TRUE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(table_list), TRUE);
	  
	  gtk_widget_set_sensitive(cashier, FALSE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cashier), FALSE);

	  gtk_widget_set_sensitive(outfit, FALSE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outfit), FALSE);
	}
      else
	if(!strcmp(lobby_visible, "outfit"))
	  {
	    gtk_widget_set_sensitive(table_list, FALSE);
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(table_list), FALSE);

	    gtk_widget_set_sensitive(cashier, FALSE);
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cashier), FALSE);

	    gtk_widget_set_sensitive(outfit, TRUE);
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outfit), TRUE);
	  }
    }
  else
    {
      if(cashier_visible)
	{
	  gtk_widget_set_sensitive(table_list, FALSE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(table_list), FALSE);

	  gtk_widget_set_sensitive(cashier, TRUE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cashier), TRUE);

	  gtk_widget_set_sensitive(outfit, FALSE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outfit), FALSE);
	}
      else
	{
	  gtk_widget_set_sensitive(table_list, TRUE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(table_list), FALSE);
	  
	  gtk_widget_set_sensitive(cashier, TRUE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cashier), FALSE);
	  
	  gtk_widget_set_sensitive(outfit, TRUE);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outfit), FALSE);
	}
    }

  g_disable_toggle_callback = FALSE;

  redo_window(g_top_menu_window);
}

int	handle_top_menu(void)
{
  char*	tag = get_string();
  
  if (!g_glade_top_menu_xml)
    {
      g_glade_top_menu_xml = gui_load_widget("top_menu_window");
      g_top_menu_window = glade_xml_get_widget(g_glade_top_menu_xml,
						  "top_menu_window");
      g_assert(g_top_menu_window);
      GUI_BRANCH(g_glade_top_menu_xml, on_table_list_toggled);
      GUI_BRANCH(g_glade_top_menu_xml, on_outfit_toggled);
      GUI_BRANCH(g_glade_top_menu_xml, on_cashier_toggled);
      gui_top_right_window(GTK_WINDOW(g_top_menu_window));
    }

  g_disable_toggle_callback = TRUE;
  if(!strcmp(tag, "show"))
    gtk_widget_show_all(GTK_WIDGET(g_top_menu_window));
  else if(!strcmp(tag, "hide"))
    {
      gtk_widget_hide_all(g_top_menu_window); 
    }
  else if(!strcmp(tag, "params"))
    {
      char*	message = get_string();

      {
	GtkWidget* widget = glade_xml_get_widget(g_glade_top_menu_xml,
						 "table_info");
	gtk_label_set_text(GTK_LABEL(widget), message);
      }

      g_free(message);
      redo_window(g_top_menu_window);
    }

  g_disable_toggle_callback = FALSE;
  
  g_free(tag);

  return TRUE;
}
