#
# Copyright (C) 2004 Mekensleep
#
# Mekensleep
# 24 rue vieille du temple
# 75004 Paris
#       licensing@mekensleep.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# Authors:
#  Loic Dachary <loic@gnu.org>
#

from types import *

from underware.c_animated import CAnimated

FOREGROUND = 0
BACKGROUND = 1
ONCE = 0.0
FOREVER = -1.0
NOW = 0.0
ALL = -1

class Animated(CAnimated):
    """

    Animated object
    
    """

    def __init__(self, application, name):
        """\
Bind an animated 3D object that already exists in "application"
to python. The animated object is named after "name" according
to the following rules:

serial (for instance 2348) : a cal3d animated body matching
   the player identified with the serial
serial/nodename (for instance 2348/transform_card) : an osg::Node
   that is associated with the name transform_card and found
   in the part of the scenegraph associated with the player matching
   the serial 2348
nodename (for instance transform_bar) : an osg::Node that is associated
   with the name transform_bar. The search starts at the root of the
   scenegraph of the game.

"""
        if type(name) is IntType or type(name) is LongType:
            name = str(name)
        self.create(application, name)

    def run(self, name, *args, **kwargs):
        """\
Run the animation named "name", as found in the corresponding
cal3d configuration file or osg::Node animation path track.

Return an unique id that may be used to designate the animation
when calling the run method or setting a callback.

cal3d only parameters:
channel = FOREGROUND|BACKGROUND (default FOREGROUND)
length = duration in seconds|ONCE|FOREVER (default ONCE)
weight = float in the [0,1] interval (default 1.0)
fade_in = float (default 0.0)
fade_out = float (default 0.0)
delay = float (default 0.0)
"""
        return CAnimated.run(self,
                             kwargs.get("channel", FOREGROUND),
                             name,
                             kwargs.get("length", ONCE),
                             kwargs.get("weight", 1.0),
                             kwargs.get("fade_in", 0.0),
                             kwargs.get("fade_out", 0.0),
                             kwargs.get("delay", 0.0))
            

    def setStopCallback(self, name, funct, *args, **kwargs):
        """\
Run the "funct" callable as soon as the the animation "name" finishes
with whatever arguments are available in the *args, **kwargs.

Only available for cal3d animations.
"""
        if type(name) is IntType or type(name) is LongType:
            name = str(name)
        return CAnimated.setStopCallback(self,
                                         name,
                                         lambda: funct(*args, **kwargs))
        
                        
    def stop(self, name, *args, **kwargs):
        """\
Stop the "name" animation, if running.

cal3d only parameters:
fade_out = float (default 0.0)
delay = float (default 0.0)
"""
        if type(name) is IntType or type(name) is LongType:
            name = str(name)
        return CAnimated.stop(self,
                              name,
                              kwargs.get("fade_out", 0.0),
                              kwargs.get("delay", 0.0))

    def getDuration(self, name):
        """\
Return the total duration of the "name" animation in seconds.
"""
        return CAnimated.getDuration(self, name)

