/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "../../config_win32.h"
#endif

#include <osg/Vec3>

#ifdef _DEBUG // for Windows python23_d.lib is not in distribution... ugly but works
 #undef _DEBUG
 #include <Python.h>
 #define _DEBUG
#else
 #include <Python.h>
#endif

#define UNDERWAREAPI_BASE_INTERNAL
#define NO_UNDERWARE_C_API
#include <pyunderware.h>

static PyObject*
Vec32PyObject(const osg::Vec3& vec)
{
  return Py_BuildValue("(fff)",
		       vec.x(),
		       vec.y(),
		       vec.z());
}

static int
PyObject2Vec3(const PyObject* p_vec, osg::Vec3* vec)
{
  vec->x() = (float)PyFloat_AsDouble(PySequence_GetItem((PyObject*)p_vec, 0));
  vec->y() = (float)PyFloat_AsDouble(PySequence_GetItem((PyObject*)p_vec, 1));
  vec->z() = (float)PyFloat_AsDouble(PySequence_GetItem((PyObject*)p_vec, 2));
  return 1;
}

//
//
// Module
//
//

static char doc_verbose[] =
"Underware methods print verbose messages on stderr.\n";

static PyObject*
verbose(PyObject* self)
{
  // ! write code to increase verbosity
  Py_INCREF(Py_None);
  return Py_None;
}

static char doc_quiet[] =
"Underware methods are quiet.\n";

static PyObject*
quiet(PyObject* self)
{
  // ! write code to decrease verbosity
  Py_INCREF(Py_None);
  return Py_None;
}

static PyMethodDef base_methods[] = {
  { "verbose", (PyCFunction)verbose, METH_NOARGS, doc_verbose },
  { "quiet", (PyCFunction)quiet, METH_NOARGS, doc_quiet },
  {NULL, NULL, 0, NULL}
};

extern "C" {
     
DL_EXPORT(void)
initbase(void)
{
  int index;
  PyObject *module;
  PyObject *dictionary;
  PyObject *apiobj;
  static void* c_api[UNDERWAREAPI_BASE_NUMSLOTS];

  //
  // Declare methods, if any
  //
  if((module = Py_InitModule("base", base_methods)) == NULL) {
    /* error */
    return;
  }

  //
  // Incorporate new types, if any (see bltinmodule.c:_PyBuiltin_Init for
  // a good example)
  //
  dictionary = PyModule_GetDict(module);

  index = 0;

  c_api[index++] = (void*)&Vec32PyObject;
  c_api[index++] = (void*)&PyObject2Vec3;

  apiobj = PyCObject_FromVoidPtr(c_api, NULL);
  PyDict_SetItemString(dictionary, UNDERWAREAPI_LOCAL_ENTRY, apiobj);
  Py_DECREF(apiobj);
}

}
