/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "../../config_win32.h"
#endif

#include <iostream>
#include <iomanip>
#include <map>

#ifdef _DEBUG // for Windows python23_d.lib is not in distribution... ugly but works
 #undef _DEBUG
 #include <Python.h>
 #define _DEBUG
#else
 #include <Python.h>
#endif


#include <libxml/tree.h>

#define UNDERWAREAPI_MAFAPPLICATION_INTERNAL
#include <pyunderware.h>

#include <maf/mafexport.h>
#include <maf/maferror.h>
#include <PokerApplication.h>

//
//
// MAFApplication class
//
//

static void
MAFApplication_dealloc(MAFApplication_Object *self)
{
  if(self->_MAFApplication)
    delete self->_MAFApplication;
  self->ob_type->tp_free((PyObject *)self);
}

static PyObject *
MAFApplication_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
  MAFApplication_Object *self;

  assert(type != NULL && type->tp_alloc != NULL);

  self = (MAFApplication_Object*)type->tp_alloc(type, 0);

  if(self != NULL) {
    try {
      self->_MAFApplication = new PokerApplication();
    } catch(MAFError* error) {
      type->tp_free(self);
      self = 0;
      error->NotifyPython();
      delete error;
    }
  }

  return (PyObject*)self;
}

static char run_doc[] =
"MAFApplication main loop\n"
"\n";

static PyObject *
MAFApplication_run(MAFApplication_Object *self, PyObject *args)
{
  try {
    self->_MAFApplication->Init();
    self->_MAFApplication->Run();
  } catch(MAFError* error) {
    error->NotifyPython();
    delete error;
    return 0;
  }
  Py_INCREF(Py_None);
  return Py_None;
}

static char initwindow_doc[] =
"MAFApplication window initialization\n"
"\n";

static PyObject *
MAFApplication_initwindow(MAFApplication_Object *self, PyObject *args)
{
  try {
    self->_MAFApplication->SplashScreen();
  } catch(MAFError* error) {
    error->NotifyPython();
    delete error;
    return 0;
  }
  Py_INCREF(Py_None);
  return Py_None;
}

static char setreactor_doc[] =
"MAFApplication set reactor\n"
"\n";

static PyObject *
MAFApplication_setreactor(MAFApplication_Object *self, PyObject *args)
{
  PyObject* reactor = 0;
  
  if(!PyArg_ParseTuple(args, "O:setreactor", &reactor))
    return NULL;

  self->_MAFApplication->SetReactor(reactor);
  Py_INCREF(Py_None);
  return Py_None;
}

static char setheaders_doc[] =
"MAFApplication set headers\n"
"\n";

static PyObject *
MAFApplication_setheaders(MAFApplication_Object *self, PyObject *args)
{
  PyObject* settings = 0;
  PyObject* sequence = 0;
  MAFApplication::Headers headers;
  
  if(!PyArg_ParseTuple(args, "OO:setheaders", &settings, &sequence))
    return NULL;
  headers["settings"] = (xmlDocPtr) PyCObject_AsVoidPtr(settings);
  headers["sequence"] = (xmlDocPtr) PyCObject_AsVoidPtr(sequence);

  self->_MAFApplication->SetHeaders(headers);
  Py_INCREF(Py_None);
  return Py_None;
}

static char stop_doc[] =
"stop MAFApplication main loop\n"
"\n";

static PyObject *
MAFApplication_stop(MAFApplication_Object *self, PyObject *args)
{
  self->_MAFApplication->Quit();
  Py_INCREF(Py_None);
  return Py_None;
}

static char setametista_doc[] =
"setametista MAFApplication main loop\n"
"\n";

static PyObject *
MAFApplication_setametista(MAFApplication_Object *self, PyObject *args)
{
  bool value;
  if(!PyArg_ParseTuple(args, "b:SetAmetista", &value))
    return NULL;

  self->_MAFApplication->SetAmetista(value);
  Py_INCREF(Py_None);
  return Py_None;
}

static char setclient_doc[] =
"MAFApplication set client\n"
"\n";

static PyObject *
MAFApplication_setclient(MAFApplication_Object *self, PyObject *args)
{
  PyObject* client;

  if(!PyArg_ParseTuple(args, "O:setclient", &client))
    return NULL;

  try {
    self->_MAFApplication->SetClient(client);
  } catch(MAFError* error) {
    error->NotifyPython();
    delete error;
  }

  Py_INCREF(Py_None);
  return Py_None;
}

static char setpyscheduler_doc[] =
"MAFApplication set pyscheduler\n"
"\n";

static PyObject *
MAFApplication_setpyscheduler(MAFApplication_Object *self, PyObject *args)
{
  PyObject* pyscheduler;

  if(!PyArg_ParseTuple(args, "O:SetPyScheduler", &pyscheduler))
    return NULL;

  try {
    PokerApplication* application = dynamic_cast<PokerApplication*>(self->_MAFApplication);
    application->SetPyScheduler(pyscheduler);
  } catch(MAFError* error) {
    error->NotifyPython();
    delete error;
  }

  Py_INCREF(Py_None);
  return Py_None;
}

static char pythonaccept_doc[] =
"MAFApplication receive packet from server\n"
"\n";

static PyObject *
MAFApplication_pythonAccept(MAFApplication_Object *self, PyObject *args)
{
  PyObject* event = 0;

  if(!PyArg_ParseTuple(args, "O:pythonAccept", &event))
    return NULL;

  try {
    self->_MAFApplication->PythonAccept(event);
  } catch(MAFError* error) {
    error->NotifyPython();
    delete error;
  }

  Py_INCREF(Py_None);
  return Py_None;
}

static PyMethodDef MAFApplication_methods[] = {
  {"Run",	(PyCFunction)MAFApplication_run, METH_NOARGS, run_doc},
  {"Stop",	(PyCFunction)MAFApplication_stop, METH_VARARGS, stop_doc},
  {"InitWindow",	(PyCFunction)MAFApplication_initwindow, METH_NOARGS, initwindow_doc},
  {"SetReactor",	(PyCFunction)MAFApplication_setreactor, METH_VARARGS, setreactor_doc},
  {"SetHeaders",	(PyCFunction)MAFApplication_setheaders, METH_VARARGS, setheaders_doc},
  {"SetAmetista",	(PyCFunction)MAFApplication_setametista, METH_VARARGS, setametista_doc},
  {"SetClient",	(PyCFunction)MAFApplication_setclient, METH_VARARGS, setclient_doc},
  {"SetPyScheduler",	(PyCFunction)MAFApplication_setpyscheduler, METH_VARARGS, setpyscheduler_doc},
  {"PythonAccept",	(PyCFunction)MAFApplication_pythonAccept, METH_VARARGS, pythonaccept_doc},
  {NULL,	NULL}		/* sentinel */
};

static char MAFApplication_doc[] =
"MAFApplication object\n"
"\n";

static PyTypeObject mafapplication_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"CMAFApplication",                           	/* tp_name */	  
	sizeof(MAFApplication_Object),	     	/* tp_basicsize */
	0,				     	/* tp_itemsize */ 
	(destructor)MAFApplication_dealloc,		/* tp_dealloc */
	0,					/* tp_print */
	0,			 		/* tp_getattr (obsoleted by tp_getattro) */
	0,			 		/* tp_setattr (obsoleted by tp_setattro) */
	0,					/* tp_compare */
	0,					/* tp_repr */
	0,					/* tp_as_number */
	0,					/* tp_as_sequence */
	0,					/* tp_as_mapping */
	0,					/* tp_hash */
	0,					/* tp_call */
	0,					/* tp_str */
	0,					/* tp_getattro */
	0,					/* tp_setattro */
	0,					/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
	MAFApplication_doc,				/* tp_doc */
	0,					/* tp_traverse */
	0,					/* tp_clear */
	0,					/* tp_richcompare */
	0,					/* tp_weaklistoffset */
	0,					/* tp_iter */
	0,					/* tp_iternext */
	MAFApplication_methods,			/* tp_methods */
	0,					/* tp_members */
	0,					/* tp_getset */
	0,					/* tp_base */
	0,					/* tp_dict */
	0,					/* tp_descr_get */
	0,					/* tp_descr_set */
	0,					/* tp_dictoffset */
	0,					/* tp_init */
	0,					/* tp_alloc */
	MAFApplication_new,				/* tp_new */
	0,					/* tp_free */
	0,					/* tp_is_gc */
	0,					/* tp_bases */
	0,					/* tp_mro */
	0,					/* tp_cache */
	0,					/* tp_subclasses */
	0					/* tp_weaklist */
};

//
//
// Module
//
//

static PyMethodDef mafapplication_methods[] = {
  {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC
initc_mafapplication(void)
{
  int index;
  PyObject *module;
  PyObject *dictionary;
  PyObject *apiobj;
  static void* c_api[UNDERWAREAPI_MAFAPPLICATION_NUMSLOTS];

  //
  // Declare methods, if any
  //
  if((module = Py_InitModule("c_mafapplication", mafapplication_methods)) == NULL) {
    /* error */
    return;
  }

  if(PyType_Ready(&mafapplication_Type) < 0) return;
  
  dictionary = PyModule_GetDict(module);
  if(PyDict_SetItemString(dictionary, "CMAFApplication", (PyObject*)&mafapplication_Type) < 0)
    return;

  index = 0;

  c_api[index++] = &mafapplication_Type;

  apiobj = PyCObject_FromVoidPtr(c_api, NULL);
  PyDict_SetItemString(dictionary, UNDERWAREAPI_LOCAL_ENTRY, apiobj);
  Py_DECREF(apiobj);

  import_underware_base();
}
