#
# Copyright (C) 2004 Mekensleep
#
# Mekensleep
# 24 rue vieille du temple
# 75004 Paris
#       licensing@mekensleep.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# Authors:
#  Loic Dachary <loic@gnu.org>
#
from string import replace
from types import *
from os.path import exists, expanduser
import libxml2
import pycurl
import re

def loadURL(url):
    content = []
    def accumulate(buffer):
        content.append(buffer)

    curl = pycurl.Curl()
    curl.setopt(pycurl.FOLLOWLOCATION, 1)
    curl.setopt(pycurl.MAXREDIRS, 5)
    curl.setopt(pycurl.NOSIGNAL, 1)
    curl.setopt(pycurl.WRITEFUNCTION, accumulate)
    curl.setopt(pycurl.URL, url)
    curl.perform()
    curl.close()
    a=''.join(content)
    a=replace(a,"\r","")
    return a

class ConfigError(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

class Config:
    """

    Read / parse XML configuration files

    """

    def __init__(self, dirs):
        self.url = None
        self.path = None
        self.header = None
        self.doc = None
        self.dirs = [ expanduser(dir) for dir in dirs ]

#    def __del__(self):
#        self.release()

    def release(self):
        if self.doc:
            self.doc.freeDoc()
            del self.doc
            self.doc = None
        if self.header:
            self.header.xpathFreeContext()
            del self.header
            self.header = None
        
    def saveHeader(self):
        if not self.path:
            print "unable to write back to %s" % self.url
            return
        self.doc.saveFile(self.path)
        
    def loadHeader(self, headers, silent = False):
        if self.doc or self.header:
            self.release()
#        print "headers %s %s" % ( headers, self.dirs )
        if type(headers) is StringType:
            headers = [ headers ]
        self.doc = None
        path = None
        for header in headers:
            if header[:5] == "file:":
                tmp = header[5:]
                if tmp[0] == "~":
                    abspath = expanduser(tmp)
                    if exists(abspath):
                        path = abspath
                elif tmp[0] != "/":
                    for dir in self.dirs:
                        abspath = expanduser(dir and (dir + "/" + tmp) or tmp )
                        if exists(abspath):
                            path = abspath
                            break
                else:
                    if exists(tmp):
                        path = tmp
            if path:
                header = "file:" + path
                break

        self.url = header
        if not silent:
            print "loading %s" % header

        if header[:5] == "file:":
            if not path:
                print "%s file(s) not found (path for file: is %s)" % ( headers, self.dirs )
                return
            else:
                self.path = path
                self.doc = libxml2.parseFile(path)
        else:
            content = loadURL(header)
            self.doc = libxml2.parseMemory(content, len(content))

        if self.doc:
            self.header = self.doc.xpathNewContext()

    def headerGetList(self, name):
        result = self.header.xpathEval(name)
        return [o.content for o in result]

    def headerGetInt(self, name):
        string = self.headerGet(name)
        if re.match("[0-9]+$", string):
            return int(string)
        else:
            return 0
        
    def headerGet(self, name):
#        print "headerGet: fetch %s" % name
        results = self.header.xpathEval(name)
        return results and results[0].content or ""
        
    def headerSet(self, name, value):
        results = self.header.xpathEval(name)
        results[0].setContent(value)
        
    def headerGetProperties(self, name):
        results = []
        for node in self.header.xpathEval(name):
            result = {}
            property = node.properties
            while property != None:
                result[property.name] = property.content
                property = property.next
            results.append(result)
        return results

