/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_mesh.cxx
 *
 * @brief   Describe mesh
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2001/04
 *
 * @version $Id: exg_mesh.cpp,v 1.1 2004/10/06 15:05:46 izidor79 Exp $
 *
 ****************************************************************************/

#include <exg/exg.h>
#include <exg/exg_mesh.h>
#include <exg/exg_visitor.h>
#include <fstream>
#include <sstream>

namespace exg
{
  Mesh::~Mesh()
  {
    // kill circular reference (material <-> polygon)
    VectorObjectPointer* polygons = (*this)["polygons"]->AsVectorObjectPointer();
    for(VectorObjectPointer::iterator polygon = polygons->begin();
	polygon != polygons->end();
	polygon++)
      (*polygon)->AsPolygon()->erase("material");
  }

  void Mesh::Traverse(Visitor& visitor) 
  {
    int nb;
//    std::cout << "Traverse mesh\n";
    nb=GetNbMaterials();
    for (int i=0;i<nb;i++)
      GetMaterial(i)->Accept(visitor);

    nb=GetNbPolygons();
    for (int i=0;i<nb;i++)
      GetPolygon(i)->Accept(visitor);
    
    nb=GetNbPoints();
    for (int i=0;i<nb;i++)
      GetPoint(i)->Accept(visitor);
    
    nb=GetNbFiles();
    for (int i=0;i<nb;i++)
      GetFile(i)->Accept(visitor);
  }

  std::ostream& Mesh::operator<<(std::ostream& o)
  {
    Indent(indent-1,o);
    o << "Mesh\n";
    return MapObjectPointer::operator<<(o);
  }

  void Mesh::ORepair(IOContext* context)
  {
//	  Pointer<VectorObjectPointer> points = new VectorObjectPointer;
//	  Pointer<VectorObjectPointer> polygons = new VectorObjectPointer;
//	  Pointer<VectorObjectPointer> materials = new VectorObjectPointer;
//
//	  for(std::map<int, Pointer<Object> >::iterator i = context->mSerial2Object.begin();
//		  i != context->mSerial2Object.end();
//		  i++) {
//
//			  if(i->second == 0)
//				  continue;
//
//			  switch(i->second->GetType()) {
//	  case Object::POINT:
//		  points->push_back(i->second);
//		  break;
//	  case Object::POLYGON:
//		  polygons->push_back(i->second);
//		  break;
//	  case Object::MATERIAL:
//		  materials->push_back(i->second);
//		  break;
//	  default:
//		  break;
//			  }
//		  }
//
//		  if((*this)["points"]->AsVectorObjectPointer()->size() != points->size())
//			  (*this)["points"] = points.Get();
//		  if((*this)["polygons"]->AsVectorObjectPointer()->size() != polygons->size())
//			  (*this)["polygons"] = polygons.Get();
//		  if((*this)["materials"]->AsVectorObjectPointer()->size() != materials->size())
//			  (*this)["materials"] = materials.Get();
  }
}
