/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_polygon.cxx
 *
 * @brief   Describe polygon
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2001/04
 *
 * @version $Id: exg_polygon.cpp,v 1.1 2004/10/06 15:05:46 izidor79 Exp $
 *
 ****************************************************************************/

#include <exg/exg.h>
#include <exg/exg_polygon.h>
#include <exg/exg_material.h>
#include <exg/exg_visitor.h>

namespace exg
{

void Polygon::SetMaterial(Material* material) 
{ 
  (*this)["material"] = material;
  material->AddPolygon(this);
}

  void Polygon::Traverse(Visitor& visitor)
  {
    int nb=GetNbVertexes();
//    std::cout << "Traverse polygon with " << this << " " << nb << std::endl;
    for (int i=0;i<nb;i++)
      GetVertex(i)->Accept(visitor);
  }

  Vertex* Polygon::GetVertex(int i) { 
    VectorObjectPointer* v=(*find("vertexes")).second->AsVectorObjectPointer();
    return (*v)[i]->AsVertex();
  }

  std::ostream& Polygon::operator<<(std::ostream& o)
  {
    Indent(indent-1,o);
    o << "Polygon\n";
    return MapObjectPointer::operator<<(o);
  }
}
