/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_visitor.cxx
 *
 * @brief   base for material exchange
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2001/04
 *
 * @version $Id: exg_visitor_utils.cpp,v 1.1 2004/10/06 15:05:46 izidor79 Exp $
 *
 ****************************************************************************/

#include <exg/exg.h>
#include <exg/exg_visitor_utils.h>
#include <exg/exg_object.h>
#include <exg/exg_mesh.h>
#include <exg/exg_vector3.h>
#include <iostream>

namespace exg
{
  //
  // VisitorDump
  //
  std::ostream& operator<<(std::ostream& o,Object& s) 
  {
    return s.operator<<(o);
  }

  void VisitorDump::Apply(Mesh& node) {
    std::cout << node;
  }

  void VisitorDump::Apply(Object& node) {}
  void VisitorDump::Apply(Material& node) {}
  void VisitorDump::Apply(Polygon& node) {}
  void VisitorDump::Apply(Vertex& node) {}
  void VisitorDump::Apply(Point& node) {}
  void VisitorDump::Apply(File& node) {}

  //
  // VisitorRemoveNormal
  //
  void VisitorRemoveNormal::Apply(Material& node)
  {
    Material::iterator f=node.find("normal");
    if (f==node.end())
      return;

    node.erase(f);
  }

  void VisitorRemoveNormal::Apply(Vertex& node)
  {
    Vertex::iterator f=node.find("normal");
    if (f==node.end())
      return;

    node.erase(f);
  }

  //
  // VisitorRemoveTextureChannel
  //
  void VisitorRemoveTextureChannel::Apply(Material& node)
  {
    Material::iterator f=node.find("maps");
    if (f==node.end())
      return;

    VectorObjectPointer* v=(*f).second->AsVectorObjectPointer();
    MapObjectPointer* map;
    MapObjectPointer::iterator itm;
    File* file;
    for (VectorObjectPointer::iterator i=v->begin();i!=v->end();) {
      map=(*i)->AsMapObjectPointer();
      itm=map->find("name");
      file=(*itm).second->AsFile();
      if (file->GetName()==mChannel)
        v->erase(i);
      else
        i++;
    }
    
    // no more channel so remove maps
    if (v->empty())
      node.erase(f);
  }

  void VisitorRemoveTextureChannel::Apply(Vertex& node)
  {
    Vertex::iterator f=node.find(mChannel);
    if (f==node.end())
      return;
    
    node.erase(f);
  }

  void VisitorTransform::Apply(Point& node)
  {
    Vector3f r=mTransform*node.GetPosition();
    node.SetPosition(r);
  }
  
  void VisitorTransform::Apply(Vertex& node)
  {
    Vertex::iterator i=node.find("normal");
    if ( i != node.end()) {
      VectorFloat* vf=(*i).second->AsVectorFloat();
      Vector3f n((*vf)[0],(*vf)[1],(*vf)[2]);
      n=mTransform*n;
      (*vf)[0]=n[0];
      (*vf)[1]=n[1];
      (*vf)[2]=n[2];
    }
  }
}
