/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH

#include <maf/cursor.h>
#include <maf/application.h>
#include <maf/window.h>

#include <osg/Group>
#include <osg/StateSet>
#include <osg/MatrixTransform>
#include <osg/Projection>
#include <osg/PositionAttitudeTransform>
#include <osg/Material>
#include <iostream>

#endif


MAFCursorModelSDL::MAFCursorModelSDL()
{
}

void MAFCursorModelSDL::Init()
{
}

void MAFCursorModelSDL::SetCursor(int cursor)
{
  g_assert(cursor>=0 && cursor<(int)mCursors.size());
  SDL_SetCursor(mCursors[cursor]);
}

int MAFCursorModelSDL::GetNbCursor()
{
  return mCursors.size();
}
void MAFCursorModelSDL::ShowCursor(bool state)
{
  SDL_ShowCursor(state ? SDL_ENABLE : SDL_DISABLE);
}

void MAFCursorModelSDL::WarpMouse(int x,int y)
{
  SDL_WarpMouse(x, y);
}






MAFCursorModelGL::MAFCursorModelGL(MAFApplication* application)
{
  mApplication=application;
  if (!application)
    g_error("MAFCursorModelGL::MAFCursorModelGL can't use gl cursor without application");
}


void MAFCursorModelGL::Init()
{
  mWarpMouseOccur=false;
  mPAT = new osg::PositionAttitudeTransform;
  osg::Quat q;

  // SHOULD BE PUT IN HUDGROUP INSTEAD

  osg::StateSet* stateset = mPAT->getOrCreateStateSet();
  stateset->setMode(GL_LIGHTING, osg::StateAttribute::OVERRIDE|osg::StateAttribute::OFF);
  // disable depth test, and make sure that the hud is drawn after everything 
  // else so that it always appears ontop.
  stateset->setMode(GL_DEPTH_TEST, osg::StateAttribute::OVERRIDE|osg::StateAttribute::OFF);
  stateset->setRenderBinDetails(11,"RenderBin");

  osg::Material *mat = new osg::Material;
  mat->setColorMode(osg::Material::AMBIENT_AND_DIFFUSE);
  stateset->setAttributeAndModes(mat, osg::StateAttribute::OVERRIDE|osg::StateAttribute::ON);
      
  // create the hud.
  osg::MatrixTransform* modelview_abs = new osg::MatrixTransform;
  modelview_abs->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
  modelview_abs->setMatrix(osg::Matrix::identity());
  modelview_abs->addChild(mPAT.get());
    
  osg::Projection *project = new osg::Projection;
  project->addChild(modelview_abs);
  project->setName("MAFCursor");
  mNode = project;
}


void MAFCursorModelGL::WarpMouse(int x,int y)
{ 
  mWarpMouseOccur=true;
  mWarpX=x;
  mWarpY=y;
}

void MAFCursorModelGL::UpdatePosition(int screenX, int screenY)
{
  struct ScreenToGL
  {
    static inline float doit(float screenPos, float screenL) {return screenPos*2.0f/screenL - 1.0f;}
  };
  float mX = ScreenToGL::doit(screenX*1.0,mApplication->GetWindow(true)->GetWidth());
  float mY = -ScreenToGL::doit(screenY*1.0, mApplication->GetWindow(true)->GetHeight());
  mPAT->setPosition(osg::Vec3(mX, mY, 0.0f));
}

void MAFCursorModelGL::Update()
{
  if (mWarpMouseOccur) {
    UpdatePosition(mWarpX,mWarpY);
  }
  mWarpMouseOccur=false;
  mWarpX=mWarpY=0;
}

void MAFCursorModelGL::SetCursor(int cursor)
{
  g_assert(cursor>=0 && cursor<(int)mCursors.size());
  mPAT->removeChild(0,mPAT->getNumChildren());
  mPAT->addChild(mCursors[cursor].get());
}

void MAFCursorModelGL::ShowCursor(bool state)
{
  if (state)
    mPAT->setNodeMask(MAF_VISIBLE_MASK);
  else
    mPAT->setNodeMask(~(MAF_VISIBLE_MASK | MAF_COLLISION_MASK));

}

void MAFCursorModelGL::InitCursor()
{
  g_assert(mApplication);
  mApplication->GetScene()->GetModel()->mGroup->addChild(mNode.get());
  SDL_ShowCursor(SDL_DISABLE);
}

void MAFCursorModelGL::ReleaseCursor()
{
  g_assert(mApplication);
  mApplication->GetScene()->GetModel()->mGroup->removeChild(mNode.get());
  SDL_ShowCursor(SDL_ENABLE);
}

int MAFCursorModelGL::GetNbCursor()
{
  return mCursors.size();
}






MAFCursorController::~MAFCursorController()
{
}

MAFCursorController::MAFCursorController():mCurrentCursor(0),mPreviousCursor(0),mShowCursor(true)
{
}

void MAFCursorController::Init()
{
  MAFController::Init();
}

void MAFCursorController::ShowCursor(bool state)
{
  GetModel()->ShowCursor(state);
  mShowCursor=state;
}

void MAFCursorController::InitCursor()
{
  GetModel()->InitCursor();
}
void MAFCursorController::ReleaseCursor()
{
  GetModel()->ReleaseCursor();
}


void MAFCursorController::SetCursor(int cursor)
{
  mPreviousCursor=mCurrentCursor;
  mCurrentCursor=cursor;
  GetModel()->SetCursor(cursor);
}
int MAFCursorController::GetNbCursors()
{
  return GetModel()->GetNbCursor();
}

void MAFCursorController::RestoreCursor()
{
  GetModel()->SetCursor(mPreviousCursor);
  int a=mCurrentCursor;
  mCurrentCursor=mPreviousCursor;
  mPreviousCursor=a;
}

void MAFCursorController::WarpMouse(int x,int y)
{
  GetModel()->WarpMouse(x,y);
}


bool MAFCursorController::Update(MAFApplication* application)
{
  SDL_Event*	event = application->GetLastEvent(this);
  if (event) {
    switch (event->type) {
    case SDL_MOUSEBUTTONDOWN:
      switch (event->button.button) {
      case SDL_BUTTON_LEFT:
	break;
      case SDL_BUTTON_RIGHT:
	break;
      }
      break;
    case SDL_MOUSEBUTTONUP:
      break;
    case SDL_MOUSEMOTION:
      GetModel()->UpdatePosition(event->motion.x,event->motion.y);
      break;
    }
  } else {
    GetModel()->Update();
  }
  return true;
}
