/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Loic Dachary <loic@gnu.org>
*  Henry Precheur <henry at precheur dot org>
*  Cedric Pinson <cpinson@freesheep.org>
*  Igor kravtchenko <igor@obraz.net>
*
*/

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/maferror.h>
#include <maf/data.h>
#include <maf/camera.h>
#include <maf/MultipleAnimationPathCallback.h>
#include <maf/osghelper.h>
#include <maf/depthmask.h>

#include <sys/types.h>
#include <signal.h>

#include <glib.h>

#include <osgDB/Registry>
#include <osgDB/ReadFile>
#include <osgDB/WriteFile>

#include <osg/Node>
#include <osg/Group>
#include <osg/MatrixTransform>
#include <osg/Geode>
#include <osg/Matrix>
#include <osg/AutoTransform>
#include <osg/BlendFunc>
#include <osg/NodeVisitor>
#include <osg/Geometry>
#include <osg/Material>
#include <osg/Texture2D>
#include <osg/TextureCubeMap>
#include <osg/StateSet>
#include <osg/Stencil>
#include <osg/Light>
#include <osg/LightModel>
#include <osg/LightSource>
#include <osg/Billboard>
#include <osg/Geode>
#include <osg/Drawable>
#include <osg/ShapeDrawable>
#include <osg/MatrixTransform>
#include <osg/LightSource>
#include <osg/LightModel>
#include <osg/PositionAttitudeTransform>
#include <osgCal/CoreModel> // remove
#include <osg/Geometry>
#include <osg/CullStack>
#include <osg/Fog>
#include <osg/NodeVisitor>
#include <osgUtil/TriStripVisitor>
#include <osgUtil/Optimizer>
#include <osg/TexEnvCombine>
#include <osg/TexGen>
#include <osg/TexMat>
#include <osg/Stencil>

#include <exg/exg_material.h>
#include <exg/exg_quaternion.h>
#include <exg/exg_mesh.h>
#include <exg/exg_polygon.h>

#include <osgText/Font>

#include <cal3d/tinyxml.h>

#endif

#include <mafStdAfx.h>

#define NEW_GENERATION_OF_MESH

/**
*  doesn't work yet
*/
namespace osg{

  class AutoTransformBillboard : public Transform
  {
  public:
    AutoTransformBillboard() :
      _axis(Vec3(0,1,0)),
      _matrixDirty(true)
    {
      //    setReferenceFrame(RELATIVE_TO_ABSOLUTE);
    }

    /*
     * TODO: clean unsued parametera
     */
    AutoTransformBillboard(const AutoTransformBillboard& pat,const CopyOp& copyop):
      Transform(pat,copyop),
      _axis(pat._axis),
      _lookLocal(pat._lookLocal),
      _upLocal(pat._upLocal),
      _matrixDirty(pat._matrixDirty),
      _cachedMatrix(pat._cachedMatrix),
      _previousEyePoint(pat._previousEyePoint),
      _position(pat._position),
      _rotation(pat._rotation),
      _scale(pat._scale),
      _pivotPoint(pat._pivotPoint) {
    }

    osg::Object* cloneType() const { return new AutoTransformBillboard(); }
    osg::Object* clone(const osg::CopyOp& copyop) const { return new AutoTransformBillboard (*this,copyop); }


    bool computeLocalToWorldMatrix(Matrix& matrix,NodeVisitor*) const {
      if (_matrixDirty) computeMatrixB();

      if (_referenceFrame==RELATIVE_RF) {
	matrix.preMult(_cachedMatrix);
      } else { // absolute
	matrix = _cachedMatrix;
      }
      return true;
    }

    void computeMatrixB() const {

      //    osg::Vec3 e(_lookLocal);
      osg::Vec3 e(_previousEyePoint);
      e.normalize();
      osg::Vec3 u(_axis);
      osg::Vec3 s(u^e);
      _cachedMatrix.makeIdentity();
      _cachedMatrix(0,0)=s[0];
      _cachedMatrix(0,1)=s[1];
      _cachedMatrix(0,2)=s[2];
      _cachedMatrix(1,0)=u[0];
      _cachedMatrix(1,1)=u[1];
      _cachedMatrix(1,2)=u[2];
      _cachedMatrix(2,0)=e[0];
      _cachedMatrix(2,1)=e[1];
      _cachedMatrix(2,2)=e[2];
    }

    bool computeWorldToLocalMatrix(Matrix& matrix,NodeVisitor*) const
    {
      assert(0); // for test
      if (_referenceFrame==RELATIVE_RF) {
	matrix.postMult(osg::Matrix::translate(-_position)*
			osg::Matrix::rotate(_rotation.inverse())*
			osg::Matrix::scale(1.0f/_scale.x(),1.0f/_scale.y(),1.0f/_scale.z())*
			osg::Matrix::translate(_pivotPoint));
      } else { // absolute
	matrix = osg::Matrix::translate(-_position)*
	  osg::Matrix::rotate(_rotation.inverse())*
	  osg::Matrix::scale(1.0f/_scale.x(),1.0f/_scale.y(),1.0f/_scale.z())*
	  osg::Matrix::translate(_pivotPoint);
      }
      return true;
    }


    void accept(NodeVisitor& nv) {
      // if app traversal update the frame count.
#if 1
      if (nv.getVisitorType()==NodeVisitor::UPDATE_VISITOR) {
      } else
#endif
	if (nv.getVisitorType()==NodeVisitor::CULL_VISITOR) {
	  CullStack* cs = dynamic_cast<CullStack*>(&nv); 
	  if (cs) {
	    const osg::Vec3& eyePoint = cs->getEyeLocal();    
	    //						const osg::Matrix& projection = cs->getProjectionMatrix();
	    _upLocal=cs->getUpLocal();
	    _lookLocal=cs->getLookVectorLocal();

	    //            bool doUpdate = true;
	    _previousEyePoint = eyePoint;
	    _matrixDirty = true;
	  }
	}

      // now do the proper accept
      Transform::accept(nv);
    }

  protected:
    Vec3 _axis;
    Vec3 _lookLocal;
    Vec3 _upLocal;
    bool _matrixDirty;
    mutable Matrix _cachedMatrix;
    mutable Vec3 _previousEyePoint;
    mutable Vec3 _position;
    mutable Quat _rotation;
    mutable Vec3 _scale;
    Vec3 _pivotPoint;
  };
}



#define MAX_LIGHT 7

static int nbTotalFaces=0;
static int nbTotalDrawable=0;


class EXGConverter : public exg::Visitor
{

public:

	EXGConverter(const std::string& dir, const std::string& file, bool isLighted, osgDB::ReaderWriter::Options* options) :
	  Visitor(ONCE),
		  mGeode(0),
		  mGeometry(0),
		  mDir(dir),
		  mFile(file),
	  	  mIsLighted(isLighted),
	  	  mOptions(options)
	  
	  {
		  mPath = mDir + "/" + mFile;
		  std::string suffix = ".escn";
		  mBase = mPath.substr(0, mPath.size() - suffix.size());
	  }

	  void Apply(exg::Object& node) {
		  g_critical("EXGConverter:%s: node type %s not implemented", mBase.c_str(), node.ClassName());
	  }

	  void Apply(exg::File& node) {
		  g_critical("EXGConverter:%s: node type %s not implemented", mBase.c_str(), node.ClassName());
	  }

	  void Apply(exg::Material& node) {
		  g_assert(mGeode != 0);

		  if (!node.GetNbPolygons())
			  return;
		  mGeometry = new osg::Geometry;
		  nbTotalDrawable++;

		  bool bUseStencil = false;
		  //		  const std::string &materialName = node.GetName();

		  exg::Object *stenciled = node.GetProperty("stenciled");
		  if (stenciled)
			  bUseStencil = true;

		osg::StateSet *state = mGeometry->getOrCreateStateSet();
		osg::ref_ptr<osg::Material> material = new osg::Material;
		state->setAttributeAndModes(material.get(), osg::StateAttribute::ON);

		osg::BlendFunc *blendState = NULL;
		DepthMask *depthMask = NULL;

		exg::VectorFloat *color;

		// ambient
		osg::Vec4f ambientColor(0, 0, 0, 1);
		exg::Object *ambient = node.GetProperty("ambient");
		if (ambient) {
			color = ambient->AsVectorFloat();
			if(color) {
				osg::Vec4 col( (*color)[0], (*color)[1], (*color)[2], (*color)[3] );
				ambientColor = col;
			}
		}
		material->setAmbient(osg::Material::FRONT_AND_BACK, ambientColor);

		// emissive
		osg::Vec4f emissiveColor(0, 0, 0, 1);
		exg::Object *emissive = node.GetProperty("emissive");
		if (emissive) {
			color = emissive->AsVectorFloat();
			if(color) {
				osg::Vec4 col( (*color)[0], (*color)[1], (*color)[2], (*color)[3] );
				emissiveColor = col;
			}
		}
		material->setEmission(osg::Material::FRONT_AND_BACK, emissiveColor);

		// diffuse
		osg::Vec4f diffuseColor(1, 1, 1, 1);
		exg::Object *diffuse = node.GetProperty("diffuse");
		if (diffuse) {
			color = diffuse->AsVectorFloat();
			if(color) {
				osg::Vec4 col( (*color)[0], (*color)[1], (*color)[2], (*color)[3] );

				diffuseColor = col;
				material->setAlpha(osg::Material::FRONT_AND_BACK, col[3]); // set the transparency of alpha

				if (emissiveColor[3] < 0.9999999) {
					if (!depthMask)
						depthMask = new DepthMask(0);

					if (!blendState)
						blendState = new osg::BlendFunc;

					blendState->setFunction(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

					g_debug("Material %s has blend property %f",node.GetName().c_str(),(*color)[3]);
				}
			}
		}
		material->setDiffuse(osg::Material::FRONT_AND_BACK, diffuseColor);

		// specular
		osg::Vec4f specularColor(0, 0, 0, 1);
		exg::Object *specular = node.GetProperty("specular");
		if (specular) {
			color = specular->AsVectorFloat();
			if(color) {
				osg::Vec4 col( (*color)[0], (*color)[1], (*color)[2], (*color)[3] );
				specularColor = col;
				material->setShininess(osg::Material::FRONT_AND_BACK, 50.0f); //TODO: configure me from file
			}
		}
		material->setSpecular(osg::Material::FRONT_AND_BACK, specularColor);

		//exg::Object *shininess = node.GetProperty("shininess");

		exg::Object *blend = node.GetProperty("blend");
		if (blend) {
			exg::VectorString* transparency = blend->AsVectorString();
			if(transparency) {
				if ((*transparency)[0]=="additive") { // additive but use alpha from source

					if (!depthMask)
						depthMask = new DepthMask(0);

					if (!blendState)
						blendState = new osg::BlendFunc;

					blendState->setFunction(GL_SRC_ALPHA, GL_ONE);
					g_debug("Material %s has additive blend property",node.GetName().c_str());
				}
			}
		}


		if (node.GetProperty("maps") && node.GetNbPolygons() > 0) {
			exg::VectorObjectPointer* maps = node.GetProperty("maps")->AsVectorObjectPointer();
			if(maps) {
				exg::MapObjectPointer* map = NULL;

				map = FindMapChannel(maps,"diffuse");
				if (map) {
					g_debug("\t\tmap name %s", map->GetProperty("name")->AsFile()->GetName().c_str());
					g_debug("\t\tmap file %s", map->GetProperty("file")->AsFile()->GetName().c_str());
					std::string mapName = map->GetProperty("file")->AsFile()->GetName();

					osg::Texture2D* texture = new osg::Texture2D;
					osg::Image* image = osgDB::readImageFile(mDir + "/" + mapName, mOptions);

					texture->setWrap( osg::Texture::WRAP_R, osg::Texture::REPEAT);
					texture->setWrap( osg::Texture::WRAP_S, osg::Texture::REPEAT);
					texture->setWrap( osg::Texture::WRAP_T, osg::Texture::REPEAT);

					if (image)
						texture->setImage(image);
					else
						g_critical("EXGConverter: referenced by %s", mPath.c_str());

					state->setTextureAttributeAndModes(0, texture, osg::StateAttribute::ON);
/*
					if (map->GetProperty("mode") && map->GetProperty("mode")->AsFile()->GetName()=="additive") {
						osg::Material* mt=(osg::Material*)state->getAttribute(osg::StateAttribute::MATERIAL);
						mt->setEmission(osg::Material::FRONT, osg::Vec4(1,1,1,1));
						mt->setColorMode(osg::Material::EMISSION);
						osg::BlendFunc *tenv = new osg::BlendFunc;
						tenv->setFunction(osg::BlendFunc::ONE, osg::BlendFunc::ONE);
						state->setAttributeAndModes(tenv,osg::StateAttribute::ON);
						state->setRenderingHint(osg::StateSet::TRANSPARENT_BIN);
						state->setMode(GL_BLEND, osg::StateAttribute::ON);

						g_debug("\t\tadditive texture");
					}
*/
					mTextures.push_back(map);

					exg::VectorFloat* element = map->GetProperty("element")->AsVectorFloat();
					int coord_size = int((*element)[0]);
					osg::Array* array = 0;
					switch(coord_size) {
						case 2:
							array = new osg::Vec2Array;
							break;

						case 3:
							array = new osg::Vec3Array;
							break;

						default:
							g_critical("EXGConverter:%s: element with value %d unexpected", mPath.c_str(), coord_size);
							break;
					}

					mGeometry->setTexCoordArray(0, array);
				}

				exg::MapObjectPointer* diffuse = map; // give me a trace about the diffuse map
				if (diffuse) { // use opacity only if we found a diffuse before
					map = FindMapChannel(maps,"opacity"); // is there opacity ?
					if (map) {
						std::string dname = diffuse->GetProperty("file")->AsFile()->GetName();
						std::string oname = map->GetProperty("file")->AsFile()->GetName();

						if (dname == oname) {
							if (!blendState)
								blendState = new osg::BlendFunc;
						}
						else {
							g_critical("EXGConverter:%s: opacity texture without alpha channel not implemented", mPath.c_str());
						}
					}
				}

				map = FindMapChannel(maps, "diffuse_2");
				if (map) {
					std::string mapName = map->GetProperty("file")->AsFile()->GetName();

					bool bGotHDR = false;
					if (mapName.find(".hdr") != std::string::npos)
						bGotHDR = true;

					if (bGotHDR == true) {
						// osgDB::readImageFile is going to read a HDR file

						char str[200];
						sprintf(str, "RGBMUL 0.5 YFLIP");
						mOptions->setOptionString(str);
					}

					osg::Texture2D* texture = new osg::Texture2D;
					osg::Image* image = osgDB::readImageFile(mDir + "/" + mapName, mOptions);
					if (image)
						texture->setImage(image);
					else
						g_critical("EXGConverter: referenced by %s", mPath.c_str());

					texture->setWrap( osg::Texture::WRAP_R, osg::Texture::REPEAT);
					texture->setWrap( osg::Texture::WRAP_S, osg::Texture::REPEAT);
					texture->setWrap( osg::Texture::WRAP_T, osg::Texture::REPEAT);

					// whatever happen, no more need options
					mOptions->setOptionString("");

					state->setTextureAttributeAndModes(1, texture, osg::StateAttribute::ON);

					if (bGotHDR == true) {
						osg::TexEnvCombine *envCombine;
						envCombine = new osg::TexEnvCombine;
						envCombine->setCombine_RGB(GL_MODULATE);

						envCombine->setSource0_RGB(GL_TEXTURE);
						envCombine->setSource0_Alpha(GL_TEXTURE);
						envCombine->setOperand0_RGB(GL_SRC_COLOR);
						envCombine->setOperand0_Alpha(GL_SRC_ALPHA);

						envCombine->setSource1_RGB(GL_PREVIOUS_ARB);
						envCombine->setSource1_Alpha(GL_PREVIOUS_ARB);
						envCombine->setOperand1_RGB(GL_SRC_COLOR);
						envCombine->setOperand1_Alpha(GL_SRC_ALPHA);

						envCombine->setScale_RGB(2.0f);
						state->setTextureAttributeAndModes(1, envCombine, osg::StateAttribute::ON);
						//opts->unref();
					}

					mTextures.push_back(map);

					exg::VectorFloat* element = map->GetProperty("element")->AsVectorFloat();
					int coord_size = int((*element)[0]);
					osg::Array* array = 0;
					switch(coord_size) {
						case 2:
							array = new osg::Vec2Array;
							break;

						case 3:
							array = new osg::Vec3Array;
							break;

						default:
							g_critical("EXGConverter:%s: element with value %d unexpected", mPath.c_str(), coord_size);
							break;
					}

					mGeometry->setTexCoordArray(1, array);
				}

				map = FindMapChannel(maps, "reflect");
				if (0 && map) {

					std::string mapName = map->GetProperty("file")->AsFile()->GetName();

					osg::TextureCubeMap* texture = new osg::TextureCubeMap;
					osg::Image* image = osgDB::readImageFile(mDir + "/" + mapName, mOptions);
					if (image) {
					  texture->setImage(osg::TextureCubeMap::POSITIVE_X, image);
					  texture->setImage(osg::TextureCubeMap::POSITIVE_Y, image);
					  texture->setImage(osg::TextureCubeMap::POSITIVE_Z, image);
					  texture->setImage(osg::TextureCubeMap::NEGATIVE_X, image);
					  texture->setImage(osg::TextureCubeMap::NEGATIVE_Y, image);
					  texture->setImage(osg::TextureCubeMap::NEGATIVE_Z, image);
					} else
					  g_critical("EXGConverter: cannot found image %s", mPath.c_str());

					int unit = mTextures.size();
					state->setTextureAttributeAndModes(unit, texture, osg::StateAttribute::ON);
					mTextures.push_back(map);

					if (unit > 0) {
						osg::TexEnv *env;
						env = new osg::TexEnv;
						env->setMode(osg::TexEnv::ADD);
						state->setTextureAttributeAndModes(unit, env, osg::StateAttribute::ON);
					}

					osg::TexGen *texgen = new osg::TexGen;
					texgen->setMode(osg::TexGen::REFLECTION_MAP);
					state->setTextureAttributeAndModes(unit, texgen, osg::StateAttribute::ON);

					osg::TexMat *texmat = new osg::TexMat;
					osg::Matrix mat = osg::Matrix::scale(0.5f, 0.5f, 0);
					mat(3, 0) = 0.5f;
					mat(3, 1) = 0.5f;
					texmat->setMatrix(mat);
					state->setTextureAttributeAndModes(unit, texmat, osg::StateAttribute::ON);

				}


			}
		}

		if (blendState) {
			state->setMode(GL_BLEND, osg::StateAttribute::ON);
			state->setRenderingHint(osg::StateSet::TRANSPARENT_BIN);
			state->setAttributeAndModes(blendState);
		}

//		int binNum = state->getBinNumber();
//		const std::string &name = state->getBinName();

		if (depthMask)
			state->setAttributeAndModes(depthMask);

//		if (bUseStencil) {
//			osg::Stencil *stencil = new osg::Stencil;
//			stencil->setFunction(osg::Stencil::ALWAYS, 0x1, 0xffffffff);
//			stencil->setOperation(osg::Stencil::REPLACE, osg::Stencil::REPLACE, osg::Stencil::REPLACE);
//			state->setAttributeAndModes(stencil);
//			state->setMode(GL_STENCIL_TEST, TRUE);
//		}
//		else {
//			state->setRenderBinDetails(1, "toto");

//			osg::Stencil *stencil = new osg::Stencil;
//			stencil->setFunction(osg::Stencil::EQUAL, 0x1, 0xffffffff);
//			stencil->setOperation(osg::Stencil::KEEP, osg::Stencil::KEEP, osg::Stencil::KEEP);
//			state->setAttributeAndModes(stencil);
//			state->setMode(GL_STENCIL_TEST, TRUE);

//			osg::BlendFunc *bf = new osg::BlendFunc;
//			bf->setFunction(GL_DST_COLOR, GL_ZERO);
//			state->setAttributeAndModes(bf);
//			state->setMode(GL_BLEND, osg::StateAttribute::ON);
//		}

		if(node.GetNbPolygons() > 0) {
			mGeometry->setVertexArray(new osg::Vec3Array());

			if(node.find("normal") != node.end()) {
				mGeometry->setNormalBinding(osg::Geometry::BIND_PER_VERTEX);
				mGeometry->setNormalArray(new osg::Vec3Array);
			}
		}
#ifdef NEW_GENERATION_OF_MESH

		osg::Vec3Array* arrayVertex = dynamic_cast<osg::Vec3Array*>(mGeometry->getVertexArray());
		osg::Vec3Array* arrayNormal = mGeometry->getNormalArray();
		std::vector<osg::Array*> arrayTexCoord;
		for (unsigned int t = 0; t <mGeometry->getNumTexCoordArrays(); t++)
			arrayTexCoord.push_back(mGeometry->getTexCoordArray(t));

		std::map<exg::Vertex*,int> indexesOfVertexes; // contain re indexed vertex
		std::vector<int> arrayIndexTmp; // contain indexed vertex
		// we assume that we have only triangles
		int nbp = node.GetNbPolygons();
		int totalVertex = 0;
		for (int i = 0; i < nbp; i++) {
			exg::Polygon* currentPolygon = node.GetPolygon(i);

			if (currentPolygon->GetNbVertexes()!=3) {
				g_critical("EXGConverter:%s: polygon is not a triangle: %d vertexes", mPath.c_str(), currentPolygon->GetNbVertexes());
				continue;
			}

			for(int j = 0; j < 3;j++) {
				exg::Vertex* v=currentPolygon->GetVertex(j);
				if (indexesOfVertexes.find(v) == indexesOfVertexes.end()) {
					indexesOfVertexes[v] = totalVertex++;

					exg::Vector3f p=v->GetPoint()->GetPosition();
					arrayVertex->push_back(osg::Vec3(p[0],p[1],p[2]));

					if (arrayNormal) {
						exg::VectorFloat* normal = v->GetProperty("normal")->AsVectorFloat();
						arrayNormal->push_back(osg::Vec3((*normal)[0], (*normal)[1], (*normal)[2]));
					  }

					  if (node.GetProperty("maps")) {
						  exg::VectorObjectPointer* maps = node.GetProperty("maps")->AsVectorObjectPointer();
						  if(maps) {
							  exg::MapObjectPointer* map=0;
							  map=FindMapChannel(maps,"diffuse");
							  if (map) {

								  exg::VectorFloat* element = map->GetProperty("element")->AsVectorFloat();
								  int coord_size = int((*element)[0]);
								  switch(coord_size) {
case 2:
	{
		osg::Vec2Array* array2d = dynamic_cast<osg::Vec2Array*>(arrayTexCoord[0]);
		exg::VectorFloat* vcoord=FindVertexMapChannel(v,"diffuse");
		array2d->push_back(osg::Vec2((*vcoord)[0], (*vcoord)[1]));
	}
	break;
default:
	g_critical("EXGConverter:%s: element with value %d unexpected", mPath.c_str(), coord_size);
	break;
								  }
							  }

							  map=FindMapChannel(maps,"diffuse_2");
							  if (map) {

								  exg::VectorFloat* element = map->GetProperty("element")->AsVectorFloat();
								  int coord_size = int((*element)[0]);
								  switch(coord_size) {
case 2:
	{
		osg::Vec2Array* array2d = dynamic_cast<osg::Vec2Array*>(arrayTexCoord[1]);
		exg::VectorFloat* vcoord=FindVertexMapChannel(v,"diffuse_2");
		array2d->push_back(osg::Vec2((*vcoord)[0], (*vcoord)[1]));
	}
	break;
default:
	g_critical("EXGConverter:%s: element with value %d unexpected", mPath.c_str(), coord_size);
	break;
								  }
							  }

						  }
					  }
				  }

				  int idx=indexesOfVertexes[v];
				  arrayIndexTmp.push_back(idx);
			  }
		  }
		  osg::PrimitiveSet* p=0;

		  if (arrayIndexTmp.size()<256) {
			  std::vector<GLubyte> arr;
			  arr.resize(arrayIndexTmp.size());
			  for (std::vector<int>::size_type a=0;a<arrayIndexTmp.size();a++)
				  arr[a]=(GLubyte)arrayIndexTmp[a];
			  p=new osg::DrawElementsUByte(GL_TRIANGLES,arrayIndexTmp.size(),&arr.front());
		  } else if (arrayIndexTmp.size()<65536) {
			  std::vector<GLushort> arr;
			  arr.resize(arrayIndexTmp.size());
			  for (std::vector<int>::size_type a=0;a<arrayIndexTmp.size();a++)
				  arr[a]=(GLushort)arrayIndexTmp[a];
			  p=new osg::DrawElementsUShort(GL_TRIANGLES,arrayIndexTmp.size(),&arr.front());
		  } else {
			  std::vector<GLuint> arr;
			  arr.resize(arrayIndexTmp.size());
			  for (std::vector<int>::size_type a=0;a<arrayIndexTmp.size();a++)
				  arr[a]=(GLuint)arrayIndexTmp[a];
			  p=new osg::DrawElementsUInt(GL_TRIANGLES,arrayIndexTmp.size(),&arr.front());
		  }

		  nbTotalFaces+=arrayIndexTmp.size()/3;
		  mGeometry->addPrimitiveSet(p);
#endif

		  mGeode->addDrawable(mGeometry);

		  mGeometry->setUseDisplayList(false); // works really better
		  mGeometry->setUseVertexBufferObjects(false); // works really better

		  //		  int size = arrayVertex->size();

		  Traverse(node);

#ifndef NEW_GENERATION_OF_MESH
		  if(node.GetNbPolygons() > 0) {
			  mGeometry->addPrimitiveSet(new osg::DrawArrays(osg::PrimitiveSet::TRIANGLES, 0, mGeometry->getVertexArray()->getNumElements()));
			  nbTotalFaces+=mGeometry->getVertexArray()->getNumElements()/3;
		  }
#endif

		  mTextures.clear();
		  mGeometry = 0;
	  }

	  void Apply(exg::Vertex& node) {
		  // Explored by Apply(Polygon& node)
		  g_critical("MAFESCNData::Converter: node type exg::Vertex not implemented");
	  }

	  void Apply(exg::Point& node) {
		  // Explored by Apply(Polygon& node)
		  g_critical("MAFESCNData::Converter: node type exg::Point not implemented");
	  }

	  void Apply(exg::Polygon& node) {
#ifndef NEW_GENERATION_OF_MESH
		  if (!mGeometry) {
			  g_critical("EXGConverter:%s: Polygon node not below a Material node", mPath.c_str());
			  return;
		  }
		  exg::VectorObjectPointer* vertexes = node.GetProperty("vertexes")->AsVectorObjectPointer();
		  for(exg::VectorObjectPointer::iterator i = vertexes->begin(); i != vertexes->end(); i++) {
			  exg::Vertex* vertex = (*i)->AsVertex();

			  for(unsigned int j = 0; j < mTextures.size(); j++) {
				  exg::MapObjectPointer* map = mTextures[j];
				  osg::Array* texcoord = mGeometry->getTexCoordArray(j);
				  if(texcoord) {
					  std::string name = map->GetProperty("name")->AsFile()->GetName();
					  exg::VectorFloat* coord = vertex->GetProperty(name)->AsVectorFloat();
					  switch(texcoord->getType()) {
case osg::Array::Vec2ArrayType:
	{
		osg::Vec2Array* array = dynamic_cast<osg::Vec2Array*>(texcoord);
		array->push_back(osg::Vec2((*coord)[0], (*coord)[1]));
	}
	break;
case osg::Array::Vec3ArrayType:
	{
		osg::Vec3Array* array = dynamic_cast<osg::Vec3Array*>(texcoord);
		array->push_back(osg::Vec3((*coord)[0], (*coord)[1], (*coord)[2]));
	}
	break;
default:
	g_critical("EXGConverter:%s: array with type %d unexpected", mPath.c_str(), texcoord->getType());
	break;
					  }
				  }
			  }

			  osg::Vec3Array* normalarray = mGeometry->getNormalArray();
			  if(normalarray) {
				  exg::VectorFloat* normal = vertex->GetProperty("normal")->AsVectorFloat();
				  normalarray->push_back(osg::Vec3((*normal)[0], (*normal)[1], (*normal)[2]));
			  }

			  exg::Vector3f position = vertex->GetPoint()->GetPosition();
			  osg::Vec3Array* array = dynamic_cast<osg::Vec3Array*>(mGeometry->getVertexArray());
			  osg::Vec3 vector = osg::Vec3(position[0], position[1], position[2]);
			  array->push_back(vector);

		  }
		  //    Traverse(node);
#endif
	  }

	  void Apply(exg::Mesh& node) {
		  if(mGeode)
			  g_error("EXGConverter:%s: multiple exg::Mesh nodes", mPath.c_str());

		  mGeode = new osg::Geode;

		  for(int material = 0; material < node.GetNbMaterials(); material++)
			  node.GetMaterial(material)->Accept(*this);
	  }

	  osg::Node* GetNode() { return mGeode; }

	  std::string mSourceData;

private:

	exg::MapObjectPointer* FindMapChannel(exg::VectorObjectPointer* maps,const std::string& _name) {
		for(exg::VectorObjectPointer::iterator i = maps->begin(); i != maps->end(); i++) {
			exg::MapObjectPointer* map = (*i)->AsMapObjectPointer();
			exg::File* name = map->GetProperty("name")->AsFile();
			if (name->GetName()==_name)
				return map;
		}
		return 0;
	}

	exg::VectorFloat* FindVertexMapChannel(exg::Vertex* v,const std::string& _name) {
		if (v->find(_name)==v->end())
			return 0;

		return (*v)[_name]->AsVectorFloat();
	}

	std::vector<exg::MapObjectPointer*> mTextures;
	osg::Geode* mGeode;
	osg::Geometry* mGeometry;
	const std::string& mDir;
	const std::string& mFile;
	std::string mPath;
	std::string mBase;
	bool mIsLighted;
	osgDB::ReaderWriter::Options* mOptions;
};

/*explicit*/ MAFESCNData::MAFESCNData(void)
{
	//  g_debug("MAFESCNData::MAFESCNData: 0x%08x", (int)this);
	mAmbientColor = exg::Vector4f(0, 0, 0, 1);
	mBackGroundColor = exg::Vector4f(0, 0, 0, 1);
	mFogColor = exg::Vector4f(0, 0, 0, 1);
	mbUseFog = false;
}

/*virtual*/ MAFESCNData::~MAFESCNData(void)
{
	g_assert(!mGroup.valid() || mGroup->referenceCount() <= 2);
	//	g_debug("MAFESCNData::~MAFESCNData: 0x%08x", (int)this);
}

// Data from escn file
bool MAFESCNData::Load(const std::string& path, const std::string& dir, const std::string& file, osgDB::ReaderWriter::Options* options)
{
	mCurrentLight = 0;
	mPath = path;
	mDir = dir;
	mFile = file;

	g_debug("MAFESCNData::Load: %s", path.c_str());

	mGroup = new osg::MatrixTransform;

	TiXmlDocument doc;
	if (!doc.LoadFile(path.c_str()))
	{
		g_critical("MAFESCNData::Load:%s: object null", mPath.c_str());
		return false;
	}

	TiXmlElement * pRoot = doc.RootElement();
	if (NULL == pRoot)
	{
		g_critical("MAFESCNData::Load:%s: no root", mPath.c_str());
		return false;
	}

	TiXmlNode * pChild = NULL ;
	while ((pChild = pRoot->IterateChildren(pChild)))
	{
		TiXmlElement * pElt = pChild->ToElement() ;
		if (NULL != pElt)
		{
			std::string strTag = pElt->Value();
			if (strTag == "node")
			{
				Convert(pElt, mGroup.get(), mPath, options);
			}
		}
		else
		{
			g_critical("MAFESCNData::Load:%s: node root element", mPath.c_str());
		}
	}

	mGroup->setName(path);
	g_debug("MAFESCNData::Load: Total faces %d with %d drawables", nbTotalFaces, nbTotalDrawable);
	return true;
}

osg::Node* MAFESCNData::Convert(TiXmlElement * pElt, osg::Group* parent, const std::string& parentPath, osgDB::ReaderWriter::Options* options)
{
	if (!pElt)
		return NULL;

	osg::Node * node = NULL;
	const char * szNodeType = pElt->Attribute("type");
	const char * szNodeName = pElt->Attribute("name");
	g_debug("\t%s", szNodeName);

	if (!strcmp(szNodeType, "camera")) {
		MAFCameraController * camera = new MAFCameraController;
		camera->Init();
		MAFCameraModel * camera_model = camera->GetModel();
		camera_model->SetName(szNodeName);

		exg::Matrix4f cmat;
		getAttribute(pElt, "matrix", cmat);
		osg::Matrixf mm = convert(cmat);

		camera_model->SetPosition(osg::Vec3(cmat[0][3],cmat[1][3],cmat[2][3]));

		exg::Vector4f tgp;
		getAttribute(pElt, "target_pos", tgp);
		camera_model->SetTarget(osg::Vec3(tgp[0],tgp[1],tgp[2])); 
		camera_model->SetRoll(0);

		float fov = atof(pElt->Attribute("fov"));
		camera_model->SetFov(fov);

		float zNear = atof(pElt->Attribute("near_plane"));
		camera_model->SetNear(zNear);

		float zFar = atof(pElt->Attribute("far_plane"));
		camera_model->SetFar(zFar);

		if (pElt->Attribute("fog_near_plane")) {
		  float fogNear = atof(pElt->Attribute("fog_near_plane"));
		  camera_model->SetFogNear(fogNear);
		}

		if (pElt->Attribute("fog_far_plane")) {
		  float fogFar = atof(pElt->Attribute("fog_far_plane"));
		  camera_model->SetFogFar(fogFar);
		}

		camera_model->SetMatrix(mm);

		mCameras[szNodeName] = camera;
	}
	else if (!strcmp(szNodeType, "group")) {

		node = new osg::Group;

		if (node) {
			TiXmlNode * pChild = NULL;

			while ((pChild = pElt->IterateChildren(pChild))) {
				TiXmlElement * pChildElt = pChild->ToElement();

				if (pChildElt) {
					std::string strTag = pChildElt->Value();
					if (strTag == "node") {
						Convert(pChildElt, static_cast<osg::Group*>(node), parentPath, options);
					}
				}
			}
		}
	}
	else if (!strcmp(szNodeType, "transform")) {

		const char * szBillboardType = pElt->Attribute("billboard_type");

		if (!strcmp(szBillboardType, "none")) {
			osg::MatrixTransform* matrixTransform = new osg::MatrixTransform;
			exg::Matrix4f m;
			getAttribute(pElt, "matrix", m);
			osg::Matrix mt(m[0][0],m[1][0],m[2][0],m[3][0],
				m[0][1],m[1][1],m[2][1],m[3][1],
				m[0][2],m[1][2],m[2][2],m[3][2],
				m[0][3],m[1][3],m[2][3],m[3][3]);

			//osg::Matrix mt = osg::Matrix::identity();
// 			osg::Matrix mt = osg::Matrix::translate(0, 0, -500);

			matrixTransform->setMatrix(mt);
			node = matrixTransform;
		}
		else if (!strcmp(szBillboardType, "plane_facing")) {
			g_debug("\t\tautoTransform type plane facing");
			osg::AutoTransform *transform = new osg::AutoTransform;
 			transform->setAutoRotateMode(osg::AutoTransform::ROTATE_TO_SCREEN);
			node = transform;
		}
		else if (!strcmp(szBillboardType, "center_facing")) {
			g_debug("\t\tautoTransform type center facing");
			osg::AutoTransformBillboard *bb = new osg::AutoTransformBillboard;
			node = bb;
		}

		if (node) {
			TiXmlNode *pChild = NULL;

			while ((pChild = pElt->IterateChildren(pChild))) {
				TiXmlElement * pChildElt = pChild->ToElement();
				if (pChildElt) {
					std::string strTag = pChildElt->Value();
					if (strTag == "node") {
						Convert(pChildElt, static_cast<osg::Group*>(node), parentPath, options);
					}
					else if (strTag == "animation") {
						if (!ParseAnimation(pChildElt, static_cast<osg::Group*>(node))) {
							g_error("MAFESCNData::Convert: failed to exg::Load %s [ParseAnimation]", parentPath.c_str());
						}
					}
					else if (strTag == "matrix") {
					}
				}
			}
		}
	}

	// Note about lights: in the EXG file format, a light IS A transformation.
	// However this is not the case in the engine...

	else if (!strcmp(szNodeType, "light")) {
	}
	else if (!strcmp(szNodeType, "light_directional")) {
	  //		const char *name = pElt->Attribute("name");

	  //		osg::MatrixTransform *lgtMatrix = new osg::MatrixTransform();
		exg::Matrix4f m;
		exg::Vector4f col;
		getAttribute(pElt, "matrix", m);
		getAttribute(pElt, "color", col);

		osg::Vec4 color(col[0], col[1], col[2], 1);

		osg::Matrix mt(m[0][0],m[1][0],m[2][0],m[3][0],
			m[0][1],m[1][1],m[2][1],m[3][1],
			m[0][2],m[1][2],m[2][2],m[3][2],
			m[0][3],m[1][3],m[2][3],m[3][3]);

		osg::LightSource *ls = new osg::LightSource();
		osg::Light *lgt = new osg::Light();
		lgt->setLightNum( mCurrentLight );
		lgt->setAmbient( OSGVEC4F_BLACK );
		lgt->setDiffuse(color);
		lgt->setSpecular(color);

		osg::Vec4f dir(-m[1][0], m[1][1], -m[1][2], 0);
		lgt->setPosition( dir );
		ls->setLight(lgt);

		mCurrentLight++;
		node = ls;
	}
	else if (!strcmp(szNodeType, "light_omni")) {
	  //		const char *name = pElt->Attribute("name");

	  //		osg::MatrixTransform *lgtMatrix = new osg::MatrixTransform();
		exg::Matrix4f m;
		exg::Vector4f col;
		getAttribute(pElt, "matrix", m);
		getAttribute(pElt, "color", col);

		osg::Vec4 color(col[0], col[1], col[2], 1);

		osg::Matrix mt(m[0][0],m[1][0],m[2][0],m[3][0],
			m[0][1],m[1][1],m[2][1],m[3][1],
			m[0][2],m[1][2],m[2][2],m[3][2],
			m[0][3],m[1][3],m[2][3],m[3][3]);

		osg::LightSource *ls = new osg::LightSource();
		osg::Light *lgt = new osg::Light();
		lgt->setLightNum( mCurrentLight );
		lgt->setAmbient( OSGVEC4F_BLACK );
		lgt->setDiffuse( color );
		lgt->setSpecular( color);

		osg::Vec4f pos(m[0][3], m[1][3], m[2][3], 1);
		lgt->setPosition( pos );
		ls->setLight(lgt);

		mCurrentLight++;
		node = ls;
	}
	else if (!strcmp(szNodeType, "light_spot")) {
	}
	else if (!strcmp(szNodeType, "mesh")) {
		std::string filename;
		const char * szFileName = pElt->Attribute("file_name");
		if (szFileName) {
			filename = mDir + "/" + szFileName;
			std::ifstream fs(filename.c_str(), std::ios::binary);
			if (fs) {
				exg::Pointer<exg::Mesh> mesh;
				exg::Load(mesh, fs);
				if(!mesh.Valid()) {
					g_error("MAFESCNData::Convert: failed to exg::Load %s", parentPath.c_str());
				}

				const char *lighted = pElt->Attribute("lighted");
				bool isLighted = false;
				if (!stricmp(lighted, "1"))
					isLighted = true;

				EXGConverter converter(mDir, mFile, isLighted, options);
				mesh->Accept(converter);
				node = converter.GetNode();

				if(node) {
					osg::StateSet* state = node->getOrCreateStateSet();

					if (isLighted)
						state->setMode(GL_LIGHTING, osg::StateAttribute::ON);
					else
						state->setMode(GL_LIGHTING, osg::StateAttribute::OFF);

					//state->setMode(GL_CULL_FACE, osg::StateAttribute::ON);
				}
				g_assert(mesh->ReferenceCount() == 1);
			}
			else
			{
				g_debug("MAFESCNData::Convert: failed to open file %s pointed by %s", filename.c_str(), parentPath.c_str());
			}
		}
	}
	else if (!strcmp(szNodeType, "ambient")) {
		getAttribute(pElt, "color", mAmbientColor);
	}
	else if (!strcmp(szNodeType, "background")) {
		getAttribute(pElt, "color", mBackGroundColor);
	}
	else if (!strcmp(szNodeType, "fog")) {
		getAttribute(pElt, "color", mFogColor);
		mbUseFog = true;
	}

	if (node) {
		if (szNodeName)
			node->setName(szNodeName);

		if (parent)
			parent->addChild(node);
	}

	return node;
}

void MAFESCNData::getAttribute(TiXmlElement * pElt, const std::string & strName, exg::Matrix4f & m)
{
	exg::Vector4f l1, l2, l3, l4;

	TiXmlNode * pChild = NULL ;

	while ((pChild = pElt->IterateChildren(pChild)))
	{
		TiXmlElement * pChildElt = pChild->ToElement();
		if (NULL != pChildElt)
		{
			std::string strTag = pChildElt->Value();
			if (strTag == strName)
			{
				TiXmlNode * pMatrixChild = NULL ;
				while ((pMatrixChild = pChildElt->IterateChildren(pMatrixChild)))
				{
					TiXmlElement * pMatrixChildElt = pMatrixChild->ToElement();
					if (NULL != pMatrixChildElt)
					{
						std::string strTag = pMatrixChildElt->Value();
						if (strTag == "l1") 
						{
							l1[0] = atof(pMatrixChildElt->Attribute("x"));
							l1[1] = atof(pMatrixChildElt->Attribute("y"));
							l1[2] = atof(pMatrixChildElt->Attribute("z"));
							l1[3] = atof(pMatrixChildElt->Attribute("w")); 
						}

						if (strTag == "l2") 
						{
							l2[0] = atof(pMatrixChildElt->Attribute("x"));
							l2[1] = atof(pMatrixChildElt->Attribute("y"));
							l2[2] = atof(pMatrixChildElt->Attribute("z"));
							l2[3] = atof(pMatrixChildElt->Attribute("w"));
						}

						if (strTag == "l3")
						{
							l3[0] = atof(pMatrixChildElt->Attribute("x"));
							l3[1] = atof(pMatrixChildElt->Attribute("y"));
							l3[2] = atof(pMatrixChildElt->Attribute("z"));
							l3[3] = atof(pMatrixChildElt->Attribute("w"));
						}

						if (strTag == "l4")
						{
							l4[0] = atof(pMatrixChildElt->Attribute("x"));
							l4[1] = atof(pMatrixChildElt->Attribute("y"));
							l4[2] = atof(pMatrixChildElt->Attribute("z"));
							l4[3] = atof(pMatrixChildElt->Attribute("w"));
						}
					}
				}
			}
		}
	}

	m[0] = l1;
	m[1] = l2;
	m[2] = l3;
	m[3] = l4;
}

void MAFESCNData::getAttribute(TiXmlElement * pElt, const std::string & strName, exg::Vector4f & v)
{
	TiXmlNode * pChild = NULL ;

	while ((pChild = pElt->IterateChildren(pChild)))
	{
		TiXmlElement * pChildElt = pChild->ToElement() ;
		if (NULL != pChildElt)
		{
			std::string strTag = pChildElt->Value();
			if (strTag == strName)
			{
				v[0] = atof(pChildElt->Attribute("x"));
				v[1] = atof(pChildElt->Attribute("y"));
				v[2] = atof(pChildElt->Attribute("z"));
				v[3] = atof(pChildElt->Attribute("w"));
			}
		}
	}
}

void MAFESCNData::setGlobalStateSet(osg::StateSet *_ss)
{
	osg::StateAttribute *sa = _ss->getAttribute(osg::StateAttribute::LIGHTMODEL);
	osg::LightModel *lightmodel = dynamic_cast<osg::LightModel*>(sa);

	lightmodel->setAmbientIntensity( osg::Vec4f(mAmbientColor[0], mAmbientColor[1], mAmbientColor[2], mAmbientColor[3]) );

	int nbLights = OSGHelper_getNbLightSourcesOf( *GetGroup() );

	for (int i = 0; i < nbLights; i++)
		OSGHelper_turnLightOn(*_ss, i);

	OSGHelper_turnOffLighting(*_ss);

	if (mbUseFog) {
		MAFCameraController *firstCam = getFirstCamera();
		if (firstCam) {
			MAFCameraModel *model = firstCam->GetModel();
			osg::Fog *fog = new osg::Fog();
			fog->setStart( model->GetFogNear() );
			fog->setEnd( model->GetFogFar() );
			fog->setMode(osg::Fog::LINEAR);
			_ss->setAttributeAndModes(fog, osg::StateAttribute::ON);
		}
	}

	_ss->setMode(GL_ALPHA_TEST, osg::StateAttribute::OFF);
	_ss->setMode(GL_CULL_FACE, osg::StateAttribute::ON);
}


class CTimeBlock
{
public:

	explicit CTimeBlock(void)
	{

	}

	CTimeBlock(const CTimeBlock & tb)
	{
		(*this)=tb;
	}

	void operator = (const CTimeBlock & tb)
	{
		m_strName = tb.m_strName;
		startTime = tb.startTime;
		endTime = tb.endTime;
	}

	std::string m_strName;
	float startTime;
	float endTime;

};




static int FindKeyIn(const std::vector<float>& lTimes, float wanted)
{
  int end = lTimes.size();
  int currentIndex = 0;

  while(currentIndex < end - 1) {
    float val = lTimes[currentIndex];
    if (val >= wanted && val < lTimes[currentIndex+1])
      return currentIndex;
    currentIndex++;
  }

  return end - 1;
}

bool MAFESCNData::ParseAnimation(TiXmlElement * pElt, osg::Group* parent)
{
	if (NULL == parent)
	{
		return(false);
	}

	if (NULL == pElt)
	{
		return(false);
	}

	//
	// For the moment, assume that all the track have the same number of keys.
	// In the future, it could be great to be able to have separated controllers in AnimationPaths
	std::vector<float> lTimes;
	std::vector<exg::Vector3f> lPos;
	std::vector<exg::Quaternionf> lRot;
	std::vector<exg::Vector3f> lScl;
	std::vector<CTimeBlock> lTimeBlocks;

	TiXmlNode * pAnimationChild = NULL ;
	while ((pAnimationChild = pElt->IterateChildren(pAnimationChild)))
	{
		TiXmlElement * pAnimationChildElt = pAnimationChild->ToElement();
		if (NULL != pAnimationChildElt)
		{
			std::string strTag = pAnimationChildElt->Value();
			
			if (strTag == "track_position")
			{

				TiXmlNode * pTrackPosChild = NULL;
				while ((pTrackPosChild = pAnimationChildElt->IterateChildren(pTrackPosChild)))
				{
					TiXmlElement * pTrackPosChildElt = pTrackPosChild->ToElement();

					if (NULL != pTrackPosChildElt)
					{
						std::string strTag = pTrackPosChildElt->Value();
						if (strTag == "key")
						{
							//
							// time
							float time = atof(pTrackPosChildElt->Attribute("time"));
							lTimes.push_back(time);

							//
							// posX, posY, posZ
							float posX = atof(pTrackPosChildElt->Attribute("x"));
							float posY = atof(pTrackPosChildElt->Attribute("y"));
							float posZ = atof(pTrackPosChildElt->Attribute("z"));
							lPos.push_back(exg::Vector3f(posX, posY, posZ));
						}
					}
				}
			}
			else if (strTag == "track_rotation")
			{
				TiXmlNode * pTrackRotChild = NULL;
				while ((pTrackRotChild = pAnimationChildElt->IterateChildren(pTrackRotChild)))
				{
					TiXmlElement * pTrackRotChildElt = pTrackRotChild->ToElement();
					if (NULL != pTrackRotChildElt)
					{
						std::string strTag = pTrackRotChildElt->Value();
						if (strTag == "key")
						{
							//
							// rotX, rotY, rotZ, rotW
							float rotX = atof(pTrackRotChildElt->Attribute("x"));
							float rotY = atof(pTrackRotChildElt->Attribute("y"));
							float rotZ = atof(pTrackRotChildElt->Attribute("z"));
							float rotW = atof(pTrackRotChildElt->Attribute("w"));
							lRot.push_back(exg::Quaternionf(rotX, rotY, rotZ, rotW));
						}
					}
				}
			}
			else if (strTag == "track_scale")
			{
				TiXmlNode * pTrackSclChild = NULL;
				while ((pTrackSclChild = pAnimationChildElt->IterateChildren(pTrackSclChild)))
				{
					TiXmlElement * pTrackSclChildElt = pTrackSclChild->ToElement();
					if (NULL != pTrackSclChildElt)
					{
						std::string strTag = pTrackSclChildElt->Value();
						if (strTag == "key")
						{
							//
							// sclX, sclY, sclZ
							float sclX = atof(pTrackSclChildElt->Attribute("x"));
							float sclY = atof(pTrackSclChildElt->Attribute("y"));
							float sclZ = atof(pTrackSclChildElt->Attribute("z"));
							lScl.push_back(exg::Vector3f(sclX, sclY, sclZ));
						}
					}
				}
			}
			else if (strTag == "timeblocks")
			{
				TiXmlNode * pTrackTBChild = NULL;
				while ((pTrackTBChild = pAnimationChildElt->IterateChildren(pTrackTBChild)))
				{
					TiXmlElement * pTrackTBChildElt = pTrackTBChild->ToElement();
					if (NULL != pTrackTBChildElt)
					{
						std::string strTag = pTrackTBChildElt->Value();
						if (strTag == "timeblock")
						{
							CTimeBlock tb;
							tb.m_strName = pTrackTBChildElt->Attribute("name");
							tb.startTime = atof(pTrackTBChildElt->Attribute("start_time"));
							tb.endTime   = atof(pTrackTBChildElt->Attribute("end_time"));
							lTimeBlocks.push_back(tb);
						}
					}
				}
			}
		}
	}

	//
	// Create AnimationPaths
	if (lTimeBlocks.size() == 0)
	{
#if 1
	  CTimeBlock tb;
	  tb.m_strName="noname";
	  tb.startTime=lTimes.front();
	  tb.endTime=lTimes.back();
// 	  lTimeBlocks.push_back(tb);
// 	  int nbp=lPos.size();
// 	  int nbt=lTimes.size();
#else
		osg::AnimationPath * pAnimationPath = new osg::AnimationPath();
		pAnimationPath->setLoopMode(osg::AnimationPath::LOOP);
		for (unsigned int nKey = 0 ; nKey < lTimes.size() ; ++nKey)
		{
			exg::Vector4f    pos = lPos[nKey];
			exg::Quaternionf rot = lRot[nKey];
			exg::Vector4f    scl = lScl[nKey];
			float time = lTimes[nKey];

			osg::Vec3 position(pos[0], pos[1], pos[2]);
			osg::Quat rotation(rot[0], rot[1], rot[2], rot[3]);
			osg::Vec3 scale(scl[0], scl[1], scl[2]);

			osg::AnimationPath::ControlPoint controlPoint(position, rotation, scale);
			pAnimationPath->insert(time, controlPoint);
		}

		//
		// Create animation callback
		osg::AnimationPathCallback * pAnimationPathCallBack = new osg::AnimationPathCallback(pAnimationPath);
		g_assert(NULL != pAnimationPathCallBack);

		//
		// Set paused by default
		pAnimationPathCallBack->setPause(true);

		//
		// affect animation callback to the node
		parent->setUpdateCallback(pAnimationPathCallBack);
		parent->setDataVariance(osg::Object::DYNAMIC);
#endif
	}

// 	else
	{
		//
		// Create animation callback
		osg::MultipleAnimationPathCallback * pMultipleAnimationPathCallBack = new osg::MultipleAnimationPathCallback;//(pAnimationPath);
		g_assert(NULL != pMultipleAnimationPathCallBack);

		for (unsigned int nTimeBlock = 0 ; nTimeBlock < lTimeBlocks.size() ; ++nTimeBlock)
		{
			osg::AnimationPath * pAnimationPath = new osg::AnimationPath();
			pAnimationPath->setLoopMode(osg::AnimationPath::LOOP);

			const CTimeBlock & tb = lTimeBlocks[nTimeBlock];

			int startKey=FindKeyIn(lTimes,tb.startTime);
			int endKey=FindKeyIn(lTimes,tb.endTime);
			for (int nKey = startKey ; nKey <= endKey ; ++nKey) {
			  exg::Vector4f    pos = lPos[nKey];
			  exg::Quaternionf rot = lRot[nKey];
			  exg::Vector4f    scl = lScl[nKey];
			  float time = lTimes[nKey] - lTimes[startKey];
			  
			  osg::Vec3 position(pos[0], pos[1], pos[2]);
			  osg::Quat rotation(rot[0], rot[1], rot[2], rot[3]);
			  osg::Vec3 scale(scl[0], scl[1], scl[2]);
			  
			  osg::AnimationPath::ControlPoint controlPoint(position, rotation, scale);
			  pAnimationPath->insert(time, controlPoint);
			}

			pMultipleAnimationPathCallBack->addAnimationPath(tb.m_strName, pAnimationPath);
		}

		//
		// Set paused by default
		pMultipleAnimationPathCallBack->setPause(true);
		pMultipleAnimationPathCallBack->setCurrentAnimationPath(0);

		//
		// affect animation callback to the node
		parent->setUpdateCallback(pMultipleAnimationPathCallBack);
		parent->setDataVariance(osg::Object::DYNAMIC);
	}

	return(true);
}

