/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/maferror.h>

#endif

#ifdef _DEBUG // for Windows python23_d.lib is not in distribution... ugly but works
#	undef _DEBUG
#	include <Python.h>
#	define _DEBUG
#else
#	include <Python.h>
#endif


#include <iostream>

GQuark
underware_maf_error_quark (void)
{
  static GQuark q = 0;
  if (q == 0)
    q = g_quark_from_static_string ("underware-maf-error-quark");

  return q;
}

MAFError::MAFError(GError* error)
{
  mDomain = error->domain;
  mCode = error->code;
  mMessage = g_strdup(error->message);
}

MAFError::MAFError(gint code, const gchar* format, ...) {
  va_list ap;
  va_start(ap, format);

  Init(UNDERWARE_MAF_ERROR, code, format, ap);

  va_end(ap);
}

MAFError::MAFError(GQuark domain, gint code, const gchar* format, ...) {
  va_list ap;
  va_start(ap, format);

  Init(domain, code, format, ap);

  va_end(ap);
}

MAFError::~MAFError() {
  if(mMessage)
    g_free(mMessage);
}

static void noLog(const gchar *log_domain,
		  GLogLevelFlags log_level,
		  const gchar *message,
		  gpointer user_data) {
}

void MAFError::SetVerbose(const std::string& verbose) {
  if(verbose == "0") {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE |
				       G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_DEBUG),
		      noLog, NULL);
  } else if(verbose == "1") {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_DEBUG),
		      noLog, NULL);
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE),
		      g_log_default_handler, NULL);
  } else if(verbose == "2") {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_DEBUG),
		      noLog, NULL);
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE),
		      g_log_default_handler, NULL);
  } else {
    g_log_set_handler(NULL,
		      (GLogLevelFlags)(G_LOG_LEVEL_WARNING |
				       G_LOG_LEVEL_MESSAGE |
				       G_LOG_LEVEL_INFO |
				       G_LOG_LEVEL_DEBUG),
		      g_log_default_handler, NULL);
  }
}

void MAFError::NotifyPython(void) {
  g_critical("%s (domain=%d, code = %d)\n%s", mMessage, mDomain, mCode, (PyErr_Occurred() ? "    see the following python stack trace for more information\n" : ""));
  if(!PyErr_Occurred()) {
    //
    // The exception was not triggered by a call to python that failed,
    // therefore we must raise an error to inform python of the failure.
    //
    PyErr_SetString(PyExc_RuntimeError, "underware exception");
  }
}

void MAFError::Init(GQuark domain, gint code, const gchar* format, va_list ap) {
  mDomain = domain;
  mCode = code;
  mMessage = g_strdup_vprintf(format, ap);
}

