/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

/*
-----------------------------------------------------------------------------
This source file is part of OGRE
    (Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org/

Copyright (C) 2000-2002 The OGRE Team
Also see acknowledgements in Readme.html

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA, or go to
http://www.gnu.org/copyleft/lesser.txt.
-----------------------------------------------------------------------------
*/
#include "mafStdAfx.h"


#ifndef MAF_USE_VS_PCH

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

#endif

#if 0 // VC refuse to compile that if I link maf lib with exg lib

#include <maf/split.h>


//std::vector<std::string> split(const std::string& str, const std::string& delims, unsigned int maxSplits)
std::vector<std::string> std::split(const std::string& str, const std::string& delims, unsigned int maxSplits)
{
#if 1
  // static unsigned dl;
  std::vector<std::string> ret;
  unsigned int numSplits = 0;

  // Use STL methods 
  size_t start, pos;
  start = 0;
  do 
    {
      pos = str.find_first_of(delims, start);
      if (pos == start)
	{
	  // Do nothing
	  start = pos + 1;
	}
      else if (pos == std::string::npos || (maxSplits && numSplits == maxSplits))
	{
	  // Copy the rest of the string
	  ret.push_back( str.substr(start) );
	  break;
	}
      else
	{
	  // Copy up to delimiter
	  ret.push_back( str.substr(start, pos - start) );
	  start = pos + 1;
	}
      // parse up to next real data
      start = str.find_first_not_of(delims, start);
      ++numSplits;

    } while (pos != std::string::npos);

  return ret;
#endif
  return std::vector<std::string>();
}
#endif
