/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */
/*
 *
 * videoSpace/core/URL.cxx --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/url.h>
#include <iostream>
#include <stdio.h>

#endif


static void
split(std::string &s, const std::string splitters, std::string &part, bool keepsep, bool preserve) {
  std::string::size_type pos = s.find_first_of(splitters) ;
  if (pos!=std::string::npos) {    
    part.assign(s, 0, pos) ;
    s.erase(0, (keepsep ? pos : pos+1)) ;
  } else {
    if (!preserve) {
	 part.assign(s) ;
	 s = "" ;
    }
  }
}


  inline static unsigned int
  hex2int(char *s) {
    unsigned int t = 0;
    for(int i=0; i<2; i++)
	 if(s[i]>='0' && s[i]<='9')
	   t = (t<<4)+(s[i]-'0');
	 else if(s[i]>='a' && s[i]<='f')
	   t = (t<<4)+(s[i]-'a'+10);
	 else if(s[i]>='A' && s[i]<='F')
	   t = (t<<4)+(s[i]-'A'+10);
	 else
	   break;
    return t ;
  }


//VC7 does not like it
//namespace videoSpace {


  // ----------------------------------------------------------------------
  // ----------------------------------------------------------------------

  void
  URL::load(const std::string &s) {
    std::string url = s ;

    _scheme = "" ;
    _user = "" ;
    _password = "" ;
    _host = "" ;
    _port = "" ;
    _path = "" ;
    _query = "" ;
    _fragment = "" ;
    _opaque = "" ;

    split(url, ":", _scheme, false, true) ;

    _isAbsolute = (_scheme.length()>0) ;
    _isOpaque = false ;

    if (url[0]=='/') {
	 if (url[1]=='/') {
	   url.erase(0,2) ;
	   std::string site ;
	   split(url, "/?", site, true, false) ;
	   if (site.length()) {
		split(site, "@", _password, false, true) ;
		if (_password.length())
		  split(_password, ":", _user, false, false) ;
		split(site, ":", _host, false, false) ;
		_port.assign(site) ;
	   }
	 } 
    } else _isOpaque = _isAbsolute ;

    if (_isOpaque) {
	 // Was: split(url, "#", _opaque, false, false) ;
	 split(url, "?", _opaque, false, false) ;
	 split(url, "#", _query, false, false) ;
    } else {
	 split(url, "?", _path, false, false) ;
	 split(url, "#", _query, false, false) ;
    }
 
    _fragment.assign(url) ;
  }

  // ----------------------------------------------------------------------

  void
  URL::debug(std::ostream& out) const {
    out << "Kind     : " ;
    out << (_isAbsolute ? "ABSOLUTE " : "RELATIVE ") ;
    if (_isOpaque) out << "OPAQUE " ;
    out << std::endl ;

    if (_isAbsolute) 
	 out << "Scheme   : " << _scheme << std::endl ;

    if (!_isOpaque) {
	 out << "User     : " << _user << std::endl ;
	 out << "Password : " << _password << std::endl ;
	 out << "Host     : " << _host << std::endl ;
	 out << "Port     : " << _port << std::endl ;

	 out << "Path     : " << _path << std::endl ;
	 out << "Query    : " << _query << std::endl ;
    } else 
	 out << "OPAQUE   : " << _opaque << std::endl ;
    out << "Fragment : " << _fragment << std::endl ;

    out.flush() ;
  }

  // ----------------------------------------------------------------------

  std::string
  URL::encodeForQuery(const std::string &src, int flags) {
    static const char m[] = {
	 //                  1                   2                   3
	 //1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 2,1,2,2,1,2,4,1,1,1,1,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,4,4,2,4,2,4,
	 4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,
	 2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    };
    static const char* h = "0123456789ABCDEF";
    std::string result ;

    for( std::string::const_iterator i=src.begin();
	    i != src.end(); 
	    ++i ) {
	 char c = *i ;
	 if (m[(int)c]&flags)
	   result.append(&c,1) ;
	 else {
	   char tmp[3] ;
	   sprintf(tmp,"%%%c%c", h[c>>4], h[c&0x0F]) ;
	   result.append(tmp,3) ;
	 }
    }

    return result ;
  }

  std::string
  URL::decodeFromQuery(const std::string &src) {
    std::string result ;

    for( std::string::const_iterator i=src.begin();
	    i != src.end(); 
	    ++i ) {
	 char c = *i ;   
	 if (c == '+') c = ' ' ;
	 else if (c == '%') {
	   char tmp[2] ;
	   ++i ; tmp[0] = *i ;
	   ++i ; tmp[1] = *i ;
	   c = (char)hex2int(tmp) ;
	 }
	 result.append(&c,1) ;
    }

    return result ;
  }

  // ----------------------------------------------------------------------

  std::string
  URL::getQueryArg(const std::string &q, const std::string &key) {
    if (q=="") return "" ;

    std::string sub = key+"=" ;

    std::string::size_type b = q.find(sub) ;
    if (b==std::string::npos) return "" ;
    b += sub.length() ;

    std::string::size_type e = q.find_first_of(" &",b) ;
    
    std::string::size_type n = (e==std::string::npos) ? (q.length()-b+1) : (e-b) ;

    std::string result ;
    result.assign(q, b, n) ;

    return decodeFromQuery(result) ;
  }

  // ----------------------------------------------------------------------

//}
