/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *  Igor Kravtchenko <igor@obraz.net>
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH
#include <maf/utils.h>
#include <maf/maferror.h>

#include <osg/Group>
#include <osg/Geode>
#include <osg/Transform>
#include <cassert>

#endif

osg::Matrix MAFComputeLocalToWorld(osg::Node* _src, int _parentValidMask)
{
	assert(_src);
	osg::NodePath path;
	osg::Node* node = _src;
	while(node) {
	    path.push_back(node);
		int nbParents = node->getNumParents();
		if (!nbParents)
			break;
		for (int i = 0; i < nbParents; i++) {
			node = node->getParent(i);
			int nodeMask = node->getNodeMask();
			if (!(nodeMask & _parentValidMask))
				break;
		}
	}
	std::reverse(path.begin(), path.end());
	return osg::computeLocalToWorld(path);
}

osg::Node* GetNode(osg::Node* node, const std::string& name) {

  if(node->getName() == name)
    return node;
  
  if(node->asGroup()) {
    osg::Group* group = node->asGroup();
    for(unsigned int i = 0; i < group->getNumChildren(); i++) {
      osg::Node* found = GetNode(group->getChild(i), name);
      if(found)
	return found;
    }
  }
  return 0;
}

osg::Geode* GetGeode(osg::Node* node) {
  osg::Geode* geode = dynamic_cast<osg::Geode*>(node);
  if(geode != 0)
    return geode;
  
  if(node->asGroup()) {
    osg::Group* group = node->asGroup();
    for(unsigned int i = 0; i < group->getNumChildren(); i++) {
      osg::Geode* found = GetGeode(group->getChild(i));
      if(found)
	return found;
    }
  }
  return 0;
}

void getNameAndPath(const std::string &_filename, std::string &_path, std::string &_name)
{
	unsigned int pos = _filename.find_last_of("/");
	if (pos == std::string::npos) {
		pos = _filename.find_last_of("\\");
		if (pos == std::string::npos) {
			_name = _filename;
			_path = "";
			return;
		}
	}

	_path = _filename.substr(0, pos);
	_name = _filename.substr(pos+1);
}
