/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */
/*
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/wnc_tcp.h>

#include <glib.h>

#endif

#ifdef WIN32

#ifndef MAF_USE_VS_PCH
#include <windows.h>
#include <io.h>
#include <cstddef>
#endif

typedef int socklen_t;



unsigned long inet_aton(const char* ip,in_addr* s)

{

  s->s_addr=inet_addr(ip);

  if (s->s_addr==INADDR_NONE)

    return 0;

  return 1;

}



unsigned long inet_pton(int fam,const char* ip,in_addr* s)

{

  return inet_aton(ip,s);

}



#if 0

#define inet_aton(ip,addr)  (addr)->s_addr = inet_addr(ip), 1

#define inet_pton(fam,ip,addr) (addr)->s_addr = inet_addr(ip), 1

#endif

#else
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <unistd.h>
#include <sys/errno.h>
#endif

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <errno.h>

#include <iostream>
#include <stdexcept>

static void
socketOptions(int sock, int server) {
  int one=1, five=5 ;
  setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, (char *)&one, sizeof(int)) ;
#ifdef TCP_FASTACK
  setsockopt(sock, IPPROTO_TCP, TCP_FASTACK, (char *)&one, sizeof(int)) ;
#endif
#ifdef SO_RCVTIMEO
  setsockopt(sock, SOL_SOCKET, SO_RCVTIMEO, (char *)&five, sizeof(int)) ;
#endif
#ifdef SO_SNDTIMEO
  setsockopt(sock, SOL_SOCKET, SO_SNDTIMEO, (char *)&five, sizeof(int)) ;
#endif
  if (server) {
#ifdef SO_REUSEPORT
    setsockopt(sock, SOL_SOCKET, SO_REUSEPORT, (char *)&one, sizeof(int)) ;
#endif
    setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&one, sizeof(int)) ;
  }
#ifdef SO_NOSIGPIPE
  setsockopt(sock, SOL_SOCKET, SO_NOSIGPIPE, (char *)&one, sizeof(int)) ;
#endif
#ifndef WIN32
  signal(SIGPIPE, SIG_IGN) ;
#endif
}

  // -------------------------------------------------------------------------

  TcpConnection::TcpConnection(int fd, bool close) {
    _fd = fd ;
    _close = close ;
    socketOptions(_fd, 0) ; 
  }    

  TcpConnection::TcpConnection(const char* hostname, int port, bool close) {
    _fd = -1 ;
    _close = 0 ;

#ifdef WIN32

	//---------------------------------------
    // Initialize Winsock
    WSADATA wsaData;
    int iResult = WSAStartup( MAKEWORD(2,2), &wsaData );
    if( iResult != NO_ERROR )
	{
		printf("Error at WSAStartup\n");
	}

#endif



    struct sockaddr_in addr ;
    addr.sin_family = AF_INET ;
    addr.sin_port = htons(port) ;
    memset(addr.sin_zero, 0, 8) ;


    if (inet_aton(hostname, &(addr.sin_addr))==0) {
	 struct hostent *h = gethostbyname(hostname) ;
   if (!h) {
	   std::string msg = std::string("TcpConnection: gethostbyname failed (")+hostname+")" ; 
	   throw std::runtime_error(msg) ;
	 }
	 addr.sin_addr.s_addr = *(long*)h->h_addr ;
    }

#ifdef WIN32
    _fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP) ;
    if (_fd==INVALID_SOCKET) {
	    char tmp[255] ;
	    sprintf(tmp,"%d",port) ;
	    std::string msg = std::string("TcpConnection: connect failed (")+hostname+":"+tmp+")" ; 
	    throw std::runtime_error(msg) ;
    }
#else
    _fd = socket(AF_INET, SOCK_STREAM, 0) ;
#endif

    if( connect(_fd, (sockaddr *)&addr, sizeof(addr)) ) {
	 char tmp[255] ;
	 sprintf(tmp,"%d",port) ;
	 std::string msg = std::string("TcpConnection: connect failed (")+hostname+":"+tmp+")" ; 
	 throw std::runtime_error(msg) ;
    }

    socketOptions(_fd, 0) ; 
    _close = close ;
  }

  // -------------------------------------------------------------------------

  void
  TcpConnection::send(const char *data, unsigned int length) {
  int ret=0; 
#ifdef WIN32
    ret = ::send( _fd, data, length, 0 );
    int er=WSAGetLastError();
#else
    ret = write(_fd, data, length) ;
#endif
    if (ret==(int)length) return ;
    std::string msg ;
    if (ret==-1) msg = "write failed" ;
    else msg = "couldn't write all the bytes" ;
    throw std::runtime_error(msg) ;
  }

  void
  TcpConnection::receive(char *data, unsigned int length) {
    int ret = read(_fd, (void *)data, length) ;
    if (ret==(int)length) return ;
    std::string msg ;
    if (ret==-1) msg = "read failed" ;
    else msg = "couldn't read all the bytes" ;
    throw std::runtime_error(msg) ;
  }

  // -------------------------------------------------------------------------

  std::string
  TcpConnection::machineLookUp(void) {
    sockaddr_in addr;
    struct hostent *h ;
    socklen_t lenaddr = sizeof(sockaddr_in);

    if (getpeername(_fd,(struct sockaddr *)&addr,&lenaddr)==-1)
	 throw std::runtime_error("TcpConnection: machineLookUp failed") ;

    if ((h=gethostbyaddr((char *)&addr.sin_addr, sizeof(addr.sin_addr), AF_INET)))
	 return std::string(h->h_name) ;
    else {
	 unsigned char *v = (unsigned char *)&addr.sin_addr.s_addr ;
	 char result[256] ;
	 sprintf(result, "%d.%d.%d.%d",v[0],v[1],v[2],v[3]) ;
	 return std::string(result) ;
    }
  }

  std::string
  TcpConnection::userLookUp(int millisecs) {
    sockaddr_in myaddr;
    socklen_t lenmyaddr = sizeof(sockaddr_in);
    sockaddr_in hisaddr;
    socklen_t lenhisaddr = sizeof(sockaddr_in);

    if (getsockname(_fd, (sockaddr *)&myaddr, &lenmyaddr)==-1)
      return "?" ;
    // throw std::runtime_error("TcpConnection: userLookUp failed (getsockname)") ;

    if (getpeername(_fd,(sockaddr *)&hisaddr,&lenhisaddr)==-1)
      return "?" ;
    // throw std::runtime_error("TcpConnection: userLookUp failed (getpeername)") ;

    struct hostent *h = gethostbyaddr((char *)&hisaddr.sin_addr, sizeof(hisaddr.sin_addr), AF_INET) ;
    if (h==0)
      return "?" ;
    // throw std::runtime_error("TcpConnection: userLookUp failed (gethostbyaddr)") ;

    int isock = socket(AF_INET, SOCK_STREAM, 0) ;
    struct sockaddr_in addr ;
    addr.sin_family = AF_INET ;
    addr.sin_port = htons(113) ;
    addr.sin_addr.s_addr = *(long*)h->h_addr ;
    memset(addr.sin_zero, 0, 8) ;

    setblocking(isock, 0) ;

    if( connect(isock, (sockaddr *)&addr, sizeof(addr)) ) {
#ifdef WIN32
      if (WSAGetLastError()==WSAEALREADY)
#else
      if (errno==EINPROGRESS)
#endif
	{
	  // FIXME implementation by hand of the FileDescriptor class
	  // if the code becomes too big, try to copy the orignal
	  // code (see videoSpace/videoSpace/system/FileUtils.H
	  fd_set rfds;
	  struct timeval tv;
	     
	  FD_ZERO(&rfds);
	  FD_SET(isock, &rfds);
	  tv.tv_usec = millisecs;
	  int	result = select(0, 0, &rfds, 0, &tv);
	  if (! result) {
	    return "?" ;
	    // throw std::runtime_error("TcpConnection: userLookUp timed out") ;
	  } else {
#ifdef WIN32
      char val=0 ;
#else
      int val=0 ;
#endif
	    socklen_t len=sizeof(val) ;
	    getsockopt(isock,SOL_SOCKET,SO_ERROR,&val,&len) ;
#ifdef WIN32
	    if (val==WSAENETDOWN) {
#else
	    if (val==ETIMEDOUT || val==ECONNREFUSED || val==EHOSTDOWN || val==EHOSTUNREACH) {
#endif
	      return "?" ;
	      // throw std::runtime_error("TcpConnection: userLookUp couldn't connect") ;
	    }
	  }
	} else {
	  return "?" ;
	  // throw std::runtime_error("TcpConnection: userLookUp couldn't connect (2)") ;
	}
    }

    char buffer[512] ;
    sprintf(buffer, "%d, %d\n", ntohs(hisaddr.sin_port), ntohs(myaddr.sin_port)) ;
    setblocking(isock, 0) ;
    write(isock, buffer, strlen(buffer)) ;
    setblocking(isock, 1) ;

    int bytesread = read(isock, buffer, 512) ;
    if (!bytesread) 
      return "?" ;
    // throw std::runtime_error("TcpConnection: userLookUp couldn't read identity") ;

    while (bytesread>0 && isspace((int)buffer[bytesread-1])) bytesread-- ;
    buffer[bytesread] = '\0';

    int i ;
    for (i=bytesread; i>0 && buffer[i-1]!=':'; i--) ;
    return std::string(buffer+i) ;
  }


  void
  TcpConnection::close(void) {
    if (_fd!=-1) {
	 shutdown(_fd,2) ;
	 ::close(_fd) ;
	 _fd = -1 ;
    }
  }

  TcpConnection::~TcpConnection(void) {
    if (_close) close() ;
  }

void	setblocking(int fd, int doblock)
{
#ifdef WIN32
  u_long nonblocking = !doblock ;
  if (ioctlsocket(fd, FIONBIO, &nonblocking)==-1)
    g_critical("ioctl FIONBIO failed (setblocking)");
#else
  long nonblocking = !doblock ;
  if (ioctl(fd, FIONBIO, &nonblocking)==-1)
    g_critical("ioctl FIONBIO failed (setblocking)");
#endif
}
