/*
 * This program creates a pipeline using forks and pipes.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/wait.h>

static int 
grandchild(int filedes[2])
{
  if (close(filedes[1]) == -1) {
    perror("close in grandchild");
    return 1;
  }
  if (fcntl(filedes[0], F_SETFD, FD_CLOEXEC) == -1) {
    perror("fcntl in grandchild");
    return 1;
  }
  if (dup2(filedes[0], 0) ==  -1) { /* original stdin is close here */
    perror("dup2 grandchild");
    return 1;
  }
  execl("/bin/cat", "/bin/cat", NULL);
  perror("execl");
  return 1;
}

static int 
child(int filedes[2])
{
  if (close(filedes[1]) == -1) {
    perror("close in child");
    return 1;
  }
  FILE *in = fdopen(filedes[0], "r");
  if (!in) {
    perror("fdopen in child");
    return 1;
  }
  if (pipe(filedes)) {
    perror("pipe in child");
    return 1;
  }
  pid_t pid = fork();
  if (pid == -1) {
    perror("fork in child");
    return 1;
  }
  if (pid == 0)
    return grandchild(filedes);
  else {
    if (close(filedes[0]) == -1) {
      perror("close in child");
      return 1;
    }
    FILE *out = fdopen(filedes[1], "w");
    if (!out) {
      perror("fdopen in child");
      return 1;
    }
    for (;;) {
      int ch = getc(in);
      if (ch == EOF)
	break;
      else
	putc(ch, out);
    }
    if (ferror(in)) {
      perror("getc");
      return 1;
    }
    if (fclose(out) == -1) {
      perror("fclose in child");
      return 1;
    }
    int status;
    if (wait(&status) == -1) {
      perror("wait");
      return 1;
    }
    return 0;
  }
}

int 
main(int argc, char **argv)
{
  int filedes[2];
  if (pipe(filedes)) {
    perror("pipe in parent");
    return 1;
  }
  pid_t pid = fork();
  if (pid == -1) {
    perror("fork in parent");
    return 1;
  }
  if (pid == 0)
    return child(filedes);
  else {
    if (close(filedes[0]) == -1) {
      perror("close in parent");
      return 1;
    }
    FILE *out = fdopen(filedes[1], "w");
    if (!out) {
      perror("fdopen in parent");
      return 1;
    }
    fprintf(out, "Hello, World!\n");
    if (fclose(out) == -1) {
      perror("fclose in parent");
      return 1;
    }
    int status;
    if (wait(&status) == -1) {
      perror("wait");
      return 1;
    }
    return 0;
  }
}
