Summary: SELinux policy core utilities.
Name: policycoreutils
Version: 1.18
Release: 1
License: GPL
Group: System Environment/Base
Source: http://www.nsa.gov/selinux/archives/policycoreutils-%{version}.tgz

Prefix: %{_prefix}
BuildRequires: libselinux-devel libsepol-devel 
Requires: libselinux libsepol 

BuildRoot: %{_tmppath}/%{name}-buildroot

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

policycoreutils contains the policy core utilities that are required
for basic operation of a SELinux system.  These utilities include
load_policy to load policies, setfiles to label filesystems, newrole
to switch roles, and run_init to run /etc/init.d scripts in the proper
context.

%prep
%setup -q

%build
make CFLAGS="%{optflags}" all 

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}/sbin
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man1
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/pam.d
make DESTDIR="${RPM_BUILD_ROOT}" install

%find_lang %{name}

%clean
rm -rf ${RPM_BUILD_ROOT}

%files -f %{name}.lang
%defattr(-,root,root)
%{_sbindir}/setfiles
/sbin/fixfiles
/sbin/restorecon
%{_mandir}/man8/restorecon.8.gz
%{_sbindir}/genhomedircon
%{_sbindir}/sestatus
%{_mandir}/man8/sestatus.8.gz
%{_mandir}/man8/setfiles.8.gz
%{_mandir}/man8/fixfiles.8.gz
%{_mandir}/man8/load_policy.8.gz
%{_sbindir}/load_policy
%{_bindir}/newrole
%{_bindir}/audit2allow
%{_mandir}/man1/newrole.1.gz
%{_sysconfdir}/cron.weekly/fixfiles.cron
%config %{_sysconfdir}/pam.d/newrole
%{_sbindir}/run_init
%config %{_sysconfdir}/pam.d/run_init
%{_mandir}/man8/run_init.8.gz
%config(noreplace) %{_sysconfdir}/sestatus.conf


%changelog
