/*
based on the Keramik and Plastik configuration dialog:

Plastik:
Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

Keramik:
Copyright (c) 2003 Maksim Orlovich <maksim.orlovich@kdemail.net>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qsettings.h>
#include <qcolor.h>
#include <qgroupbox.h>
#include <kglobal.h>
#include <klocale.h>
#include <kcolorbutton.h>
#include <kdemacros.h>

#include "polyesterconf.h"

extern "C"
{
	KDE_EXPORT QWidget* allocate_kstyle_config(QWidget* parent)
	{
		KGlobal::locale()->insertCatalogue("kstyle_polyester_config");
		return new PolyesterStyleConfig(parent);
	}
}

PolyesterStyleConfig::PolyesterStyleConfig(QWidget* parent): QWidget(parent)
{
	//Should have no margins here, the dialog provides them
	QVBoxLayout* layout = new QVBoxLayout(this, 0, 0);
	KGlobal::locale()->insertCatalogue("kstyle_polyester_config");

	scrollBarLines = new QCheckBox(i18n("Scrollbar handle lines"), this);
	coloredScrollBar = new QCheckBox(i18n("Colored scrollbars"), this);
	centeredTabBar = new QCheckBox(i18n("Centered tabbars"), this);
	animateProgressBar = new QCheckBox(i18n("Animate progress bars"), this);
	animateButton = new QCheckBox(i18n("Animate buttons"), this);

        QHBox *hboxToDark = new QHBox(this);
        hboxToDark->layout()->addItem(new QSpacerItem(20, 0, QSizePolicy::Fixed, QSizePolicy::Minimum) );
	animateButtonToDark = new QCheckBox(i18n("Animate buttons to a darker color"), hboxToDark);

	drawToolBarSeparator = new QCheckBox(i18n("Draw toolbar separator"), this);
	drawToolBarItemSeparator = new QCheckBox(i18n("Draw toolbar item separators"), this);
//	drawFocusRect = new QCheckBox(i18n("Draw focus rectangles"), this);
	drawTriangularExpander = new QCheckBox(i18n("Triangular tree expander"), this);
	inputFocusHighlight = new QCheckBox(i18n("Highlight focused text input fields"), this);

	QLabel* buttonStyleLabel;
	buttonStyleLabel = new QLabel(this);
	buttonStyleLabel->setText(i18n("Button Style: "));
	buttonStyle =  new QComboBox(i18n("Button style"), this);
	buttonStyle->setEditable(false);
	buttonStyle->insertItem("Glass buttons");
	buttonStyle->insertItem("Gradients");
	buttonStyle->insertItem("Reverse gradients");


    customFocusHighlightColor = new QCheckBox(i18n("Custom text input highlight color:"), this);
    QHBox *hbox1 = new QHBox(this);
    hbox1->layout()->addItem(new QSpacerItem(20, 0, QSizePolicy::Fixed, QSizePolicy::Minimum) );
    focusHighlightColor = new KColorButton(hbox1);

    customOverHighlightColor = new QCheckBox(i18n("Custom mouseover highlight color:"), this);
    QHBox *hbox2 = new QHBox(this);
    hbox2->layout()->addItem(new QSpacerItem(20, 0, QSizePolicy::Fixed, QSizePolicy::Minimum) );
    overHighlightColor = new KColorButton(hbox2);

    customCheckMarkColor = new QCheckBox(i18n("Custom checkmark color:"), this);
    QHBox *hbox3 = new QHBox(this);
    hbox3->layout()->addItem(new QSpacerItem(20, 0, QSizePolicy::Fixed, QSizePolicy::Minimum) );
    checkMarkColor = new KColorButton(hbox3);

	layout->add(scrollBarLines);
	layout->add(coloredScrollBar);
	layout->add(centeredTabBar);
	layout->add(animateProgressBar);
	layout->add(animateButton);
	layout->add(hboxToDark);
	layout->add(drawToolBarSeparator);
	layout->add(drawToolBarItemSeparator);
//	layout->add(drawFocusRect);
	layout->add(drawTriangularExpander);
	layout->add(inputFocusHighlight);
	layout->add(buttonStyleLabel);
	layout->add(buttonStyle);
    layout->add(customFocusHighlightColor);
	layout->add(hbox1);
    layout->add(customOverHighlightColor);
    layout->add(hbox2);
	layout->add(customCheckMarkColor);
	layout->add(hbox3);
	layout->addStretch(1);

	QSettings s;
	origScrollBarLines = s.readBoolEntry("/polyesterstyle/Settings/scrollBarLines", false);
	scrollBarLines->setChecked(origScrollBarLines);
	origColoredScrollBar = s.readBoolEntry("/polyesterstyle/Settings/coloredScrollBar", true);
	coloredScrollBar->setChecked(origColoredScrollBar);
	origCenteredTabBar = s.readBoolEntry("/polyesterstyle/Settings/centeredTabBar", false);
	centeredTabBar->setChecked(origCenteredTabBar);
	origAnimProgressBar = s.readBoolEntry("/polyesterstyle/Settings/animateProgressBar", false);
	animateProgressBar->setChecked(origAnimProgressBar);
	origAnimButton = s.readBoolEntry("/polyesterstyle/Settings/animateButton", false);
	animateButton->setChecked(origAnimButton);
	origAnimButtonToDark = s.readBoolEntry("/polyesterstyle/Settings/animateButtonToDark", false);
	animateButtonToDark->setChecked(origAnimButtonToDark);
	origDrawToolBarSeparator = s.readBoolEntry("/polyesterstyle/Settings/drawToolBarSeparator", true);
	drawToolBarSeparator->setChecked(origDrawToolBarSeparator);
	origDrawToolBarItemSeparator = s.readBoolEntry("/polyesterstyle/Settings/drawToolBarItemSeparator", true);
	drawToolBarItemSeparator->setChecked(origDrawToolBarItemSeparator);
//	origDrawFocusRect = s.readBoolEntry("/polyesterstyle/Settings/drawFocusRect", true);
//	drawFocusRect->setChecked(origDrawFocusRect);
	origDrawTriangularExpander = s.readBoolEntry("/polyesterstyle/Settings/drawTriangularExpander", false);
	drawTriangularExpander->setChecked(origDrawTriangularExpander);
	origInputFocusHighlight = s.readBoolEntry("/polyesterstyle/Settings/inputFocusHighlight", true);
	inputFocusHighlight->setChecked(origInputFocusHighlight);
	origButtonStyle = s.readEntry("/polyesterstyle/Settings/buttonStyle", "glass");
	buttonStyle->setCurrentItem(buttonItem(origButtonStyle));
	origCustomOverHighlightColor = s.readBoolEntry("/polyesterstyle/Settings/customOverHighlightColor", false);
	customOverHighlightColor->setChecked(origCustomOverHighlightColor);
	origOverHighlightColor = s.readEntry("/polyesterstyle/Settings/overHighlightColor", "black");
	overHighlightColor->setColor(origOverHighlightColor);
	origCustomFocusHighlightColor = s.readBoolEntry("/polyesterstyle/Settings/customFocusHighlightColor", false);
	customFocusHighlightColor->setChecked(origCustomFocusHighlightColor);
	origFocusHighlightColor = s.readEntry("/polyesterstyle/Settings/focusHighlightColor", "black");
	focusHighlightColor->setColor(origFocusHighlightColor);
	origCustomCheckMarkColor = s.readBoolEntry("/polyesterstyle/Settings/customCheckMarkColor", false);
	customCheckMarkColor->setChecked(origCustomCheckMarkColor);
	origCheckMarkColor = s.readEntry("/polyesterstyle/Settings/checkMarkColor", "black");
	checkMarkColor->setColor(origCheckMarkColor);

	connect(scrollBarLines, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(coloredScrollBar, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(centeredTabBar, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(animateProgressBar, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(animateButton, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(animateButtonToDark, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(drawToolBarSeparator, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(drawToolBarItemSeparator, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
//	connect(drawFocusRect, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(drawTriangularExpander, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(inputFocusHighlight, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(buttonStyle, SIGNAL( activated(int) ), SLOT( updateChanged() ) );
	connect(customOverHighlightColor, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(overHighlightColor, SIGNAL( changed(QColor) ), SLOT( updateChanged() ) );
	connect(customFocusHighlightColor, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(focusHighlightColor, SIGNAL( changed(QColor) ), SLOT( updateChanged() ) );
	connect(customCheckMarkColor, SIGNAL( toggled(bool) ), SLOT( updateChanged() ) );
	connect(checkMarkColor, SIGNAL( changed(QColor) ), SLOT( updateChanged() ) );

	if ( animateButton->isChecked() )
	 animateButtonToDark->setEnabled(true);
	else
	 animateButtonToDark->setEnabled(false);

	if ( customOverHighlightColor->isChecked() )
	 overHighlightColor->setEnabled(true);
	else
	 overHighlightColor->setEnabled(false);

	if ( customFocusHighlightColor->isChecked() )
	 focusHighlightColor->setEnabled(true);
	else
	 focusHighlightColor->setEnabled(false);

	if ( customCheckMarkColor->isChecked() )
	 checkMarkColor->setEnabled(true);
	else
	 checkMarkColor->setEnabled(false);
}

PolyesterStyleConfig::~PolyesterStyleConfig()
{
}


void PolyesterStyleConfig::save()
{
	QSettings s;
	s.writeEntry("/polyesterstyle/Settings/scrollBarLines", scrollBarLines->isChecked());
	s.writeEntry("/polyesterstyle/Settings/coloredScrollBar", coloredScrollBar->isChecked());
	s.writeEntry("/polyesterstyle/Settings/centeredTabBar", centeredTabBar->isChecked());
	s.writeEntry("/polyesterstyle/Settings/animateProgressBar", animateProgressBar->isChecked());
	s.writeEntry("/polyesterstyle/Settings/animateButton", animateButton->isChecked());
	s.writeEntry("/polyesterstyle/Settings/animateButtonToDark", animateButtonToDark->isChecked());
	s.writeEntry("/polyesterstyle/Settings/drawToolBarSeparator", drawToolBarSeparator->isChecked());
	s.writeEntry("/polyesterstyle/Settings/drawToolBarItemSeparator", drawToolBarItemSeparator->isChecked());
//	s.writeEntry("/polyesterstyle/Settings/drawFocusRect", drawFocusRect->isChecked());
	s.writeEntry("/polyesterstyle/Settings/drawTriangularExpander", drawTriangularExpander->isChecked());
	s.writeEntry("/polyesterstyle/Settings/inputFocusHighlight", inputFocusHighlight->isChecked());
	s.writeEntry("/polyesterstyle/Settings/buttonStyle", buttonType(buttonStyle->currentItem()));
	s.writeEntry("/polyesterstyle/Settings/customOverHighlightColor", customOverHighlightColor->isChecked());
	s.writeEntry("/polyesterstyle/Settings/overHighlightColor", QColor(overHighlightColor->color()).name());
	s.writeEntry("/polyesterstyle/Settings/customFocusHighlightColor", customFocusHighlightColor->isChecked());
	s.writeEntry("/polyesterstyle/Settings/focusHighlightColor", QColor(focusHighlightColor->color()).name());
	s.writeEntry("/polyesterstyle/Settings/customCheckMarkColor", customCheckMarkColor->isChecked());
	s.writeEntry("/polyesterstyle/Settings/checkMarkColor", QColor(checkMarkColor->color()).name());
}

void PolyesterStyleConfig::defaults()
{
	scrollBarLines->setChecked(false);
	coloredScrollBar->setChecked(true);
	centeredTabBar->setChecked(false);
	animateProgressBar->setChecked(false);
	animateButton->setChecked(false);
	animateButtonToDark->setChecked(false);
	drawToolBarSeparator->setChecked(true);
	drawToolBarItemSeparator->setChecked(true);
//	drawFocusRect->setChecked(true);
	drawTriangularExpander->setChecked(false);
	inputFocusHighlight->setChecked(true);
	buttonStyle->setCurrentItem(0);
	customOverHighlightColor->setChecked(false);
	overHighlightColor->setColor("black");
	customFocusHighlightColor->setChecked(false);
	focusHighlightColor->setColor("black");
	customCheckMarkColor->setChecked(false);
	checkMarkColor->setColor("black");
	//updateChanged would be done by setChecked already
}

void PolyesterStyleConfig::updateChanged()
{
	if ( animateButton->isChecked() )
	 animateButtonToDark->setEnabled(true);
	else
	 animateButtonToDark->setEnabled(false);

	if ( customOverHighlightColor->isChecked() )
	 overHighlightColor->setEnabled(true);
	else
	 overHighlightColor->setEnabled(false);

	if ( customFocusHighlightColor->isChecked() )
	 focusHighlightColor->setEnabled(true);
	else
	 focusHighlightColor->setEnabled(false);

	if ( customCheckMarkColor->isChecked() )
	 checkMarkColor->setEnabled(true);
	else
	 checkMarkColor->setEnabled(false);

	if ((scrollBarLines->isChecked() == origScrollBarLines) &&
	     (coloredScrollBar->isChecked() == origColoredScrollBar) &&
	     (centeredTabBar->isChecked() == origCenteredTabBar) &&
	      (animateProgressBar->isChecked() == origAnimProgressBar) &&
	       (animateButton->isChecked() == origAnimButton) &&
	       (animateButtonToDark->isChecked() == origAnimButtonToDark) &&
	        (drawToolBarSeparator->isChecked() == origDrawToolBarSeparator) &&
	         (drawToolBarItemSeparator->isChecked() == origDrawToolBarItemSeparator) &&
//	          (drawFocusRect->isChecked() == origDrawFocusRect) &&
		   (drawTriangularExpander->isChecked() == origDrawTriangularExpander) &&
		    (inputFocusHighlight->isChecked() == origInputFocusHighlight) &&
		     (customOverHighlightColor->isChecked() == origCustomOverHighlightColor) &&
		      (overHighlightColor->color() == origOverHighlightColor) &&
		       (buttonStyle->currentText() == origButtonStyle) &&
		        (customFocusHighlightColor->isChecked() == origCustomFocusHighlightColor) &&
		         (focusHighlightColor->color() == origFocusHighlightColor) &&
			  (customCheckMarkColor->isChecked() == origCustomCheckMarkColor) &&
			   (checkMarkColor->color() == origCheckMarkColor)
	     )
		emit changed(false);
	else
		emit changed(true);
}

//button types
QString PolyesterStyleConfig::buttonType( int listnr )
{
    switch ( listnr ) {
        case 1:
            return QString("gradients");
	case 2:
	    return QString("reverseGradients");
        default:
            return QString("glass");
    }
}

int PolyesterStyleConfig::buttonItem( QString kBType )
{
    if( !strcmp(kBType,"gradients") )
        return 1;
    else if( !strcmp(kBType,"reverseGradients") )
        return 2;
    else
        return 0;
}

#include "polyesterconf.moc"
