/*
    Title:      Error Messages.
    Copyright (c) 2012
        David C. J. Matthews

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.
    
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
    
    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#elif defined(_WIN32)
#include "winconfig.h"
#else
#error "No configuration file"
#endif

#if (defined(_WIN32) && ! defined(__CYGWIN__))
#include <winsock2.h>
#endif

#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "errors.h"

static struct {
    int           errorNum;
    const char*   errorString;
} errortable[] =
{
#if(!defined(_WIN32) || defined(__CYGWIN__))
#ifdef EPERM
    { EPERM,    "EPERM" },
#endif
#ifdef ENOENT
    { ENOENT,   "ENOENT" },
#endif
#ifdef ESRCH
    { ESRCH,    "ESRCH" },
#endif
#ifdef EINTR
    { EINTR, "EINTR"},
#endif
#ifdef EIO
    { EIO, "EIO"},
#endif
#ifdef ENXIO
    { ENXIO, "ENXIO"},
#endif
#ifdef E2BIG
    { E2BIG, "E2BIG"},
#endif
#ifdef ENOEXEC
    { ENOEXEC, "ENOEXEC"},
#endif
#ifdef EBADF
    { EBADF, "EBADF"},
#endif
#ifdef ECHILD
    { ECHILD, "ECHILD"},
#endif
#ifdef EAGAIN
    { EAGAIN, "EAGAIN"},
#endif
#ifdef EDEADLK
    { EDEADLK, "EDEADLK"},
#endif
#ifdef ENOMEM
    { ENOMEM, "ENOMEM"},
#endif
#ifdef EACCES
    { EACCES, "EACCES"},
#endif
#ifdef EFAULT
    { EFAULT, "EFAULT"},
#endif
#ifdef ENOTBLK
    { ENOTBLK, "ENOTBLK"},
#endif
#ifdef EBUSY
    { EBUSY, "EBUSY"},
#endif
#ifdef EEXIST
    { EEXIST, "EEXIST"},
#endif
#ifdef EXDEV
    { EXDEV, "EXDEV"},
#endif
#ifdef ENODEV
    { ENODEV, "ENODEV"},
#endif
#ifdef ENOTDIR
    { ENOTDIR, "ENOTDIR"},
#endif
#ifdef EISDIR
    { EISDIR, "EISDIR"},
#endif
#ifdef EINVAL
    { EINVAL, "EINVAL"},
#endif
#ifdef ENFILE
    { ENFILE, "ENFILE"},
#endif
#ifdef EMFILE
    { EMFILE, "EMFILE"},
#endif
#ifdef ENOTTY
    { ENOTTY, "ENOTTY"},
#endif
#ifdef ETXTBSY
    { ETXTBSY, "ETXTBSY"},
#endif
#ifdef EFBIG
    { EFBIG, "EFBIG"},
#endif
#ifdef ENOSPC
    { ENOSPC, "ENOSPC"},
#endif
#ifdef ESPIPE
    { ESPIPE, "ESPIPE"},
#endif
#ifdef EROFS
    { EROFS, "EROFS"},
#endif
#ifdef EMLINK
    { EMLINK, "EMLINK"},
#endif
#ifdef EPIPE
    { EPIPE, "EPIPE"},
#endif
#ifdef EDOM
    { EDOM, "EDOM"},
#endif
#ifdef ERANGE
    { ERANGE, "ERANGE"},
#endif
#ifdef ENOMSG
    { ENOMSG, "ENOMSG"},
#endif
#ifdef EUCLEAN
    { EUCLEAN, "EUCLEAN"},
#endif
#ifdef EWOULDBLOCK
    { EWOULDBLOCK, "EWOULDBLOCK"},
#endif
#ifdef EIDRM
    { EIDRM, "EIDRM"},
#endif
#ifdef EINPROGRESS
    { EINPROGRESS, "EINPROGRESS"},
#endif
#ifdef ECHRNG
    { ECHRNG, "ECHRNG"},
#endif
#ifdef EALREADY
    { EALREADY, "EALREADY"},
#endif
#ifdef EL2NSYNC
    { EL2NSYNC, "EL2NSYNC"},
#endif
#ifdef ENAMETOOLONG
    { ENAMETOOLONG, "ENAMETOOLONG"},
#endif
#ifdef ENOTSOCK
    { ENOTSOCK, "ENOTSOCK"},
#endif
#ifdef EL3HLT
    { EL3HLT, "EL3HLT"},
#endif
#ifdef ENOLCK
    { ENOLCK, "ENOLCK"},
#endif
#ifdef EDESTADDRREQ
    { EDESTADDRREQ, "EDESTADDRREQ"},
#endif
#ifdef EL3RST
    { EL3RST, "EL3RST"},
#endif
#ifdef ENOSYS
    { ENOSYS, "ENOSYS"},
#endif
#ifdef EMSGSIZE
    { EMSGSIZE, "EMSGSIZE"},
#endif
#ifdef ELNRNG
    { ELNRNG, "ELNRNG"},
#endif
#ifdef ENOTEMPTY
    { ENOTEMPTY, "ENOTEMPTY"},
#endif
#ifdef EPROTOTYPE
    { EPROTOTYPE, "EPROTOTYPE"},
#endif
#ifdef EUNATCH
    { EUNATCH, "EUNATCH"},
#endif
#ifdef EILSEQ
    { EILSEQ, "EILSEQ"},
#endif
#ifdef ENOPROTOOPT
    { ENOPROTOOPT, "ENOPROTOOPT"},
#endif
#ifdef ENOCSI
    { ENOCSI, "ENOCSI"},
#endif
#ifdef EPROTONOSUPPORT
    { EPROTONOSUPPORT, "EPROTONOSUPPORT"},
#endif
#ifdef EL2HLT
    { EL2HLT, "EL2HLT"},
#endif
#ifdef ESOCKTNOSUPPORT
    { ESOCKTNOSUPPORT, "ESOCKTNOSUPPORT"},
#endif
#ifdef EOPNOTSUPP
    { EOPNOTSUPP, "EOPNOTSUPP"},
#endif
#ifdef ENOTREADY
    { ENOTREADY, "ENOTREADY"},
#endif
#ifdef EPFNOSUPPORT
    { EPFNOSUPPORT, "EPFNOSUPPORT"},
#endif
#ifdef EWRPROTECT
    { EWRPROTECT, "EWRPROTECT"},
#endif
#ifdef EAFNOSUPPORT
    { EAFNOSUPPORT, "EAFNOSUPPORT"},
#endif
#ifdef EFORMAT
    { EFORMAT, "EFORMAT"},
#endif
#ifdef EADDRINUSE
    { EADDRINUSE, "EADDRINUSE"},
#endif
#ifdef EADDRNOTAVAIL
    { EADDRNOTAVAIL, "EADDRNOTAVAIL"},
#endif
#ifdef ENOCONNECT
    { ENOCONNECT, "ENOCONNECT"},
#endif
#ifdef ENETDOWN
    { ENETDOWN, "ENETDOWN"},
#endif
#ifdef ESTALE
    { ESTALE, "ESTALE"},
#endif
#ifdef ENETUNREACH
    { ENETUNREACH, "ENETUNREACH"},
#endif
#ifdef EDIST
    { EDIST, "EDIST"},
#endif
#ifdef ENETRESET
    { ENETRESET, "ENETRESET"},
#endif
#ifdef ECONNABORTED
    { ECONNABORTED, "ECONNABORTED"},
#endif
#ifdef ECONNRESET
    { ECONNRESET, "ECONNRESET"},
#endif
#ifdef ENOBUFS
    { ENOBUFS, "ENOBUFS"},
#endif
#ifdef EISCONN
    { EISCONN, "EISCONN"},
#endif
#ifdef ENOTCONN
    { ENOTCONN, "ENOTCONN"},
#endif
#ifdef ESHUTDOWN
    { ESHUTDOWN, "ESHUTDOWN"},
#endif
#ifdef ETOOMANYREFS
    { ETOOMANYREFS, "ETOOMANYREFS"},
#endif
#ifdef ETIMEDOUT
    { ETIMEDOUT, "ETIMEDOUT"},
#endif
#ifdef ECONNREFUSED
    { ECONNREFUSED, "ECONNREFUSED"},
#endif
#ifdef ELOOP
    { ELOOP, "ELOOP"},
#endif
#ifdef EHOSTDOWN
    { EHOSTDOWN, "EHOSTDOWN"},
#endif
#ifdef EHOSTUNREACH
    { EHOSTUNREACH, "EHOSTUNREACH"},
#endif
#ifdef EPROCLIM
    { EPROCLIM, "EPROCLIM"},
#endif
#ifdef EUSERS
    { EUSERS, "EUSERS"},
#endif
#ifdef EDQUOT
    { EDQUOT, "EDQUOT"},
#endif
#ifdef EREMOTE
    { EREMOTE, "EREMOTE"},
#endif
#ifdef ENOSTR
    { ENOSTR, "ENOSTR"},
#endif
#ifdef EBADRPC
    { EBADRPC, "EBADRPC"},
#endif
#ifdef ETIME
    { ETIME, "ETIME"},
#endif
#ifdef ERPCMISMATCH
    { ERPCMISMATCH, "ERPCMISMATCH"},
#endif
#ifdef ENOSR
    { ENOSR, "ENOSR"},
#endif
#ifdef EPROGUNAVAIL
    { EPROGUNAVAIL, "EPROGUNAVAIL"},
#endif
#ifdef EPROGMISMATCH
    { EPROGMISMATCH, "EPROGMISMATCH"},
#endif
#ifdef EBADMSG
    { EBADMSG, "EBADMSG"},
#endif
#ifdef EPROCUNAVAIL
    { EPROCUNAVAIL, "EPROCUNAVAIL"},
#endif
#ifdef EFTYPE
    { EFTYPE, "EFTYPE"},
#endif
#ifdef ENONET
    { ENONET, "ENONET"},
#endif
#ifdef EAUTH
    { EAUTH, "EAUTH"},
#endif
#ifdef ERESTART
    { ERESTART, "ERESTART"},
#endif
#ifdef ERREMOTE
    { ERREMOTE, "ERREMOTE"},
#endif
#ifdef ENEEDAUTH
    { ENEEDAUTH, "ENEEDAUTH"},
#endif
#ifdef ENOLINK
    { ENOLINK, "ENOLINK"},
#endif
#ifdef EADV
    { EADV, "EADV"},
#endif
#ifdef ESRMNT
    { ESRMNT, "ESRMNT"},
#endif
#ifdef ECOMM
    { ECOMM, "ECOMM"},
#endif
#ifdef EPROTO
    { EPROTO, "EPROTO"},
#endif
#ifdef EMULTIHOP
    { EMULTIHOP, "EMULTIHOP"},
#endif
#ifdef EDOTDOT
    { EDOTDOT, "EDOTDOT"},
#endif
#ifdef EREMCHG
    { EREMCHG, "EREMCHG"},
#endif
#ifdef EMEDIA
    { EMEDIA, "EMEDIA"},
#endif
#ifdef ESOFT
    { ESOFT, "ESOFT"},
#endif
#ifdef ENOATTR
    { ENOATTR, "ENOATTR"},
#endif
#ifdef ESAD
    { ESAD, "ESAD"},
#endif
#ifdef ENOTRUST
    { ENOTRUST, "ENOTRUST"},
#endif
#ifdef ECANCELED
    { ECANCELED, "ECANCELED"},
#endif
#ifdef ENODATA
    { ENODATA, "ENODATA"},
#endif
#ifdef EBADE
    { EBADE, "EBADE"},
#endif
#ifdef EBADR
    { EBADR, "EBADR"},
#endif
#ifdef EXFULL
    { EXFULL, "EXFULL"},
#endif
#ifdef ENOANO
    { ENOANO, "ENOANO"},
#endif
#ifdef EBADRQC
    { EBADRQC, "EBADRQC"},
#endif
#ifdef EBADSLT
    { EBADSLT, "EBADSLT"},
#endif
#ifdef EDEADLOCK
    { EDEADLOCK, "EDEADLOCK"},
#endif
#ifdef EBFONT
    { EBFONT, "EBFONT"},
#endif
#ifdef EBFONT
    { EBFONT, "EBFONT"},
#endif
#ifdef ENOPKG
    { ENOPKG, "ENOPKG"},
#endif
#ifdef ELBIN
    { ELBIN, "ELBIN"},
#endif
#ifdef ENOTUNIQ
    { ENOTUNIQ, "ENOTUNIQ"},
#endif
#ifdef EBADFD
    { EBADFD, "EBADFD"},
#endif
#ifdef ELIBACC
    { ELIBACC, "ELIBACC"},
#endif
#ifdef ELIBBAD
    { ELIBBAD, "ELIBBAD"},
#endif
#ifdef ELIBSCN
    { ELIBSCN, "ELIBSCN"},
#endif
#ifdef ELIBMAX
    { ELIBMAX, "ELIBMAX"},
#endif
#ifdef ESTRPIPE
    { ESTRPIPE, "ESTRPIPE"},
#endif
#ifdef ELIBEXEC
    { ELIBEXEC, "ELIBEXEC"},
#endif
#ifdef ENMFILE
    { ENMFILE, "ENMFILE"},
#endif
#ifdef ENOTNAM
    { ENOTNAM, "ENOTNAM"},
#endif
#ifdef ENAVAIL
    { ENAVAIL, "ENAVAIL"},
#endif
#ifdef EISNAM
    { EISNAM, "EISNAM"},
#endif
#ifdef EREMOTEIO
    { EREMOTEIO, "EREMOTEIO"},
#endif
#ifdef ENOMEDIUM
    { ENOMEDIUM, "ENOMEDIUM"},
#endif
#ifdef EMEDIUMTYPE
    { EMEDIUMTYPE, "EMEDIUMTYPE"},
#endif
#ifdef ENOKEY
    { ENOKEY, "ENOKEY"},
#endif
#ifdef EKEYEXPIRED
    { EKEYEXPIRED, "EKEYEXPIRED"},
#endif
#ifdef EKEYREVOKED
    { EKEYREVOKED, "EKEYREVOKED"},
#endif
#ifdef EKEYREJECTED
    { EKEYREJECTED, "EKEYREJECTED"},
#endif
#ifdef EOWNERDEAD
    { EOWNERDEAD, "EOWNERDEAD"},
#endif
#ifdef ENOTRECOVERABLE
    { ENOTRECOVERABLE, "ENOTRECOVERABLE"},
#endif
#ifdef ENOTSUP
    { ENOTSUP, "ENOTSUP"},
#endif
#ifdef ENOMEDIUM
    { ENOMEDIUM, "ENOMEDIUM"},
#endif
#ifdef ENOSHARE
    { ENOSHARE, "ENOSHARE"},
#endif
#ifdef ECASECLASH
    { ECASECLASH, "ECASECLASH"},
#endif
#ifdef EOVERFLOW
    { EOVERFLOW, "EOVERFLOW"},
#endif

#else
/* We generate all Windows messages as negative numbers to
   distinguish them from Unix errno values. */
    { ERROR_INVALID_FUNCTION,  "ERROR_INVALID_FUNCTION" },
    { ERROR_FILE_NOT_FOUND,    "ERROR_FILE_NOT_FOUND" },
    { ERROR_PATH_NOT_FOUND,    "ERROR_PATH_NOT_FOUND" },
    { ERROR_TOO_MANY_OPEN_FILES,   "ERROR_TOO_MANY_OPEN_FILES" },
    { ERROR_ACCESS_DENIED, "ERROR_ACCESS_DENIED" },
    { ERROR_INVALID_HANDLE,    "ERROR_INVALID_HANDLE" },
    { ERROR_ARENA_TRASHED, "ERROR_ARENA_TRASHED" },
    { ERROR_NOT_ENOUGH_MEMORY, "ERROR_NOT_ENOUGH_MEMORY" },
    { ERROR_INVALID_BLOCK, "ERROR_INVALID_BLOCK" },
    { ERROR_BAD_ENVIRONMENT,   "ERROR_BAD_ENVIRONMENT" },
    { ERROR_BAD_FORMAT,    "ERROR_BAD_FORMAT" },
    { ERROR_INVALID_ACCESS,    "ERROR_INVALID_ACCESS" },
    { ERROR_INVALID_DATA,  "ERROR_INVALID_DATA" },
    { ERROR_OUTOFMEMORY,   "ERROR_OUTOFMEMORY" },
    { ERROR_INVALID_DRIVE, "ERROR_INVALID_DRIVE" },
    { ERROR_CURRENT_DIRECTORY, "ERROR_CURRENT_DIRECTORY" },
    { ERROR_NOT_SAME_DEVICE,   "ERROR_NOT_SAME_DEVICE" },
    { ERROR_NO_MORE_FILES, "ERROR_NO_MORE_FILES" },
    { ERROR_WRITE_PROTECT, "ERROR_WRITE_PROTECT" },
    { ERROR_BAD_UNIT,  "ERROR_BAD_UNIT" },
    { ERROR_NOT_READY, "ERROR_NOT_READY" },
    { ERROR_BAD_COMMAND,   "ERROR_BAD_COMMAND" },
    { ERROR_CRC,   "ERROR_CRC" },
    { ERROR_BAD_LENGTH,    "ERROR_BAD_LENGTH" },
    { ERROR_SEEK,  "ERROR_SEEK" },
    { ERROR_NOT_DOS_DISK,  "ERROR_NOT_DOS_DISK" },
    { ERROR_SECTOR_NOT_FOUND,  "ERROR_SECTOR_NOT_FOUND" },
    { ERROR_OUT_OF_PAPER,  "ERROR_OUT_OF_PAPER" },
    { ERROR_WRITE_FAULT,   "ERROR_WRITE_FAULT" },
    { ERROR_READ_FAULT,    "ERROR_READ_FAULT" },
    { ERROR_GEN_FAILURE,   "ERROR_GEN_FAILURE" },
    { ERROR_SHARING_VIOLATION, "ERROR_SHARING_VIOLATION" },
    { ERROR_LOCK_VIOLATION,    "ERROR_LOCK_VIOLATION" },
    { ERROR_WRONG_DISK,    "ERROR_WRONG_DISK" },
    { ERROR_SHARING_BUFFER_EXCEEDED,   "ERROR_SHARING_BUFFER_EXCEEDED" },
    { ERROR_HANDLE_EOF,    "ERROR_HANDLE_EOF" },
    { ERROR_HANDLE_DISK_FULL,  "ERROR_HANDLE_DISK_FULL" },
    { ERROR_NOT_SUPPORTED, "ERROR_NOT_SUPPORTED" },
    { ERROR_REM_NOT_LIST,  "ERROR_REM_NOT_LIST" },
    { ERROR_DUP_NAME,  "ERROR_DUP_NAME" },
    { ERROR_BAD_NETPATH,   "ERROR_BAD_NETPATH" },
    { ERROR_NETWORK_BUSY,  "ERROR_NETWORK_BUSY" },
    { ERROR_DEV_NOT_EXIST, "ERROR_DEV_NOT_EXIST" },
    { ERROR_TOO_MANY_CMDS, "ERROR_TOO_MANY_CMDS" },
    { ERROR_ADAP_HDW_ERR,  "ERROR_ADAP_HDW_ERR" },
    { ERROR_BAD_NET_RESP,  "ERROR_BAD_NET_RESP" },
    { ERROR_UNEXP_NET_ERR, "ERROR_UNEXP_NET_ERR" },
    { ERROR_BAD_REM_ADAP,  "ERROR_BAD_REM_ADAP" },
    { ERROR_PRINTQ_FULL,   "ERROR_PRINTQ_FULL" },
    { ERROR_NO_SPOOL_SPACE,    "ERROR_NO_SPOOL_SPACE" },
    { ERROR_PRINT_CANCELLED,   "ERROR_PRINT_CANCELLED" },
    { ERROR_NETNAME_DELETED,   "ERROR_NETNAME_DELETED" },
    { ERROR_NETWORK_ACCESS_DENIED, "ERROR_NETWORK_ACCESS_DENIED" },
    { ERROR_BAD_DEV_TYPE,  "ERROR_BAD_DEV_TYPE" },
    { ERROR_BAD_NET_NAME,  "ERROR_BAD_NET_NAME" },
    { ERROR_TOO_MANY_NAMES,    "ERROR_TOO_MANY_NAMES" },
    { ERROR_TOO_MANY_SESS, "ERROR_TOO_MANY_SESS" },
    { ERROR_SHARING_PAUSED,    "ERROR_SHARING_PAUSED" },
    { ERROR_REQ_NOT_ACCEP, "ERROR_REQ_NOT_ACCEP" },
    { ERROR_REDIR_PAUSED,  "ERROR_REDIR_PAUSED" },
    { ERROR_FILE_EXISTS,   "ERROR_FILE_EXISTS" },
    { ERROR_CANNOT_MAKE,   "ERROR_CANNOT_MAKE" },
    { ERROR_FAIL_I24,  "ERROR_FAIL_I24" },
    { ERROR_OUT_OF_STRUCTURES, "ERROR_OUT_OF_STRUCTURES" },
    { ERROR_ALREADY_ASSIGNED,  "ERROR_ALREADY_ASSIGNED" },
    { ERROR_INVALID_PASSWORD,  "ERROR_INVALID_PASSWORD" },
    { ERROR_INVALID_PARAMETER, "ERROR_INVALID_PARAMETER" },
    { ERROR_NET_WRITE_FAULT,   "ERROR_NET_WRITE_FAULT" },
    { ERROR_NO_PROC_SLOTS, "ERROR_NO_PROC_SLOTS" },
    { ERROR_TOO_MANY_SEMAPHORES,   "ERROR_TOO_MANY_SEMAPHORES" },
    { ERROR_EXCL_SEM_ALREADY_OWNED,    "ERROR_EXCL_SEM_ALREADY_OWNED" },
    { ERROR_SEM_IS_SET,    "ERROR_SEM_IS_SET" },
    { ERROR_TOO_MANY_SEM_REQUESTS, "ERROR_TOO_MANY_SEM_REQUESTS" },
    { ERROR_INVALID_AT_INTERRUPT_TIME, "ERROR_INVALID_AT_INTERRUPT_TIME" },
    { ERROR_SEM_OWNER_DIED,    "ERROR_SEM_OWNER_DIED" },
    { ERROR_SEM_USER_LIMIT,    "ERROR_SEM_USER_LIMIT" },
    { ERROR_DISK_CHANGE,   "ERROR_DISK_CHANGE" },
    { ERROR_DRIVE_LOCKED,  "ERROR_DRIVE_LOCKED" },
    { ERROR_BROKEN_PIPE,   "ERROR_BROKEN_PIPE" },
    { ERROR_OPEN_FAILED,   "ERROR_OPEN_FAILED" },
    { ERROR_BUFFER_OVERFLOW,   "ERROR_BUFFER_OVERFLOW" },
    { ERROR_DISK_FULL, "ERROR_DISK_FULL" },
    { ERROR_NO_MORE_SEARCH_HANDLES,    "ERROR_NO_MORE_SEARCH_HANDLES" },
    { ERROR_INVALID_TARGET_HANDLE, "ERROR_INVALID_TARGET_HANDLE" },
    { ERROR_INVALID_CATEGORY,  "ERROR_INVALID_CATEGORY" },
    { ERROR_INVALID_VERIFY_SWITCH, "ERROR_INVALID_VERIFY_SWITCH" },
    { ERROR_BAD_DRIVER_LEVEL,  "ERROR_BAD_DRIVER_LEVEL" },
    { ERROR_CALL_NOT_IMPLEMENTED,  "ERROR_CALL_NOT_IMPLEMENTED" },
    { ERROR_SEM_TIMEOUT,   "ERROR_SEM_TIMEOUT" },
    { ERROR_INSUFFICIENT_BUFFER,   "ERROR_INSUFFICIENT_BUFFER" },
    { ERROR_INVALID_NAME,  "ERROR_INVALID_NAME" },
    { ERROR_INVALID_LEVEL, "ERROR_INVALID_LEVEL" },
    { ERROR_NO_VOLUME_LABEL,   "ERROR_NO_VOLUME_LABEL" },
    { ERROR_MOD_NOT_FOUND, "ERROR_MOD_NOT_FOUND" },
    { ERROR_PROC_NOT_FOUND,    "ERROR_PROC_NOT_FOUND" },
    { ERROR_WAIT_NO_CHILDREN,  "ERROR_WAIT_NO_CHILDREN" },
    { ERROR_CHILD_NOT_COMPLETE,    "ERROR_CHILD_NOT_COMPLETE" },
    { ERROR_DIRECT_ACCESS_HANDLE,  "ERROR_DIRECT_ACCESS_HANDLE" },
    { ERROR_NEGATIVE_SEEK, "ERROR_NEGATIVE_SEEK" },
    { ERROR_SEEK_ON_DEVICE,    "ERROR_SEEK_ON_DEVICE" },
    { ERROR_IS_JOIN_TARGET,    "ERROR_IS_JOIN_TARGET" },
    { ERROR_IS_JOINED, "ERROR_IS_JOINED" },
    { ERROR_IS_SUBSTED,    "ERROR_IS_SUBSTED" },
    { ERROR_NOT_JOINED,    "ERROR_NOT_JOINED" },
    { ERROR_NOT_SUBSTED,   "ERROR_NOT_SUBSTED" },
    { ERROR_JOIN_TO_JOIN,  "ERROR_JOIN_TO_JOIN" },
    { ERROR_SUBST_TO_SUBST,    "ERROR_SUBST_TO_SUBST" },
    { ERROR_JOIN_TO_SUBST, "ERROR_JOIN_TO_SUBST" },
    { ERROR_SUBST_TO_JOIN, "ERROR_SUBST_TO_JOIN" },
    { ERROR_BUSY_DRIVE,    "ERROR_BUSY_DRIVE" },
    { ERROR_SAME_DRIVE,    "ERROR_SAME_DRIVE" },
    { ERROR_DIR_NOT_ROOT,  "ERROR_DIR_NOT_ROOT" },
    { ERROR_DIR_NOT_EMPTY, "ERROR_DIR_NOT_EMPTY" },
    { ERROR_IS_SUBST_PATH, "ERROR_IS_SUBST_PATH" },
    { ERROR_IS_JOIN_PATH,  "ERROR_IS_JOIN_PATH" },
    { ERROR_PATH_BUSY, "ERROR_PATH_BUSY" },
    { ERROR_IS_SUBST_TARGET,   "ERROR_IS_SUBST_TARGET" },
    { ERROR_SYSTEM_TRACE,  "ERROR_SYSTEM_TRACE" },
    { ERROR_INVALID_EVENT_COUNT,   "ERROR_INVALID_EVENT_COUNT" },
    { ERROR_TOO_MANY_MUXWAITERS,   "ERROR_TOO_MANY_MUXWAITERS" },
    { ERROR_INVALID_LIST_FORMAT,   "ERROR_INVALID_LIST_FORMAT" },
    { ERROR_LABEL_TOO_LONG,    "ERROR_LABEL_TOO_LONG" },
    { ERROR_TOO_MANY_TCBS, "ERROR_TOO_MANY_TCBS" },
    { ERROR_SIGNAL_REFUSED,    "ERROR_SIGNAL_REFUSED" },
    { ERROR_DISCARDED, "ERROR_DISCARDED" },
    { ERROR_NOT_LOCKED,    "ERROR_NOT_LOCKED" },
    { ERROR_BAD_THREADID_ADDR, "ERROR_BAD_THREADID_ADDR" },
    { ERROR_BAD_ARGUMENTS, "ERROR_BAD_ARGUMENTS" },
    { ERROR_BAD_PATHNAME,  "ERROR_BAD_PATHNAME" },
    { ERROR_SIGNAL_PENDING,    "ERROR_SIGNAL_PENDING" },
    { ERROR_MAX_THRDS_REACHED, "ERROR_MAX_THRDS_REACHED" },
    { ERROR_LOCK_FAILED,   "ERROR_LOCK_FAILED" },
    { ERROR_BUSY,  "ERROR_BUSY" },
    { ERROR_CANCEL_VIOLATION,  "ERROR_CANCEL_VIOLATION" },
    { ERROR_ATOMIC_LOCKS_NOT_SUPPORTED,    "ERROR_ATOMIC_LOCKS_NOT_SUPPORTED" },
    { ERROR_INVALID_SEGMENT_NUMBER,    "ERROR_INVALID_SEGMENT_NUMBER" },
    { ERROR_INVALID_ORDINAL,   "ERROR_INVALID_ORDINAL" },
    { ERROR_ALREADY_EXISTS,    "ERROR_ALREADY_EXISTS" },
    { ERROR_INVALID_FLAG_NUMBER,   "ERROR_INVALID_FLAG_NUMBER" },
    { ERROR_SEM_NOT_FOUND, "ERROR_SEM_NOT_FOUND" },
    { ERROR_INVALID_STARTING_CODESEG,  "ERROR_INVALID_STARTING_CODESEG" },
    { ERROR_INVALID_STACKSEG,  "ERROR_INVALID_STACKSEG" },
    { ERROR_INVALID_MODULETYPE,    "ERROR_INVALID_MODULETYPE" },
    { ERROR_INVALID_EXE_SIGNATURE, "ERROR_INVALID_EXE_SIGNATURE" },
    { ERROR_EXE_MARKED_INVALID,    "ERROR_EXE_MARKED_INVALID" },
    { ERROR_BAD_EXE_FORMAT,    "ERROR_BAD_EXE_FORMAT" },
    { ERROR_ITERATED_DATA_EXCEEDS_64k, "ERROR_ITERATED_DATA_EXCEEDS_64k" },
    { ERROR_INVALID_MINALLOCSIZE,  "ERROR_INVALID_MINALLOCSIZE" },
    { ERROR_DYNLINK_FROM_INVALID_RING, "ERROR_DYNLINK_FROM_INVALID_RING" },
    { ERROR_IOPL_NOT_ENABLED,  "ERROR_IOPL_NOT_ENABLED" },
    { ERROR_INVALID_SEGDPL,    "ERROR_INVALID_SEGDPL" },
    { ERROR_AUTODATASEG_EXCEEDS_64k,   "ERROR_AUTODATASEG_EXCEEDS_64k" },
    { ERROR_RING2SEG_MUST_BE_MOVABLE,  "ERROR_RING2SEG_MUST_BE_MOVABLE" },
    { ERROR_RELOC_CHAIN_XEEDS_SEGLIM,  "ERROR_RELOC_CHAIN_XEEDS_SEGLIM" },
    { ERROR_INFLOOP_IN_RELOC_CHAIN,    "ERROR_INFLOOP_IN_RELOC_CHAIN" },
    { ERROR_ENVVAR_NOT_FOUND,  "ERROR_ENVVAR_NOT_FOUND" },
    { ERROR_NO_SIGNAL_SENT,    "ERROR_NO_SIGNAL_SENT" },
    { ERROR_FILENAME_EXCED_RANGE,  "ERROR_FILENAME_EXCED_RANGE" },
    { ERROR_RING2_STACK_IN_USE,    "ERROR_RING2_STACK_IN_USE" },
    { ERROR_META_EXPANSION_TOO_LONG,   "ERROR_META_EXPANSION_TOO_LONG" },
    { ERROR_INVALID_SIGNAL_NUMBER, "ERROR_INVALID_SIGNAL_NUMBER" },
    { ERROR_THREAD_1_INACTIVE, "ERROR_THREAD_1_INACTIVE" },
    { ERROR_LOCKED,    "ERROR_LOCKED" },
    { ERROR_TOO_MANY_MODULES,  "ERROR_TOO_MANY_MODULES" },
    { ERROR_NESTING_NOT_ALLOWED,   "ERROR_NESTING_NOT_ALLOWED" },
#ifdef ERROR_EXE_MACHINE_TYPE_MISMATCH
    { ERROR_EXE_MACHINE_TYPE_MISMATCH, "ERROR_EXE_MACHINE_TYPE_MISMATCH" },
#endif
    { ERROR_BAD_PIPE,  "ERROR_BAD_PIPE" },
    { ERROR_PIPE_BUSY, "ERROR_PIPE_BUSY" },
    { ERROR_NO_DATA,   "ERROR_NO_DATA" },
    { ERROR_PIPE_NOT_CONNECTED,    "ERROR_PIPE_NOT_CONNECTED" },
    { ERROR_MORE_DATA, "ERROR_MORE_DATA" },
    { ERROR_VC_DISCONNECTED,   "ERROR_VC_DISCONNECTED" },
    { ERROR_INVALID_EA_NAME,   "ERROR_INVALID_EA_NAME" },
    { ERROR_EA_LIST_INCONSISTENT,  "ERROR_EA_LIST_INCONSISTENT" },
    { ERROR_NO_MORE_ITEMS, "ERROR_NO_MORE_ITEMS" },
    { ERROR_CANNOT_COPY,   "ERROR_CANNOT_COPY" },
    { ERROR_DIRECTORY, "ERROR_DIRECTORY" },
    { ERROR_EAS_DIDNT_FIT, "ERROR_EAS_DIDNT_FIT" },
    { ERROR_EA_FILE_CORRUPT,   "ERROR_EA_FILE_CORRUPT" },
    { ERROR_EA_TABLE_FULL, "ERROR_EA_TABLE_FULL" },
    { ERROR_INVALID_EA_HANDLE, "ERROR_INVALID_EA_HANDLE" },
    { ERROR_EAS_NOT_SUPPORTED, "ERROR_EAS_NOT_SUPPORTED" },
    { ERROR_NOT_OWNER, "ERROR_NOT_OWNER" },
    { ERROR_TOO_MANY_POSTS,    "ERROR_TOO_MANY_POSTS" },
    { ERROR_PARTIAL_COPY,  "ERROR_PARTIAL_COPY" },
    { ERROR_MR_MID_NOT_FOUND,  "ERROR_MR_MID_NOT_FOUND" },
    { ERROR_INVALID_ADDRESS,   "ERROR_INVALID_ADDRESS" },
    { ERROR_ARITHMETIC_OVERFLOW,   "ERROR_ARITHMETIC_OVERFLOW" },
    { ERROR_PIPE_CONNECTED,    "ERROR_PIPE_CONNECTED" },
    { ERROR_PIPE_LISTENING,    "ERROR_PIPE_LISTENING" },
    { ERROR_EA_ACCESS_DENIED,  "ERROR_EA_ACCESS_DENIED" },
    { ERROR_OPERATION_ABORTED, "ERROR_OPERATION_ABORTED" },
    { ERROR_IO_INCOMPLETE, "ERROR_IO_INCOMPLETE" },
    { ERROR_IO_PENDING,    "ERROR_IO_PENDING" },
    { ERROR_NOACCESS,  "ERROR_NOACCESS" },
    { ERROR_SWAPERROR, "ERROR_SWAPERROR" },
    { ERROR_STACK_OVERFLOW,    "ERROR_STACK_OVERFLOW" },
    { ERROR_INVALID_MESSAGE,   "ERROR_INVALID_MESSAGE" },
    { ERROR_CAN_NOT_COMPLETE,  "ERROR_CAN_NOT_COMPLETE" },
    { ERROR_INVALID_FLAGS, "ERROR_INVALID_FLAGS" },
    { ERROR_UNRECOGNIZED_VOLUME,   "ERROR_UNRECOGNIZED_VOLUME" },
    { ERROR_FILE_INVALID,  "ERROR_FILE_INVALID" },
    { ERROR_FULLSCREEN_MODE,   "ERROR_FULLSCREEN_MODE" },
    { ERROR_NO_TOKEN,  "ERROR_NO_TOKEN" },
    { ERROR_BADDB, "ERROR_BADDB" },
    { ERROR_BADKEY,    "ERROR_BADKEY" },
    { ERROR_CANTOPEN,  "ERROR_CANTOPEN" },
    { ERROR_CANTREAD,  "ERROR_CANTREAD" },
    { ERROR_CANTWRITE, "ERROR_CANTWRITE" },
    { ERROR_REGISTRY_RECOVERED,    "ERROR_REGISTRY_RECOVERED" },
    { ERROR_REGISTRY_CORRUPT,  "ERROR_REGISTRY_CORRUPT" },
    { ERROR_REGISTRY_IO_FAILED,    "ERROR_REGISTRY_IO_FAILED" },
    { ERROR_NOT_REGISTRY_FILE, "ERROR_NOT_REGISTRY_FILE" },
    { ERROR_KEY_DELETED,   "ERROR_KEY_DELETED" },
    { ERROR_NO_LOG_SPACE,  "ERROR_NO_LOG_SPACE" },
    { ERROR_KEY_HAS_CHILDREN,  "ERROR_KEY_HAS_CHILDREN" },
    { ERROR_CHILD_MUST_BE_VOLATILE,    "ERROR_CHILD_MUST_BE_VOLATILE" },
    { ERROR_NOTIFY_ENUM_DIR,   "ERROR_NOTIFY_ENUM_DIR" },
    { ERROR_DEPENDENT_SERVICES_RUNNING,    "ERROR_DEPENDENT_SERVICES_RUNNING" },
    { ERROR_INVALID_SERVICE_CONTROL,   "ERROR_INVALID_SERVICE_CONTROL" },
    { ERROR_SERVICE_REQUEST_TIMEOUT,   "ERROR_SERVICE_REQUEST_TIMEOUT" },
    { ERROR_SERVICE_NO_THREAD, "ERROR_SERVICE_NO_THREAD" },
    { ERROR_SERVICE_DATABASE_LOCKED,   "ERROR_SERVICE_DATABASE_LOCKED" },
    { ERROR_SERVICE_ALREADY_RUNNING,   "ERROR_SERVICE_ALREADY_RUNNING" },
    { ERROR_INVALID_SERVICE_ACCOUNT,   "ERROR_INVALID_SERVICE_ACCOUNT" },
    { ERROR_SERVICE_DISABLED,  "ERROR_SERVICE_DISABLED" },
    { ERROR_CIRCULAR_DEPENDENCY,   "ERROR_CIRCULAR_DEPENDENCY" },
    { ERROR_SERVICE_DOES_NOT_EXIST,    "ERROR_SERVICE_DOES_NOT_EXIST" },
    { ERROR_SERVICE_CANNOT_ACCEPT_CTRL,    "ERROR_SERVICE_CANNOT_ACCEPT_CTRL" },
    { ERROR_SERVICE_NOT_ACTIVE,    "ERROR_SERVICE_NOT_ACTIVE" },
    { ERROR_FAILED_SERVICE_CONTROLLER_CONNECT, "ERROR_FAILED_SERVICE_CONTROLLER_CONNECT" },
    { ERROR_EXCEPTION_IN_SERVICE,  "ERROR_EXCEPTION_IN_SERVICE" },
    { ERROR_DATABASE_DOES_NOT_EXIST,   "ERROR_DATABASE_DOES_NOT_EXIST" },
    { ERROR_SERVICE_SPECIFIC_ERROR,    "ERROR_SERVICE_SPECIFIC_ERROR" },
    { ERROR_PROCESS_ABORTED,   "ERROR_PROCESS_ABORTED" },
    { ERROR_SERVICE_DEPENDENCY_FAIL,   "ERROR_SERVICE_DEPENDENCY_FAIL" },
    { ERROR_SERVICE_LOGON_FAILED,  "ERROR_SERVICE_LOGON_FAILED" },
    { ERROR_SERVICE_START_HANG,    "ERROR_SERVICE_START_HANG" },
    { ERROR_INVALID_SERVICE_LOCK,  "ERROR_INVALID_SERVICE_LOCK" },
    { ERROR_SERVICE_MARKED_FOR_DELETE, "ERROR_SERVICE_MARKED_FOR_DELETE" },
    { ERROR_SERVICE_EXISTS,    "ERROR_SERVICE_EXISTS" },
    { ERROR_ALREADY_RUNNING_LKG,   "ERROR_ALREADY_RUNNING_LKG" },
    { ERROR_SERVICE_DEPENDENCY_DELETED,    "ERROR_SERVICE_DEPENDENCY_DELETED" },
    { ERROR_BOOT_ALREADY_ACCEPTED, "ERROR_BOOT_ALREADY_ACCEPTED" },
    { ERROR_SERVICE_NEVER_STARTED, "ERROR_SERVICE_NEVER_STARTED" },
    { ERROR_DUPLICATE_SERVICE_NAME,    "ERROR_DUPLICATE_SERVICE_NAME" },
#ifdef ERROR_DIFFERENT_SERVICE_ACCOUNT
    { ERROR_DIFFERENT_SERVICE_ACCOUNT, "ERROR_DIFFERENT_SERVICE_ACCOUNT" },
#endif
    { ERROR_END_OF_MEDIA,  "ERROR_END_OF_MEDIA" },
    { ERROR_FILEMARK_DETECTED, "ERROR_FILEMARK_DETECTED" },
    { ERROR_BEGINNING_OF_MEDIA,    "ERROR_BEGINNING_OF_MEDIA" },
    { ERROR_SETMARK_DETECTED,  "ERROR_SETMARK_DETECTED" },
    { ERROR_NO_DATA_DETECTED,  "ERROR_NO_DATA_DETECTED" },
    { ERROR_PARTITION_FAILURE, "ERROR_PARTITION_FAILURE" },
    { ERROR_INVALID_BLOCK_LENGTH,  "ERROR_INVALID_BLOCK_LENGTH" },
    { ERROR_DEVICE_NOT_PARTITIONED,    "ERROR_DEVICE_NOT_PARTITIONED" },
    { ERROR_UNABLE_TO_LOCK_MEDIA,  "ERROR_UNABLE_TO_LOCK_MEDIA" },
    { ERROR_UNABLE_TO_UNLOAD_MEDIA,    "ERROR_UNABLE_TO_UNLOAD_MEDIA" },
    { ERROR_MEDIA_CHANGED, "ERROR_MEDIA_CHANGED" },
    { ERROR_BUS_RESET, "ERROR_BUS_RESET" },
    { ERROR_NO_MEDIA_IN_DRIVE, "ERROR_NO_MEDIA_IN_DRIVE" },
    { ERROR_NO_UNICODE_TRANSLATION,    "ERROR_NO_UNICODE_TRANSLATION" },
    { ERROR_DLL_INIT_FAILED,   "ERROR_DLL_INIT_FAILED" },
    { ERROR_SHUTDOWN_IN_PROGRESS,  "ERROR_SHUTDOWN_IN_PROGRESS" },
    { ERROR_NO_SHUTDOWN_IN_PROGRESS,   "ERROR_NO_SHUTDOWN_IN_PROGRESS" },
    { ERROR_IO_DEVICE, "ERROR_IO_DEVICE" },
    { ERROR_SERIAL_NO_DEVICE,  "ERROR_SERIAL_NO_DEVICE" },
    { ERROR_IRQ_BUSY,  "ERROR_IRQ_BUSY" },
    { ERROR_MORE_WRITES,   "ERROR_MORE_WRITES" },
    { ERROR_COUNTER_TIMEOUT,   "ERROR_COUNTER_TIMEOUT" },
    { ERROR_FLOPPY_ID_MARK_NOT_FOUND,  "ERROR_FLOPPY_ID_MARK_NOT_FOUND" },
    { ERROR_FLOPPY_WRONG_CYLINDER, "ERROR_FLOPPY_WRONG_CYLINDER" },
    { ERROR_FLOPPY_UNKNOWN_ERROR,  "ERROR_FLOPPY_UNKNOWN_ERROR" },
    { ERROR_FLOPPY_BAD_REGISTERS,  "ERROR_FLOPPY_BAD_REGISTERS" },
    { ERROR_DISK_RECALIBRATE_FAILED,   "ERROR_DISK_RECALIBRATE_FAILED" },
    { ERROR_DISK_OPERATION_FAILED, "ERROR_DISK_OPERATION_FAILED" },
    { ERROR_DISK_RESET_FAILED, "ERROR_DISK_RESET_FAILED" },
    { ERROR_EOM_OVERFLOW,  "ERROR_EOM_OVERFLOW" },
    { ERROR_NOT_ENOUGH_SERVER_MEMORY,  "ERROR_NOT_ENOUGH_SERVER_MEMORY" },
    { ERROR_POSSIBLE_DEADLOCK, "ERROR_POSSIBLE_DEADLOCK" },
    { ERROR_MAPPED_ALIGNMENT,  "ERROR_MAPPED_ALIGNMENT" },
    { ERROR_SET_POWER_STATE_VETOED,    "ERROR_SET_POWER_STATE_VETOED" },
    { ERROR_SET_POWER_STATE_FAILED,    "ERROR_SET_POWER_STATE_FAILED" },
#ifdef ERROR_TOO_MANY_LINKS
    { ERROR_TOO_MANY_LINKS,    "ERROR_TOO_MANY_LINKS" },
#endif
    { ERROR_OLD_WIN_VERSION,   "ERROR_OLD_WIN_VERSION" },
    { ERROR_APP_WRONG_OS,  "ERROR_APP_WRONG_OS" },
    { ERROR_SINGLE_INSTANCE_APP,   "ERROR_SINGLE_INSTANCE_APP" },
    { ERROR_RMODE_APP, "ERROR_RMODE_APP" },
    { ERROR_INVALID_DLL,   "ERROR_INVALID_DLL" },
    { ERROR_NO_ASSOCIATION,    "ERROR_NO_ASSOCIATION" },
    { ERROR_DDE_FAIL,  "ERROR_DDE_FAIL" },
    { ERROR_DLL_NOT_FOUND, "ERROR_DLL_NOT_FOUND" },
    { ERROR_BAD_USERNAME,  "ERROR_BAD_USERNAME" },
    { ERROR_NOT_CONNECTED, "ERROR_NOT_CONNECTED" },
    { ERROR_OPEN_FILES,    "ERROR_OPEN_FILES" },
    { ERROR_ACTIVE_CONNECTIONS,    "ERROR_ACTIVE_CONNECTIONS" },
    { ERROR_DEVICE_IN_USE, "ERROR_DEVICE_IN_USE" },
    { ERROR_BAD_DEVICE,    "ERROR_BAD_DEVICE" },
    { ERROR_CONNECTION_UNAVAIL,    "ERROR_CONNECTION_UNAVAIL" },
    { ERROR_DEVICE_ALREADY_REMEMBERED, "ERROR_DEVICE_ALREADY_REMEMBERED" },
    { ERROR_NO_NET_OR_BAD_PATH,    "ERROR_NO_NET_OR_BAD_PATH" },
    { ERROR_BAD_PROVIDER,  "ERROR_BAD_PROVIDER" },
    { ERROR_CANNOT_OPEN_PROFILE,   "ERROR_CANNOT_OPEN_PROFILE" },
    { ERROR_BAD_PROFILE,   "ERROR_BAD_PROFILE" },
    { ERROR_NOT_CONTAINER, "ERROR_NOT_CONTAINER" },
    { ERROR_EXTENDED_ERROR,    "ERROR_EXTENDED_ERROR" },
    { ERROR_INVALID_GROUPNAME, "ERROR_INVALID_GROUPNAME" },
    { ERROR_INVALID_COMPUTERNAME,  "ERROR_INVALID_COMPUTERNAME" },
    { ERROR_INVALID_EVENTNAME, "ERROR_INVALID_EVENTNAME" },
    { ERROR_INVALID_DOMAINNAME,    "ERROR_INVALID_DOMAINNAME" },
    { ERROR_INVALID_SERVICENAME,   "ERROR_INVALID_SERVICENAME" },
    { ERROR_INVALID_NETNAME,   "ERROR_INVALID_NETNAME" },
    { ERROR_INVALID_SHARENAME, "ERROR_INVALID_SHARENAME" },
    { ERROR_INVALID_PASSWORDNAME,  "ERROR_INVALID_PASSWORDNAME" },
    { ERROR_INVALID_MESSAGENAME,   "ERROR_INVALID_MESSAGENAME" },
    { ERROR_INVALID_MESSAGEDEST,   "ERROR_INVALID_MESSAGEDEST" },
    { ERROR_SESSION_CREDENTIAL_CONFLICT,   "ERROR_SESSION_CREDENTIAL_CONFLICT" },
    { ERROR_REMOTE_SESSION_LIMIT_EXCEEDED, "ERROR_REMOTE_SESSION_LIMIT_EXCEEDED" },
    { ERROR_DUP_DOMAINNAME,    "ERROR_DUP_DOMAINNAME" },
    { ERROR_NO_NETWORK,    "ERROR_NO_NETWORK" },
    { ERROR_CANCELLED, "ERROR_CANCELLED" },
    { ERROR_USER_MAPPED_FILE,  "ERROR_USER_MAPPED_FILE" },
    { ERROR_CONNECTION_REFUSED,    "ERROR_CONNECTION_REFUSED" },
    { ERROR_GRACEFUL_DISCONNECT,   "ERROR_GRACEFUL_DISCONNECT" },
    { ERROR_ADDRESS_ALREADY_ASSOCIATED,    "ERROR_ADDRESS_ALREADY_ASSOCIATED" },
    { ERROR_ADDRESS_NOT_ASSOCIATED,    "ERROR_ADDRESS_NOT_ASSOCIATED" },
    { ERROR_CONNECTION_INVALID,    "ERROR_CONNECTION_INVALID" },
    { ERROR_CONNECTION_ACTIVE, "ERROR_CONNECTION_ACTIVE" },
    { ERROR_NETWORK_UNREACHABLE,   "ERROR_NETWORK_UNREACHABLE" },
    { ERROR_HOST_UNREACHABLE,  "ERROR_HOST_UNREACHABLE" },
    { ERROR_PROTOCOL_UNREACHABLE,  "ERROR_PROTOCOL_UNREACHABLE" },
    { ERROR_PORT_UNREACHABLE,  "ERROR_PORT_UNREACHABLE" },
    { ERROR_REQUEST_ABORTED,   "ERROR_REQUEST_ABORTED" },
    { ERROR_CONNECTION_ABORTED,    "ERROR_CONNECTION_ABORTED" },
    { ERROR_RETRY, "ERROR_RETRY" },
    { ERROR_CONNECTION_COUNT_LIMIT,    "ERROR_CONNECTION_COUNT_LIMIT" },
    { ERROR_LOGIN_TIME_RESTRICTION,    "ERROR_LOGIN_TIME_RESTRICTION" },
    { ERROR_LOGIN_WKSTA_RESTRICTION,   "ERROR_LOGIN_WKSTA_RESTRICTION" },
    { ERROR_INCORRECT_ADDRESS, "ERROR_INCORRECT_ADDRESS" },
    { ERROR_ALREADY_REGISTERED,    "ERROR_ALREADY_REGISTERED" },
    { ERROR_SERVICE_NOT_FOUND, "ERROR_SERVICE_NOT_FOUND" },
    { ERROR_NOT_AUTHENTICATED, "ERROR_NOT_AUTHENTICATED" },
    { ERROR_NOT_LOGGED_ON, "ERROR_NOT_LOGGED_ON" },
    { ERROR_CONTINUE,  "ERROR_CONTINUE" },
    { ERROR_ALREADY_INITIALIZED,   "ERROR_ALREADY_INITIALIZED" },
    { ERROR_NO_MORE_DEVICES,   "ERROR_NO_MORE_DEVICES" },
    { ERROR_NOT_ALL_ASSIGNED,  "ERROR_NOT_ALL_ASSIGNED" },
    { ERROR_SOME_NOT_MAPPED,   "ERROR_SOME_NOT_MAPPED" },
    { ERROR_NO_QUOTAS_FOR_ACCOUNT, "ERROR_NO_QUOTAS_FOR_ACCOUNT" },
    { ERROR_LOCAL_USER_SESSION_KEY,    "ERROR_LOCAL_USER_SESSION_KEY" },
    { ERROR_NULL_LM_PASSWORD,  "ERROR_NULL_LM_PASSWORD" },
    { ERROR_UNKNOWN_REVISION,  "ERROR_UNKNOWN_REVISION" },
    { ERROR_REVISION_MISMATCH, "ERROR_REVISION_MISMATCH" },
    { ERROR_INVALID_OWNER, "ERROR_INVALID_OWNER" },
    { ERROR_INVALID_PRIMARY_GROUP, "ERROR_INVALID_PRIMARY_GROUP" },
    { ERROR_NO_IMPERSONATION_TOKEN,    "ERROR_NO_IMPERSONATION_TOKEN" },
    { ERROR_CANT_DISABLE_MANDATORY,    "ERROR_CANT_DISABLE_MANDATORY" },
    { ERROR_NO_LOGON_SERVERS,  "ERROR_NO_LOGON_SERVERS" },
    { ERROR_NO_SUCH_LOGON_SESSION, "ERROR_NO_SUCH_LOGON_SESSION" },
    { ERROR_NO_SUCH_PRIVILEGE, "ERROR_NO_SUCH_PRIVILEGE" },
    { ERROR_PRIVILEGE_NOT_HELD,    "ERROR_PRIVILEGE_NOT_HELD" },
    { ERROR_INVALID_ACCOUNT_NAME,  "ERROR_INVALID_ACCOUNT_NAME" },
    { ERROR_USER_EXISTS,   "ERROR_USER_EXISTS" },
    { ERROR_NO_SUCH_USER,  "ERROR_NO_SUCH_USER" },
    { ERROR_GROUP_EXISTS,  "ERROR_GROUP_EXISTS" },
    { ERROR_NO_SUCH_GROUP, "ERROR_NO_SUCH_GROUP" },
    { ERROR_MEMBER_IN_GROUP,   "ERROR_MEMBER_IN_GROUP" },
    { ERROR_MEMBER_NOT_IN_GROUP,   "ERROR_MEMBER_NOT_IN_GROUP" },
    { ERROR_LAST_ADMIN,    "ERROR_LAST_ADMIN" },
    { ERROR_WRONG_PASSWORD,    "ERROR_WRONG_PASSWORD" },
    { ERROR_ILL_FORMED_PASSWORD,   "ERROR_ILL_FORMED_PASSWORD" },
    { ERROR_PASSWORD_RESTRICTION,  "ERROR_PASSWORD_RESTRICTION" },
    { ERROR_LOGON_FAILURE, "ERROR_LOGON_FAILURE" },
    { ERROR_ACCOUNT_RESTRICTION,   "ERROR_ACCOUNT_RESTRICTION" },
    { ERROR_INVALID_LOGON_HOURS,   "ERROR_INVALID_LOGON_HOURS" },
    { ERROR_INVALID_WORKSTATION,   "ERROR_INVALID_WORKSTATION" },
    { ERROR_PASSWORD_EXPIRED,  "ERROR_PASSWORD_EXPIRED" },
    { ERROR_ACCOUNT_DISABLED,  "ERROR_ACCOUNT_DISABLED" },
    { ERROR_NONE_MAPPED,   "ERROR_NONE_MAPPED" },
    { ERROR_TOO_MANY_LUIDS_REQUESTED,  "ERROR_TOO_MANY_LUIDS_REQUESTED" },
    { ERROR_LUIDS_EXHAUSTED,   "ERROR_LUIDS_EXHAUSTED" },
    { ERROR_INVALID_SUB_AUTHORITY, "ERROR_INVALID_SUB_AUTHORITY" },
    { ERROR_INVALID_ACL,   "ERROR_INVALID_ACL" },
    { ERROR_INVALID_SID,   "ERROR_INVALID_SID" },
    { ERROR_INVALID_SECURITY_DESCR,    "ERROR_INVALID_SECURITY_DESCR" },
    { ERROR_BAD_INHERITANCE_ACL,   "ERROR_BAD_INHERITANCE_ACL" },
    { ERROR_SERVER_DISABLED,   "ERROR_SERVER_DISABLED" },
    { ERROR_SERVER_NOT_DISABLED,   "ERROR_SERVER_NOT_DISABLED" },
    { ERROR_INVALID_ID_AUTHORITY,  "ERROR_INVALID_ID_AUTHORITY" },
    { ERROR_ALLOTTED_SPACE_EXCEEDED,   "ERROR_ALLOTTED_SPACE_EXCEEDED" },
    { ERROR_INVALID_GROUP_ATTRIBUTES,  "ERROR_INVALID_GROUP_ATTRIBUTES" },
    { ERROR_BAD_IMPERSONATION_LEVEL,   "ERROR_BAD_IMPERSONATION_LEVEL" },
    { ERROR_CANT_OPEN_ANONYMOUS,   "ERROR_CANT_OPEN_ANONYMOUS" },
    { ERROR_BAD_VALIDATION_CLASS,  "ERROR_BAD_VALIDATION_CLASS" },
    { ERROR_BAD_TOKEN_TYPE,    "ERROR_BAD_TOKEN_TYPE" },
    { ERROR_NO_SECURITY_ON_OBJECT, "ERROR_NO_SECURITY_ON_OBJECT" },
    { ERROR_CANT_ACCESS_DOMAIN_INFO,   "ERROR_CANT_ACCESS_DOMAIN_INFO" },
    { ERROR_INVALID_SERVER_STATE,  "ERROR_INVALID_SERVER_STATE" },
    { ERROR_INVALID_DOMAIN_STATE,  "ERROR_INVALID_DOMAIN_STATE" },
    { ERROR_INVALID_DOMAIN_ROLE,   "ERROR_INVALID_DOMAIN_ROLE" },
    { ERROR_NO_SUCH_DOMAIN,    "ERROR_NO_SUCH_DOMAIN" },
    { ERROR_DOMAIN_EXISTS, "ERROR_DOMAIN_EXISTS" },
    { ERROR_DOMAIN_LIMIT_EXCEEDED, "ERROR_DOMAIN_LIMIT_EXCEEDED" },
    { ERROR_INTERNAL_DB_CORRUPTION,    "ERROR_INTERNAL_DB_CORRUPTION" },
    { ERROR_INTERNAL_ERROR,    "ERROR_INTERNAL_ERROR" },
    { ERROR_GENERIC_NOT_MAPPED,    "ERROR_GENERIC_NOT_MAPPED" },
    { ERROR_BAD_DESCRIPTOR_FORMAT, "ERROR_BAD_DESCRIPTOR_FORMAT" },
    { ERROR_NOT_LOGON_PROCESS, "ERROR_NOT_LOGON_PROCESS" },
    { ERROR_LOGON_SESSION_EXISTS,  "ERROR_LOGON_SESSION_EXISTS" },
    { ERROR_NO_SUCH_PACKAGE,   "ERROR_NO_SUCH_PACKAGE" },
    { ERROR_BAD_LOGON_SESSION_STATE,   "ERROR_BAD_LOGON_SESSION_STATE" },
    { ERROR_LOGON_SESSION_COLLISION,   "ERROR_LOGON_SESSION_COLLISION" },
    { ERROR_INVALID_LOGON_TYPE,    "ERROR_INVALID_LOGON_TYPE" },
    { ERROR_CANNOT_IMPERSONATE,    "ERROR_CANNOT_IMPERSONATE" },
    { ERROR_RXACT_INVALID_STATE,   "ERROR_RXACT_INVALID_STATE" },
    { ERROR_RXACT_COMMIT_FAILURE,  "ERROR_RXACT_COMMIT_FAILURE" },
    { ERROR_SPECIAL_ACCOUNT,   "ERROR_SPECIAL_ACCOUNT" },
    { ERROR_SPECIAL_GROUP, "ERROR_SPECIAL_GROUP" },
    { ERROR_SPECIAL_USER,  "ERROR_SPECIAL_USER" },
    { ERROR_MEMBERS_PRIMARY_GROUP, "ERROR_MEMBERS_PRIMARY_GROUP" },
    { ERROR_TOKEN_ALREADY_IN_USE,  "ERROR_TOKEN_ALREADY_IN_USE" },
    { ERROR_NO_SUCH_ALIAS, "ERROR_NO_SUCH_ALIAS" },
    { ERROR_MEMBER_NOT_IN_ALIAS,   "ERROR_MEMBER_NOT_IN_ALIAS" },
    { ERROR_MEMBER_IN_ALIAS,   "ERROR_MEMBER_IN_ALIAS" },
    { ERROR_ALIAS_EXISTS,  "ERROR_ALIAS_EXISTS" },
    { ERROR_LOGON_NOT_GRANTED, "ERROR_LOGON_NOT_GRANTED" },
    { ERROR_TOO_MANY_SECRETS,  "ERROR_TOO_MANY_SECRETS" },
    { ERROR_SECRET_TOO_LONG,   "ERROR_SECRET_TOO_LONG" },
    { ERROR_INTERNAL_DB_ERROR, "ERROR_INTERNAL_DB_ERROR" },
    { ERROR_TOO_MANY_CONTEXT_IDS,  "ERROR_TOO_MANY_CONTEXT_IDS" },
    { ERROR_LOGON_TYPE_NOT_GRANTED,    "ERROR_LOGON_TYPE_NOT_GRANTED" },
    { ERROR_NT_CROSS_ENCRYPTION_REQUIRED,  "ERROR_NT_CROSS_ENCRYPTION_REQUIRED" },
    { ERROR_NO_SUCH_MEMBER,    "ERROR_NO_SUCH_MEMBER" },
    { ERROR_INVALID_MEMBER,    "ERROR_INVALID_MEMBER" },
    { ERROR_TOO_MANY_SIDS, "ERROR_TOO_MANY_SIDS" },
    { ERROR_LM_CROSS_ENCRYPTION_REQUIRED,  "ERROR_LM_CROSS_ENCRYPTION_REQUIRED" },
    { ERROR_NO_INHERITANCE,    "ERROR_NO_INHERITANCE" },
    { ERROR_FILE_CORRUPT,  "ERROR_FILE_CORRUPT" },
    { ERROR_DISK_CORRUPT,  "ERROR_DISK_CORRUPT" },
    { ERROR_NO_USER_SESSION_KEY,   "ERROR_NO_USER_SESSION_KEY" },
#ifdef ERROR_LICENSE_QUOTA_EXCEEDED
    { ERROR_LICENSE_QUOTA_EXCEEDED,    "ERROR_LICENSE_QUOTA_EXCEEDED" },
#endif
    { ERROR_INVALID_WINDOW_HANDLE, "ERROR_INVALID_WINDOW_HANDLE" },
    { ERROR_INVALID_MENU_HANDLE,   "ERROR_INVALID_MENU_HANDLE" },
    { ERROR_INVALID_CURSOR_HANDLE, "ERROR_INVALID_CURSOR_HANDLE" },
    { ERROR_INVALID_ACCEL_HANDLE,  "ERROR_INVALID_ACCEL_HANDLE" },
    { ERROR_INVALID_HOOK_HANDLE,   "ERROR_INVALID_HOOK_HANDLE" },
    { ERROR_INVALID_DWP_HANDLE,    "ERROR_INVALID_DWP_HANDLE" },
    { ERROR_TLW_WITH_WSCHILD,  "ERROR_TLW_WITH_WSCHILD" },
    { ERROR_CANNOT_FIND_WND_CLASS, "ERROR_CANNOT_FIND_WND_CLASS" },
    { ERROR_WINDOW_OF_OTHER_THREAD,    "ERROR_WINDOW_OF_OTHER_THREAD" },
    { ERROR_HOTKEY_ALREADY_REGISTERED, "ERROR_HOTKEY_ALREADY_REGISTERED" },
    { ERROR_CLASS_ALREADY_EXISTS,  "ERROR_CLASS_ALREADY_EXISTS" },
    { ERROR_CLASS_DOES_NOT_EXIST,  "ERROR_CLASS_DOES_NOT_EXIST" },
    { ERROR_CLASS_HAS_WINDOWS, "ERROR_CLASS_HAS_WINDOWS" },
    { ERROR_INVALID_INDEX, "ERROR_INVALID_INDEX" },
    { ERROR_INVALID_ICON_HANDLE,   "ERROR_INVALID_ICON_HANDLE" },
    { ERROR_PRIVATE_DIALOG_INDEX,  "ERROR_PRIVATE_DIALOG_INDEX" },
    { ERROR_LISTBOX_ID_NOT_FOUND,  "ERROR_LISTBOX_ID_NOT_FOUND" },
    { ERROR_NO_WILDCARD_CHARACTERS,    "ERROR_NO_WILDCARD_CHARACTERS" },
    { ERROR_CLIPBOARD_NOT_OPEN,    "ERROR_CLIPBOARD_NOT_OPEN" },
    { ERROR_HOTKEY_NOT_REGISTERED, "ERROR_HOTKEY_NOT_REGISTERED" },
    { ERROR_WINDOW_NOT_DIALOG, "ERROR_WINDOW_NOT_DIALOG" },
    { ERROR_CONTROL_ID_NOT_FOUND,  "ERROR_CONTROL_ID_NOT_FOUND" },
    { ERROR_INVALID_COMBOBOX_MESSAGE,  "ERROR_INVALID_COMBOBOX_MESSAGE" },
    { ERROR_WINDOW_NOT_COMBOBOX,   "ERROR_WINDOW_NOT_COMBOBOX" },
    { ERROR_INVALID_EDIT_HEIGHT,   "ERROR_INVALID_EDIT_HEIGHT" },
    { ERROR_DC_NOT_FOUND,  "ERROR_DC_NOT_FOUND" },
    { ERROR_INVALID_HOOK_FILTER,   "ERROR_INVALID_HOOK_FILTER" },
    { ERROR_INVALID_FILTER_PROC,   "ERROR_INVALID_FILTER_PROC" },
    { ERROR_HOOK_NEEDS_HMOD,   "ERROR_HOOK_NEEDS_HMOD" },
    { ERROR_GLOBAL_ONLY_HOOK,  "ERROR_GLOBAL_ONLY_HOOK" },
    { ERROR_JOURNAL_HOOK_SET,  "ERROR_JOURNAL_HOOK_SET" },
    { ERROR_HOOK_NOT_INSTALLED,    "ERROR_HOOK_NOT_INSTALLED" },
    { ERROR_INVALID_LB_MESSAGE,    "ERROR_INVALID_LB_MESSAGE" },
    { ERROR_SETCOUNT_ON_BAD_LB,    "ERROR_SETCOUNT_ON_BAD_LB" },
    { ERROR_LB_WITHOUT_TABSTOPS,   "ERROR_LB_WITHOUT_TABSTOPS" },
    { ERROR_DESTROY_OBJECT_OF_OTHER_THREAD,    "ERROR_DESTROY_OBJECT_OF_OTHER_THREAD" },
    { ERROR_CHILD_WINDOW_MENU, "ERROR_CHILD_WINDOW_MENU" },
    { ERROR_NO_SYSTEM_MENU,    "ERROR_NO_SYSTEM_MENU" },
    { ERROR_INVALID_MSGBOX_STYLE,  "ERROR_INVALID_MSGBOX_STYLE" },
    { ERROR_INVALID_SPI_VALUE, "ERROR_INVALID_SPI_VALUE" },
    { ERROR_SCREEN_ALREADY_LOCKED, "ERROR_SCREEN_ALREADY_LOCKED" },
    { ERROR_HWNDS_HAVE_DIFF_PARENT,    "ERROR_HWNDS_HAVE_DIFF_PARENT" },
    { ERROR_NOT_CHILD_WINDOW,  "ERROR_NOT_CHILD_WINDOW" },
    { ERROR_INVALID_GW_COMMAND,    "ERROR_INVALID_GW_COMMAND" },
    { ERROR_INVALID_THREAD_ID, "ERROR_INVALID_THREAD_ID" },
    { ERROR_NON_MDICHILD_WINDOW,   "ERROR_NON_MDICHILD_WINDOW" },
    { ERROR_POPUP_ALREADY_ACTIVE,  "ERROR_POPUP_ALREADY_ACTIVE" },
    { ERROR_NO_SCROLLBARS, "ERROR_NO_SCROLLBARS" },
    { ERROR_INVALID_SCROLLBAR_RANGE,   "ERROR_INVALID_SCROLLBAR_RANGE" },
    { ERROR_INVALID_SHOWWIN_COMMAND,   "ERROR_INVALID_SHOWWIN_COMMAND" },
#ifdef ERROR_NO_SYSTEM_RESOURCES
    { ERROR_NO_SYSTEM_RESOURCES,   "ERROR_NO_SYSTEM_RESOURCES" },
#endif
#ifdef ERROR_NONPAGED_SYSTEM_RESOURCES
    { ERROR_NONPAGED_SYSTEM_RESOURCES, "ERROR_NONPAGED_SYSTEM_RESOURCES" },
#endif
#ifdef ERROR_PAGED_SYSTEM_RESOURCES
    { ERROR_PAGED_SYSTEM_RESOURCES,    "ERROR_PAGED_SYSTEM_RESOURCES" },
#endif
#ifdef ERROR_WORKING_SET_QUOTA
    { ERROR_WORKING_SET_QUOTA, "ERROR_WORKING_SET_QUOTA" },
#endif
#ifdef ERROR_PAGEFILE_QUOTA
    { ERROR_PAGEFILE_QUOTA,    "ERROR_PAGEFILE_QUOTA" },
#endif
#ifdef ERROR_COMMITMENT_LIMIT
    { ERROR_COMMITMENT_LIMIT,  "ERROR_COMMITMENT_LIMIT" },
#endif
#ifdef ERROR_MENU_ITEM_NOT_FOUND
    { ERROR_MENU_ITEM_NOT_FOUND,   "ERROR_MENU_ITEM_NOT_FOUND" },
#endif
#ifdef ERROR_INVALID_KEYBOARD_HANDLE
    { ERROR_INVALID_KEYBOARD_HANDLE,   "ERROR_INVALID_KEYBOARD_HANDLE" },
#endif
#ifdef ERROR_HOOK_TYPE_NOT_ALLOWED
    { ERROR_HOOK_TYPE_NOT_ALLOWED, "ERROR_HOOK_TYPE_NOT_ALLOWED" },
#endif
#ifdef ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION
    { ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION,    "ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION" },
#endif
#ifdef ERROR_TIMEOUT
    { ERROR_TIMEOUT,   "ERROR_TIMEOUT" },
#endif
    { ERROR_EVENTLOG_FILE_CORRUPT, "ERROR_EVENTLOG_FILE_CORRUPT" },
    { ERROR_EVENTLOG_CANT_START,   "ERROR_EVENTLOG_CANT_START" },
    { ERROR_LOG_FILE_FULL, "ERROR_LOG_FILE_FULL" },
    { ERROR_EVENTLOG_FILE_CHANGED, "ERROR_EVENTLOG_FILE_CHANGED" },
    { RPC_S_INVALID_STRING_BINDING,    "RPC_S_INVALID_STRING_BINDING" },
    { RPC_S_WRONG_KIND_OF_BINDING, "RPC_S_WRONG_KIND_OF_BINDING" },
    { RPC_S_INVALID_BINDING,   "RPC_S_INVALID_BINDING" },
    { RPC_S_PROTSEQ_NOT_SUPPORTED, "RPC_S_PROTSEQ_NOT_SUPPORTED" },
    { RPC_S_INVALID_RPC_PROTSEQ,   "RPC_S_INVALID_RPC_PROTSEQ" },
    { RPC_S_INVALID_STRING_UUID,   "RPC_S_INVALID_STRING_UUID" },
    { RPC_S_INVALID_ENDPOINT_FORMAT,   "RPC_S_INVALID_ENDPOINT_FORMAT" },
    { RPC_S_INVALID_NET_ADDR,  "RPC_S_INVALID_NET_ADDR" },
    { RPC_S_NO_ENDPOINT_FOUND, "RPC_S_NO_ENDPOINT_FOUND" },
    { RPC_S_INVALID_TIMEOUT,   "RPC_S_INVALID_TIMEOUT" },
    { RPC_S_OBJECT_NOT_FOUND,  "RPC_S_OBJECT_NOT_FOUND" },
    { RPC_S_ALREADY_REGISTERED,    "RPC_S_ALREADY_REGISTERED" },
    { RPC_S_TYPE_ALREADY_REGISTERED,   "RPC_S_TYPE_ALREADY_REGISTERED" },
    { RPC_S_ALREADY_LISTENING, "RPC_S_ALREADY_LISTENING" },
    { RPC_S_NO_PROTSEQS_REGISTERED,    "RPC_S_NO_PROTSEQS_REGISTERED" },
    { RPC_S_NOT_LISTENING, "RPC_S_NOT_LISTENING" },
    { RPC_S_UNKNOWN_MGR_TYPE,  "RPC_S_UNKNOWN_MGR_TYPE" },
    { RPC_S_UNKNOWN_IF,    "RPC_S_UNKNOWN_IF" },
    { RPC_S_NO_BINDINGS,   "RPC_S_NO_BINDINGS" },
    { RPC_S_NO_PROTSEQS,   "RPC_S_NO_PROTSEQS" },
    { RPC_S_CANT_CREATE_ENDPOINT,  "RPC_S_CANT_CREATE_ENDPOINT" },
    { RPC_S_OUT_OF_RESOURCES,  "RPC_S_OUT_OF_RESOURCES" },
    { RPC_S_SERVER_UNAVAILABLE,    "RPC_S_SERVER_UNAVAILABLE" },
    { RPC_S_SERVER_TOO_BUSY,   "RPC_S_SERVER_TOO_BUSY" },
    { RPC_S_INVALID_NETWORK_OPTIONS,   "RPC_S_INVALID_NETWORK_OPTIONS" },
    { RPC_S_NO_CALL_ACTIVE,    "RPC_S_NO_CALL_ACTIVE" },
    { RPC_S_CALL_FAILED,   "RPC_S_CALL_FAILED" },
    { RPC_S_CALL_FAILED_DNE,   "RPC_S_CALL_FAILED_DNE" },
    { RPC_S_PROTOCOL_ERROR,    "RPC_S_PROTOCOL_ERROR" },
    { RPC_S_UNSUPPORTED_TRANS_SYN, "RPC_S_UNSUPPORTED_TRANS_SYN" },
    { RPC_S_UNSUPPORTED_TYPE,  "RPC_S_UNSUPPORTED_TYPE" },
    { RPC_S_INVALID_TAG,   "RPC_S_INVALID_TAG" },
    { RPC_S_INVALID_BOUND, "RPC_S_INVALID_BOUND" },
    { RPC_S_NO_ENTRY_NAME, "RPC_S_NO_ENTRY_NAME" },
    { RPC_S_INVALID_NAME_SYNTAX,   "RPC_S_INVALID_NAME_SYNTAX" },
    { RPC_S_UNSUPPORTED_NAME_SYNTAX,   "RPC_S_UNSUPPORTED_NAME_SYNTAX" },
    { RPC_S_UUID_NO_ADDRESS,   "RPC_S_UUID_NO_ADDRESS" },
    { RPC_S_DUPLICATE_ENDPOINT,    "RPC_S_DUPLICATE_ENDPOINT" },
    { RPC_S_UNKNOWN_AUTHN_TYPE,    "RPC_S_UNKNOWN_AUTHN_TYPE" },
    { RPC_S_MAX_CALLS_TOO_SMALL,   "RPC_S_MAX_CALLS_TOO_SMALL" },
    { RPC_S_STRING_TOO_LONG,   "RPC_S_STRING_TOO_LONG" },
    { RPC_S_PROTSEQ_NOT_FOUND, "RPC_S_PROTSEQ_NOT_FOUND" },
    { RPC_S_PROCNUM_OUT_OF_RANGE,  "RPC_S_PROCNUM_OUT_OF_RANGE" },
    { RPC_S_BINDING_HAS_NO_AUTH,   "RPC_S_BINDING_HAS_NO_AUTH" },
    { RPC_S_UNKNOWN_AUTHN_SERVICE, "RPC_S_UNKNOWN_AUTHN_SERVICE" },
    { RPC_S_UNKNOWN_AUTHN_LEVEL,   "RPC_S_UNKNOWN_AUTHN_LEVEL" },
    { RPC_S_INVALID_AUTH_IDENTITY, "RPC_S_INVALID_AUTH_IDENTITY" },
    { RPC_S_UNKNOWN_AUTHZ_SERVICE, "RPC_S_UNKNOWN_AUTHZ_SERVICE" },
    { EPT_S_INVALID_ENTRY, "EPT_S_INVALID_ENTRY" },
    { EPT_S_CANT_PERFORM_OP,   "EPT_S_CANT_PERFORM_OP" },
    { EPT_S_NOT_REGISTERED,    "EPT_S_NOT_REGISTERED" },
    { RPC_S_NOTHING_TO_EXPORT, "RPC_S_NOTHING_TO_EXPORT" },
    { RPC_S_INCOMPLETE_NAME,   "RPC_S_INCOMPLETE_NAME" },
    { RPC_S_INVALID_VERS_OPTION,   "RPC_S_INVALID_VERS_OPTION" },
    { RPC_S_NO_MORE_MEMBERS,   "RPC_S_NO_MORE_MEMBERS" },
    { RPC_S_NOT_ALL_OBJS_UNEXPORTED,   "RPC_S_NOT_ALL_OBJS_UNEXPORTED" },
    { RPC_S_INTERFACE_NOT_FOUND,   "RPC_S_INTERFACE_NOT_FOUND" },
    { RPC_S_ENTRY_ALREADY_EXISTS,  "RPC_S_ENTRY_ALREADY_EXISTS" },
    { RPC_S_ENTRY_NOT_FOUND,   "RPC_S_ENTRY_NOT_FOUND" },
    { RPC_S_NAME_SERVICE_UNAVAILABLE,  "RPC_S_NAME_SERVICE_UNAVAILABLE" },
    { RPC_S_INVALID_NAF_ID,    "RPC_S_INVALID_NAF_ID" },
    { RPC_S_CANNOT_SUPPORT,    "RPC_S_CANNOT_SUPPORT" },
    { RPC_S_NO_CONTEXT_AVAILABLE,  "RPC_S_NO_CONTEXT_AVAILABLE" },
    { RPC_S_INTERNAL_ERROR,    "RPC_S_INTERNAL_ERROR" },
    { RPC_S_ZERO_DIVIDE,   "RPC_S_ZERO_DIVIDE" },
    { RPC_S_ADDRESS_ERROR, "RPC_S_ADDRESS_ERROR" },
    { RPC_S_FP_DIV_ZERO,   "RPC_S_FP_DIV_ZERO" },
    { RPC_S_FP_UNDERFLOW,  "RPC_S_FP_UNDERFLOW" },
    { RPC_S_FP_OVERFLOW,   "RPC_S_FP_OVERFLOW" },
    { RPC_X_NO_MORE_ENTRIES,   "RPC_X_NO_MORE_ENTRIES" },
    { RPC_X_SS_CHAR_TRANS_OPEN_FAIL,   "RPC_X_SS_CHAR_TRANS_OPEN_FAIL" },
    { RPC_X_SS_CHAR_TRANS_SHORT_FILE,  "RPC_X_SS_CHAR_TRANS_SHORT_FILE" },
    { RPC_X_SS_IN_NULL_CONTEXT,    "RPC_X_SS_IN_NULL_CONTEXT" },
    { RPC_X_SS_CONTEXT_DAMAGED,    "RPC_X_SS_CONTEXT_DAMAGED" },
    { RPC_X_SS_HANDLES_MISMATCH,   "RPC_X_SS_HANDLES_MISMATCH" },
    { RPC_X_SS_CANNOT_GET_CALL_HANDLE, "RPC_X_SS_CANNOT_GET_CALL_HANDLE" },
    { RPC_X_NULL_REF_POINTER,  "RPC_X_NULL_REF_POINTER" },
    { RPC_X_ENUM_VALUE_OUT_OF_RANGE,   "RPC_X_ENUM_VALUE_OUT_OF_RANGE" },
    { RPC_X_BYTE_COUNT_TOO_SMALL,  "RPC_X_BYTE_COUNT_TOO_SMALL" },
    { RPC_X_BAD_STUB_DATA, "RPC_X_BAD_STUB_DATA" },
    { ERROR_INVALID_USER_BUFFER,   "ERROR_INVALID_USER_BUFFER" },
    { ERROR_UNRECOGNIZED_MEDIA,    "ERROR_UNRECOGNIZED_MEDIA" },
    { ERROR_NO_TRUST_LSA_SECRET,   "ERROR_NO_TRUST_LSA_SECRET" },
    { ERROR_NO_TRUST_SAM_ACCOUNT,  "ERROR_NO_TRUST_SAM_ACCOUNT" },
    { ERROR_TRUSTED_DOMAIN_FAILURE,    "ERROR_TRUSTED_DOMAIN_FAILURE" },
    { ERROR_TRUSTED_RELATIONSHIP_FAILURE,  "ERROR_TRUSTED_RELATIONSHIP_FAILURE" },
    { ERROR_TRUST_FAILURE, "ERROR_TRUST_FAILURE" },
    { RPC_S_CALL_IN_PROGRESS,  "RPC_S_CALL_IN_PROGRESS" },
    { ERROR_NETLOGON_NOT_STARTED,  "ERROR_NETLOGON_NOT_STARTED" },
    { ERROR_ACCOUNT_EXPIRED,   "ERROR_ACCOUNT_EXPIRED" },
    { ERROR_REDIRECTOR_HAS_OPEN_HANDLES,   "ERROR_REDIRECTOR_HAS_OPEN_HANDLES" },
    { ERROR_PRINTER_DRIVER_ALREADY_INSTALLED,  "ERROR_PRINTER_DRIVER_ALREADY_INSTALLED" },
    { ERROR_UNKNOWN_PORT,  "ERROR_UNKNOWN_PORT" },
    { ERROR_UNKNOWN_PRINTER_DRIVER,    "ERROR_UNKNOWN_PRINTER_DRIVER" },
    { ERROR_UNKNOWN_PRINTPROCESSOR,    "ERROR_UNKNOWN_PRINTPROCESSOR" },
    { ERROR_INVALID_SEPARATOR_FILE,    "ERROR_INVALID_SEPARATOR_FILE" },
    { ERROR_INVALID_PRIORITY,  "ERROR_INVALID_PRIORITY" },
    { ERROR_INVALID_PRINTER_NAME,  "ERROR_INVALID_PRINTER_NAME" },
    { ERROR_PRINTER_ALREADY_EXISTS,    "ERROR_PRINTER_ALREADY_EXISTS" },
    { ERROR_INVALID_PRINTER_COMMAND,   "ERROR_INVALID_PRINTER_COMMAND" },
    { ERROR_INVALID_DATATYPE,  "ERROR_INVALID_DATATYPE" },
    { ERROR_INVALID_ENVIRONMENT,   "ERROR_INVALID_ENVIRONMENT" },
    { RPC_S_NO_MORE_BINDINGS,  "RPC_S_NO_MORE_BINDINGS" },
    { ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT, "ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT" },
    { ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT, "ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT" },
    { ERROR_NOLOGON_SERVER_TRUST_ACCOUNT,  "ERROR_NOLOGON_SERVER_TRUST_ACCOUNT" },
    { ERROR_DOMAIN_TRUST_INCONSISTENT, "ERROR_DOMAIN_TRUST_INCONSISTENT" },
    { ERROR_SERVER_HAS_OPEN_HANDLES,   "ERROR_SERVER_HAS_OPEN_HANDLES" },
    { ERROR_RESOURCE_DATA_NOT_FOUND,   "ERROR_RESOURCE_DATA_NOT_FOUND" },
    { ERROR_RESOURCE_TYPE_NOT_FOUND,   "ERROR_RESOURCE_TYPE_NOT_FOUND" },
    { ERROR_RESOURCE_NAME_NOT_FOUND,   "ERROR_RESOURCE_NAME_NOT_FOUND" },
    { ERROR_RESOURCE_LANG_NOT_FOUND,   "ERROR_RESOURCE_LANG_NOT_FOUND" },
    { ERROR_NOT_ENOUGH_QUOTA,  "ERROR_NOT_ENOUGH_QUOTA" },
    { RPC_S_NO_INTERFACES, "RPC_S_NO_INTERFACES" },
    { RPC_S_CALL_CANCELLED,    "RPC_S_CALL_CANCELLED" },
    { RPC_S_BINDING_INCOMPLETE,    "RPC_S_BINDING_INCOMPLETE" },
    { RPC_S_COMM_FAILURE,  "RPC_S_COMM_FAILURE" },
    { RPC_S_UNSUPPORTED_AUTHN_LEVEL,   "RPC_S_UNSUPPORTED_AUTHN_LEVEL" },
    { RPC_S_NO_PRINC_NAME, "RPC_S_NO_PRINC_NAME" },
    { RPC_S_NOT_RPC_ERROR, "RPC_S_NOT_RPC_ERROR" },
    { RPC_S_UUID_LOCAL_ONLY,   "RPC_S_UUID_LOCAL_ONLY" },
    { RPC_S_SEC_PKG_ERROR, "RPC_S_SEC_PKG_ERROR" },
    { RPC_S_NOT_CANCELLED, "RPC_S_NOT_CANCELLED" },
    { RPC_X_INVALID_ES_ACTION, "RPC_X_INVALID_ES_ACTION" },
    { RPC_X_WRONG_ES_VERSION,  "RPC_X_WRONG_ES_VERSION" },
    { RPC_X_WRONG_STUB_VERSION,    "RPC_X_WRONG_STUB_VERSION" },
#ifdef RPC_X_INVALID_PIPE_OBJECT
    { RPC_X_INVALID_PIPE_OBJECT,   "RPC_X_INVALID_PIPE_OBJECT" },
#endif
#ifdef RPC_X_INVALID_PIPE_OPERATION
    { RPC_X_INVALID_PIPE_OPERATION,    "RPC_X_INVALID_PIPE_OPERATION" },
#endif
#ifdef RPC_X_WRONG_PIPE_VERSION
    { RPC_X_WRONG_PIPE_VERSION,    "RPC_X_WRONG_PIPE_VERSION" },
#endif
    { RPC_S_GROUP_MEMBER_NOT_FOUND,    "RPC_S_GROUP_MEMBER_NOT_FOUND" },
    { EPT_S_CANT_CREATE,   "EPT_S_CANT_CREATE" },
    { RPC_S_INVALID_OBJECT,    "RPC_S_INVALID_OBJECT" },
    { ERROR_INVALID_TIME,  "ERROR_INVALID_TIME" },
    { ERROR_INVALID_FORM_NAME, "ERROR_INVALID_FORM_NAME" },
    { ERROR_INVALID_FORM_SIZE, "ERROR_INVALID_FORM_SIZE" },
    { ERROR_ALREADY_WAITING,   "ERROR_ALREADY_WAITING" },
    { ERROR_PRINTER_DELETED,   "ERROR_PRINTER_DELETED" },
    { ERROR_INVALID_PRINTER_STATE, "ERROR_INVALID_PRINTER_STATE" },
    { ERROR_PASSWORD_MUST_CHANGE,  "ERROR_PASSWORD_MUST_CHANGE" },
    { ERROR_DOMAIN_CONTROLLER_NOT_FOUND,   "ERROR_DOMAIN_CONTROLLER_NOT_FOUND" },
    { ERROR_ACCOUNT_LOCKED_OUT,    "ERROR_ACCOUNT_LOCKED_OUT" },
#ifdef OR_INVALID_OXID
    { OR_INVALID_OXID, "OR_INVALID_OXID" },
#endif
#ifdef OR_INVALID_OID
    { OR_INVALID_OID,  "OR_INVALID_OID" },
#endif
#ifdef OR_INVALID_SET
    { OR_INVALID_SET,  "OR_INVALID_SET" },
#endif
#ifdef RPC_S_SEND_INCOMPLETE
    { RPC_S_SEND_INCOMPLETE,   "RPC_S_SEND_INCOMPLETE" },
#endif
    { ERROR_NO_BROWSER_SERVERS_FOUND,  "ERROR_NO_BROWSER_SERVERS_FOUND" },
    { ERROR_INVALID_PIXEL_FORMAT,  "ERROR_INVALID_PIXEL_FORMAT" },
    { ERROR_BAD_DRIVER,    "ERROR_BAD_DRIVER" },
    { ERROR_INVALID_WINDOW_STYLE,  "ERROR_INVALID_WINDOW_STYLE" },
    { ERROR_METAFILE_NOT_SUPPORTED,    "ERROR_METAFILE_NOT_SUPPORTED" },
    { ERROR_TRANSFORM_NOT_SUPPORTED,   "ERROR_TRANSFORM_NOT_SUPPORTED" },
    { ERROR_CLIPPING_NOT_SUPPORTED,    "ERROR_CLIPPING_NOT_SUPPORTED" },
    { ERROR_UNKNOWN_PRINT_MONITOR, "ERROR_UNKNOWN_PRINT_MONITOR" },
    { ERROR_PRINTER_DRIVER_IN_USE, "ERROR_PRINTER_DRIVER_IN_USE" },
    { ERROR_SPOOL_FILE_NOT_FOUND,  "ERROR_SPOOL_FILE_NOT_FOUND" },
    { ERROR_SPL_NO_STARTDOC,   "ERROR_SPL_NO_STARTDOC" },
    { ERROR_SPL_NO_ADDJOB, "ERROR_SPL_NO_ADDJOB" },
    { ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED, "ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED" },
    { ERROR_PRINT_MONITOR_ALREADY_INSTALLED,   "ERROR_PRINT_MONITOR_ALREADY_INSTALLED" },
#ifdef ERROR_INVALID_PRINT_MONITOR
    { ERROR_INVALID_PRINT_MONITOR, "ERROR_INVALID_PRINT_MONITOR" },
#endif
#ifdef ERROR_PRINT_MONITOR_IN_USE
    { ERROR_PRINT_MONITOR_IN_USE,  "ERROR_PRINT_MONITOR_IN_USE" },
#endif
#ifdef ERROR_PRINTER_HAS_JOBS_QUEUED
    { ERROR_PRINTER_HAS_JOBS_QUEUED,   "ERROR_PRINTER_HAS_JOBS_QUEUED" },
#endif
#ifdef ERROR_SUCCESS_REBOOT_REQUIRED
    { ERROR_SUCCESS_REBOOT_REQUIRED,   "ERROR_SUCCESS_REBOOT_REQUIRED" },
#endif
#ifdef ERROR_SUCCESS_RESTART_REQUIRED
    { ERROR_SUCCESS_RESTART_REQUIRED,  "ERROR_SUCCESS_RESTART_REQUIRED" },
#endif
    { ERROR_WINS_INTERNAL, "ERROR_WINS_INTERNAL" },
    { ERROR_CAN_NOT_DEL_LOCAL_WINS,    "ERROR_CAN_NOT_DEL_LOCAL_WINS" },
    { ERROR_STATIC_INIT,   "ERROR_STATIC_INIT" },
    { ERROR_INC_BACKUP,    "ERROR_INC_BACKUP" },
    { ERROR_FULL_BACKUP,   "ERROR_FULL_BACKUP" },
    { ERROR_REC_NON_EXISTENT,  "ERROR_REC_NON_EXISTENT" },
    { ERROR_RPL_NOT_ALLOWED,   "ERROR_RPL_NOT_ALLOWED" },
//  { WSAEINTR,    "WSAEINTR" },
//  { WSAEBADF,    "WSAEBADF" },
//  { WSAEACCES,   "WSAEACCES" },
//  { WSAEFAULT,   "WSAEFAULT" },
//  { WSAEINVAL,   "WSAEINVAL" },
//  { WSAEMFILE,   "WSAEMFILE" },
    { WSAEWOULDBLOCK,  "WSAEWOULDBLOCK" },
    { WSAEINPROGRESS,  "WSAEINPROGRESS" },
    { WSAEALREADY, "WSAEALREADY" },
    { WSAENOTSOCK, "WSAENOTSOCK" },
    { WSAEDESTADDRREQ, "WSAEDESTADDRREQ" },
    { WSAEMSGSIZE, "WSAEMSGSIZE" },
    { WSAEPROTOTYPE,   "WSAEPROTOTYPE" },
    { WSAENOPROTOOPT,  "WSAENOPROTOOPT" },
    { WSAEPROTONOSUPPORT,  "WSAEPROTONOSUPPORT" },
    { WSAESOCKTNOSUPPORT,  "WSAESOCKTNOSUPPORT" },
    { WSAEOPNOTSUPP,   "WSAEOPNOTSUPP" },
    { WSAEPFNOSUPPORT, "WSAEPFNOSUPPORT" },
    { WSAEAFNOSUPPORT, "WSAEAFNOSUPPORT" },
    { WSAEADDRINUSE,   "WSAEADDRINUSE" },
    { WSAEADDRNOTAVAIL,    "WSAEADDRNOTAVAIL" },
    { WSAENETDOWN, "WSAENETDOWN" },
    { WSAENETUNREACH,  "WSAENETUNREACH" },
    { WSAENETRESET,    "WSAENETRESET" },
    { WSAECONNABORTED, "WSAECONNABORTED" },
    { WSAECONNRESET,   "WSAECONNRESET" },
    { WSAENOBUFS,  "WSAENOBUFS" },
    { WSAEISCONN,  "WSAEISCONN" },
    { WSAENOTCONN, "WSAENOTCONN" },
    { WSAESHUTDOWN,    "WSAESHUTDOWN" },
    { WSAETOOMANYREFS, "WSAETOOMANYREFS" },
    { WSAETIMEDOUT,    "WSAETIMEDOUT" },
    { WSAECONNREFUSED, "WSAECONNREFUSED" },
    { WSAELOOP,    "WSAELOOP" },
//  { WSAENAMETOOLONG, "WSAENAMETOOLONG" },
    { WSAEHOSTDOWN,    "WSAEHOSTDOWN" },
    { WSAEHOSTUNREACH, "WSAEHOSTUNREACH" },
//  { WSAENOTEMPTY,    "WSAENOTEMPTY" },
    { WSAEPROCLIM, "WSAEPROCLIM" },
    { WSAEUSERS,   "WSAEUSERS" },
    { WSAEDQUOT,   "WSAEDQUOT" },
    { WSAESTALE,   "WSAESTALE" },
    { WSAEREMOTE,  "WSAEREMOTE" },
    { WSAEDISCON,  "WSAEDISCON" },
    { WSASYSNOTREADY,  "WSASYSNOTREADY" },
    { WSAVERNOTSUPPORTED,  "WSAVERNOTSUPPORTED" },
    { WSANOTINITIALISED,   "WSANOTINITIALISED" },
    { WSAHOST_NOT_FOUND,   "WSAHOST_NOT_FOUND" },
    { WSATRY_AGAIN,    "WSATRY_AGAIN" },
    { WSANO_RECOVERY,  "WSANO_RECOVERY" },
    { WSANO_DATA,  "WSANO_DATA" },
#endif
};

const char *stringFromErrorCode(int err)
{
    for (unsigned i = 0; i < sizeof(errortable)/sizeof(errortable[0]); i++)
    {
        if (errortable[i].errorNum == err) {
            return errortable[i].errorString;
        }
    }
    return 0;
}

bool errorCodeFromString(const char *text, int *err)
{
    for (unsigned i = 0; i < sizeof(errortable)/sizeof(errortable[0]); i++)
    {
        if (strcmp(text, errortable[i].errorString) == 0)
        {
            *err = errortable[i].errorNum;
            return true;
        }
    }
    return false;
}
