/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXEDIT_UI_SEARCHMASS_OPTIONS_H
#define POLYXEDIT_UI_SEARCHMASS_OPTIONS_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"


GtkWidget *
polyxedit_searchmass_opt_setup_wnd (PxmEditCtxt *editctxt);

void
polyxedit_searchmass_opt_mass_entry_activate (GtkEntry *entry,
					      gpointer data);

gint
polyxedit_searchmass_opt_search_masses (PxmEditCtxt *editctxt,
					GtkWidget *window,
					GPtrArray *smoptGPA,
					GPtrArray *alloligsGPA,
					PxmCalcOpt *calcopt,
					PxmIonizerule *ionizerule);
void
polyxedit_searchmass_opt_search_button (GtkWidget *button,
					gpointer data);

gboolean
polyxedit_searchmass_opt_get_mass_value (GtkWidget *window, 
					 PxmMassType type,
					 PxmSearchmassOpt *smopt);

gboolean
polyxedit_searchmass_opt_get_tolerance_value (GtkWidget *window, 
					      PxmMassType type,
					      PxmSearchmassOpt *smopt);

gboolean
polyxedit_searchmass_opt_get_tolerance_type (GtkWidget *window, 
					     PxmMassType type,
					     PxmSearchmassOpt *smopt);

gboolean
polyxedit_searchmass_opt_get_selection_type (GtkWidget *window,
					     PxmCalcOpt *calcopt);



/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxedit_searchmass_opt_wnd_really_close (GtkWidget *window);

gboolean
polyxedit_searchmass_opt_wnd_delete_event (GtkWidget *window, 
					   GdkEventAny *event, 
					   gpointer data);


















#endif /* POLYXEDIT_UI_SEARCHMASS_OPTIONS_H */
