/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXEDIT_UI_SEQED_CLIPBOARD_H
#define POLYXEDIT_UI_SEQED_CLIPBOARD_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"







GtkWidget *
polyxedit_seqed_clipboard_import_wnd_setup (PxmEditCtxt *editctxt,
					    gchar *seq,
					    GPtrArray *errorsGPA);

void
polyxedit_seqed_clipboard_import_wnd_sequence_data_button_clicked (GtkWidget *
								   widget,
								   gpointer 
								   data);

gboolean
polyxedit_seqed_clipboard_import_wnd_sequence_format (GtkWidget *widget);



void
polyxedit_seqed_clipboard_import_wnd_remove_all_tagged_chars_button (GtkWidget *
							     widget,
							     gpointer data);

void
polyxedit_seqed_clipboard_import_wnd_purify_sequence_button(GtkWidget *
							    widget,
							    gpointer data);
void
polyxedit_seqed_clipboard_import_wnd_check_sequence_button(GtkWidget *
							   widget,
							   gpointer data);
void
polyxedit_seqed_clipboard_import_wnd_cancel_button (GtkWidget *widget,
						    gpointer data);

void
polyxedit_seqed_clipboard_import_wnd_revert_button (GtkWidget *widget,
						    gpointer data);



/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxedit_seqed_clipboard_import_wnd_really_close (GtkWidget *window);


gint
polyxedit_seqed_clipboard_import_wnd_delete_event (GtkWidget *window, 
						   GdkEventAny *event, 
						   gpointer data);

gint
polyxedit_seqed_clipboard_import_wnd_destroy_event (GtkWidget *window, 
						   GdkEventAny *event, 
						   gpointer data);





/************* CLIPBOARD LOW-LEVEL FUNCTIONS **********************/

void
polyxedit_seqed_clipboard_selection_get (GtkWidget *widget,
				   GtkSelectionData *selection_data,
				   guint info,
				   guint time_stamp,
				   gpointer data);

void
polyxedit_seqed_clipboard_selection_received (GtkWidget *widget,
				   GtkSelectionData *selection_data,
				   guint time,
				   gpointer data);


gboolean
polyxedit_seqed_clipboard_selection_clear (GtkWidget *widget,
					   GdkEventSelection *event,
					   gpointer data);


gboolean
polyxedit_seqed_clipboard_primary_copy (PxmEditCtxt *editctxt);

void
polyxedit_seqed_clipboard_primary_paste (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_clipboard_copy (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_clipboard_cut (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_clipboard_paste (PxmEditCtxt *editctxt);

















#endif /* POLYXEDIT_UI_SEQED_CLIPBOARD_H */

