/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXEDIT_UI_SEQED_KBD_H
#define POLYXEDIT_UI_SEQED_KBD_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"



/*
****************************************************************
****** HELPER FUNCTIONS FOR HANDLING THE TYPED KEYBD KEYS ******
****************************************************************
*/
gboolean
polyxedit_seqed_kbd_key_press_event (GtkWidget *widget,
				     GdkEventKey *event,
				     gpointer data);

gboolean
polyxedit_seqed_kbd_key_release_event (GtkWidget *widget,
				       GdkEventKey *event,
				       gpointer data);

gboolean
polyxedit_seqed_kbd_alpha_handler (gchar *key_name,
				   PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_backspace_handler (PxmEditCtxt *editctxt);      

gboolean
polyxedit_seqed_kbd_delete_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_right_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_left_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_home_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_end_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_up_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_down_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_page_up_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_page_down_handler (PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_kbd_enter_handler (PxmEditCtxt *editctxt);




/*
****************************************************************
****** HELPER FUNCTIONS FOR HANDLING THE PARSING OF CODES ******
****************************************************************
*/
gboolean
polyxedit_seqed_kbd_del_last_char_elab_code (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_kbd_echo_elab_code (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_kbd_check_complete_elab_code (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_kbd_force_complete_elab_code (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_kbd_evaluate_code (gchar *code, gint idx,
				   PxmEditCtxt *editctxt);
















#endif /* ifndef POLYXEDIT_UI_SEQED_KBD_H */
