/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxmass-ui-console.h"

    
GtkWidget *
polyxmass_console_setup_wnd ()
{
  GtkWidget *window = NULL;
  GtkWidget *widget = NULL;
  
  GladeXML *xml = NULL;

  gchar *gui_file = NULL;

  GtkTextTag* critical_tag = NULL;
  GtkTextTag* warning_tag = NULL;
  GtkTextTag* message_tag = NULL;

  GtkTextBuffer *buffer = NULL;
  

  gui_file = 
    g_strdup_printf ("%s/polyxmass-console.glade", 
		     userspec->gladedir);
  
  g_assert (gui_file != NULL);
  
  xml = glade_xml_new (gui_file, "polyxmass_console_wnd", 
		       PACKAGE);

  g_free (gui_file);

  if (xml == NULL)
    {
      g_error (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }
  
  window = glade_xml_get_widget (xml, "polyxmass_console_wnd");
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed to create the console window\n"),
	     __FILE__, __LINE__);

      g_object_unref (G_OBJECT (xml));

      return NULL;
    }


  widget = glade_xml_get_widget (xml, "console_scrolledwindow");
  g_object_set_data (G_OBJECT (window), "console_scrolledwindow",
		     widget);

  widget = glade_xml_get_widget (xml, "console_textview");
  g_object_set_data (G_OBJECT (window), "console_textview",
		     widget);

  /* We should prepare the buffer with its tags for the different colors
     of text that we'll display in the textview.
  */
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));

  critical_tag = gtk_text_buffer_create_tag (buffer,
                                             "critical_tag",
                                             "foreground", "red",
					     NULL);

  warning_tag = gtk_text_buffer_create_tag (buffer,
					    "warning_tag",
					    "foreground", "violet",
					    NULL);
  
  message_tag = gtk_text_buffer_create_tag (buffer,
					    "message_tag",
					    "foreground", "blue",
					    NULL);
  
  widget = glade_xml_get_widget (xml, "console_wnd_clear_button");
  g_object_set_data (G_OBJECT (window), "console_wnd_clear_button",
		     widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK (polyxmass_console_wnd_clear_button), 
		    window);

  widget = glade_xml_get_widget (xml, "console_wnd_hide_button");
  g_object_set_data (G_OBJECT (window), "console_wnd_hide_button",
		     widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK (polyxmass_console_wnd_hide_button), 
		    window);

  widget = glade_xml_get_widget (xml, "console_wnd_save_button");
  g_object_set_data (G_OBJECT (window), "console_wnd_save_button",
		     widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK (polyxmass_console_wnd_save_button), 
		    window);


  gtk_widget_show_all (GTK_WIDGET (window));
  
  /* We have finished setting up the window, and so also using
   * the xml data, unref them
   */
  g_object_unref (G_OBJECT (xml));

  /* The signal of the window itself.
   */
  /* Signal / callback connections.
   */
  g_signal_connect 
    (G_OBJECT (window),
     "delete_event",
     G_CALLBACK (polyxmass_console_wnd_delete_event), 
     NULL);

  return window;
}


void
polyxmass_console_wnd_clear_button (GtkWidget *widget, gpointer data)
{
  GtkWidget *window = data;
  GtkWidget *textview = NULL;

  GtkTextIter start_iter;
  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  

  g_assert (window != NULL);
  
  textview = g_object_get_data (G_OBJECT (window),
				"console_textview");
  g_assert (textview != NULL);
  
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  g_assert (buffer != NULL);
  
  gtk_text_buffer_get_start_iter (buffer, &start_iter);
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  
  gtk_text_buffer_delete (buffer, &start_iter, &end_iter);
}

void
polyxmass_console_wnd_hide_button (GtkWidget *widget, gpointer data)
{
   GtkCheckMenuItem *menuitem = NULL;
  

  /* Get the menu item that allows the showing/hiding of the window
     and activate it. It will care of everything.
   */
  menuitem = g_object_get_data (G_OBJECT (polyxmass_main_wnd),
				"polyxmass_console_window_visible");
  g_assert (menuitem != NULL);
  
  gtk_menu_item_activate ((GtkMenuItem *)menuitem); 
}


void
polyxmass_console_wnd_save_button (GtkWidget *widget, gpointer data)
{
  GtkWidget *window = data;
  GtkWidget *textview = NULL;

  GtkTextIter start_iter;
  GtkTextIter end_iter;

  GtkTextBuffer *buffer = NULL;
  gchar *text = NULL;
  
  GtkWidget *dialog;

  gint result = -1;

  FILE *filep = NULL;

  g_assert (window != NULL);
  
  textview = g_object_get_data (G_OBJECT (window),
				"console_textview");
  g_assert (textview != NULL);
  
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  g_assert (buffer != NULL);
  
  gtk_text_buffer_get_start_iter (buffer, &start_iter);
  gtk_text_buffer_get_end_iter (buffer, &end_iter);
  

  /* Now let the user select a destination file.
   */
  dialog = gtk_file_chooser_dialog_new (_("Select Save File"),
					GTK_WINDOW (polyxmass_console_wnd),
					GTK_FILE_CHOOSER_ACTION_SAVE,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					NULL);
  
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      gchar *filename;
      
      filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));

      filep = fopen (filename, "a");
      
      if (filep == NULL)
	{
	  g_critical (_("%s@%d: failed to open file: '%s'\n"),
		      __FILE__, __LINE__, filename);
	  
	  g_free (filename);
	  
	  return;
	}

      text = gtk_text_buffer_get_text (buffer,
				       &start_iter,
                                       &end_iter,
                                       FALSE);

      /* Copy the text string to the file 'filename'.
       */
      result = fputs (text, filep);
      
      fclose (filep);

      if (result == EOF || result < 0)
	{
	  g_critical (_("%s@%d: failed to save log messages to file: '%s'\n"),
		      __FILE__, __LINE__, filename);
	  
	  g_free (text);
	  g_free (filename);

	  return;
	}

      g_free (filename);
    }
  /* End of 
     if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  */
  
  gtk_widget_destroy (dialog);
}




gboolean
polyxmass_console_wnd_delete_event (GtkWidget *window, 
				    GdkEventAny *event, 
				    gpointer data)
{
  GtkCheckMenuItem *menuitem = NULL;
  

  /* Get the menu item that allows the showing/hiding of the window
     and activate it. It will care of everything.
   */
  menuitem = g_object_get_data (G_OBJECT (polyxmass_main_wnd),
				"polyxmass_console_window_visible");
  g_assert (menuitem != NULL);
  
  gtk_menu_item_activate ((GtkMenuItem *)menuitem);
   
  return TRUE;
}

  
