/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXMASS_UI_MAIN_H
#define POLYXMASS_UI_MAIN_H

#include "polyxmass-globals.h"



GtkWindow*
polyxmass_ui_main_setup_wnd (void);



/* polyxmass menu.
 */
void
on_polxymass_quit_activate (GtkWidget *widget,
			    gpointer data);

void
on_polyxmass_console_window_visible_activate (GtkWidget *widget,
					      gpointer data);

GtkWidget *
on_polyxmass_polyxmass_view_window_management_activate (GtkWidget *widget,
						  gpointer data);


/* polyxdef menu (Atom Definition)..
 */
gint
on_polyxdef_open_atom_definition_activate (GtkWidget *widget,
					   gpointer data);

gint
on_polyxdef_new_atom_definition_activate (GtkWidget *widget,
					  gpointer data);


/* polyxdef menu (Polymer Definition)..
 */
gint
on_polyxdef_open_polymer_definition_activate (GtkWidget *widget,
					      gpointer data);

gint
on_polyxdef_new_polymer_definition_activate (GtkWidget *widget,
					     gpointer data);




/* polyxcalc menu.
 */
gint
on_polyxcalc_new_calculator_without_polchemdef_activate (GtkWidget *widget,
							 gpointer data);

gint
on_polyxcalc_new_calculator_with_polchemdef_activate (GtkWidget *widget,
						      gpointer data);



/* polyxedit menu.
 */
gint
on_polyxedit_open_sequence_file_activate (GtkWidget *widget,
					  gpointer data);

gint
on_polyxedit_new_sequence_file_activate (GtkWidget *widget,
					 gpointer data);

gint
on_polyxedit_display_masses_window_activate (GtkWidget *widget,
					     gpointer data);


/* about menu.
 */
gint
on_polyxmass_about_activate (GtkWidget *widget,
			     gpointer data);





gboolean
polyxmass_ui_main_wnd_destroy_event (GtkWidget *widget,
				     GdkEvent *event,
				     gpointer data);

gboolean
polyxmass_ui_main_wnd_delete_event (GtkWidget *widget,
				     GdkEvent *event,
				     gpointer data);






#endif /* ifndef POLYXMASS_UI_MAIN_H */
