/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXMASS_UI_MZ_RATIO_H
#define POLYXMASS_UI_MZ_RATIO_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"
#include "polyxmass-window-mngmt.h"


enum
  {
    COLUMN_CHARGE = 0,
    COLUMN_LEVEL ,
    COLUMN_MONO,
    COLUMN_AVG,
    COLUMN_MASSPAIR_POINTER,

    COLUMN_COLUMN_COUNT
  };



GtkWidget *
polyxmass_mz_ratio_wnd_setup (GPtrArray *atomGPA,
			      PxmIonizerule *ionizerule,
			      GtkWidget *parent_wnd,
			      gchar *module);

gint
polyxmass_mz_ratio_wnd_calculate_mz_ratio_button (GtkWidget *button,
						gpointer data);

gboolean
polyxmass_mz_ratio_wnd_update_initial_ionizerule (GtkWidget *window);

gboolean
polyxmass_mz_ratio_wnd_update_dest_ionizerule (GtkWidget *window);

gboolean
polyxmass_mz_ratio_wnd_update_initial_masspair (GtkWidget *window);

GtkTreeModel *
polyxmass_mz_ratio_wnd_create_treeview_model (GPtrArray *masspairGPA);

gboolean
polyxmass_mz_ratio_wnd_setup_mz_ratios_treeview (GtkWidget *window, 
						 GtkWidget *vbox);
gint
polyxmass_mz_ratio_wnd_empty_mz_ratios_treeview_store (GtkWidget *window);

gint
polyxmass_mz_ratio_wnd_update_mz_ratios_treeview (GtkWidget *window);



/* REPORTING FUNCTIONS.
 */
gchar *
polyxmass_mz_ratio_wnd_make_report (PxmReportOpt* reportopt,
				    PxmWinMngmt* winmngmt);

gchar *
polyxmass_mz_ratio_wnd_make_report_text_format (PxmReportOpt* reportopt,
						PxmWinMngmt* winmngmt);

gchar *
polyxmass_mz_ratio_wnd_make_report_latex_format (PxmReportOpt* reportopt,
						 PxmWinMngmt* winmngmt);



/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxmass_mz_ratio_wnd_really_close (GtkWidget *window);

gint
polyxmass_mz_ratio_wnd_delete_event  (GtkWidget *window, 
					GdkEventAny *event, 
				       gpointer data);
gint
polyxmass_mz_ratio_wnd_destroy_event  (GtkWidget *window, 
					 GdkEventAny *event, 
					gpointer data);





#endif /* POLYXMASS_UI_MZ_RATIO_H */
