/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "polyxmass-ui-seqed-widget.h"
#include "polyxmass-ui-seqed-widget-context-menu.h"
#include "polyxmass-ui-seqed-widget-kbd.h"
#include "polyxmass-ui-seqed-widget-mnm-modif.h"
#include "polyxmass-ui-seqed-widget-plm-modif.h"
#include "polyxmass-ui-note.h"
#include "polyxmass-ui-findrep-options.h"


GtkWidget *
polyxmass_seqed_widget_context_menu_setup (GtkWidget *seqed_widget)
{
  GtkWidget *seqed_widget_context_menu;
  GtkWidget *seqed_widget_context_menu_edit;
  GtkWidget *seqed_widget_context_menu_edit_menu;
  GtkWidget *seqed_widget_context_menu_edit_copy;
  GtkWidget *edit_copy_image;
  GtkWidget *seqed_widget_context_menu_edit_cut;
  GtkWidget *edit_cut_image;
  GtkWidget *seqed_widget_context_menu_edit_paste;
  GtkWidget *edit_paste_image;

  GtkWidget *seqed_widget_context_menu_edit_copy_cut_paste_separator;

  GtkWidget *seqed_widget_context_menu_edit_import_raw_text;

  GtkWidget *seqed_widget_context_menu_edit_find_replace;
  GtkWidget *seqed_widget_context_menu_edit_find_replace_separator;

  GtkWidget *seqed_widget_context_menu_edit_annotations;
  GtkWidget *seqed_widget_context_menu_edit_annotations_menu;
  GtkWidget *seqed_widget_context_menu_edit_annotations_menu_monomer;
  GtkWidget *seqed_widget_context_menu_edit_annotations_menu_monomer_menu;
  GtkWidget *seqed_widget_context_menu_edit_annotations_menu_monomer_menu_single;
  GtkWidget *seqed_widget_context_menu_edit_annotations_menu_monomer_menu_range;
  GtkWidget *seqed_widget_context_menu_edit_annotations_menu_polymer;
  
  GtkWidget *seqed_widget_context_menu_edit_annotations_separator;

  GtkWidget *seqed_widget_context_menu_edit_list_completions;
  GtkWidget *seqed_widget_context_menu_edit_selectall;
  GtkWidget *separator11;
  GtkWidget *seqed_widget_context_menu_chemistry;
  GtkWidget *seqed_widget_context_menu_chemistry_menu;
  GtkWidget *seqed_widget_context_menu_chemistry_monomer_modif;
  GtkWidget *seqed_widget_context_menu_chemistry_polymer_modif;

  GtkWidget *seqed_widget_context_menu_self_read_sequence_to_file;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  seqed_widget_context_menu = gtk_menu_new ();

  /************* EDIT *************
   */
  seqed_widget_context_menu_edit = gtk_menu_item_new_with_mnemonic (_("_Edit"));
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu), seqed_widget_context_menu_edit);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit", 
		     seqed_widget_context_menu_edit);
  gtk_widget_show (seqed_widget_context_menu_edit);


  seqed_widget_context_menu_edit_menu = gtk_menu_new ();
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_menu", 
		     seqed_widget_context_menu_edit_menu);

  gtk_menu_item_set_submenu (GTK_MENU_ITEM (seqed_widget_context_menu_edit), 
			     seqed_widget_context_menu_edit_menu);

  /************* EDIT ---> COPY *************
   */
  seqed_widget_context_menu_edit_copy = gtk_image_menu_item_new_with_mnemonic (_("_Copy"));
  gtk_widget_show (seqed_widget_context_menu_edit_copy);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_copy", 
		     seqed_widget_context_menu_edit_copy);
  
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu),
		     seqed_widget_context_menu_edit_copy);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_copy),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_copy),
		    seqed_widget);
  edit_copy_image = gtk_image_new_from_stock ("gtk-copy", GTK_ICON_SIZE_MENU);
  gtk_widget_show (edit_copy_image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (seqed_widget_context_menu_edit_copy), edit_copy_image);

  /************* EDIT ---> CUT *************
   */
  seqed_widget_context_menu_edit_cut = gtk_image_menu_item_new_with_mnemonic (_("Cu_t"));
  gtk_widget_show (seqed_widget_context_menu_edit_cut);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_cut", 
		     seqed_widget_context_menu_edit_cut);

  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_cut);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_cut),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_cut),
		    seqed_widget);
  edit_cut_image = gtk_image_new_from_stock ("gtk-cut", GTK_ICON_SIZE_MENU);
  gtk_widget_show (edit_cut_image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (seqed_widget_context_menu_edit_cut), edit_cut_image);

  /************* EDIT ---> PASTE *************
   */
  seqed_widget_context_menu_edit_paste = gtk_image_menu_item_new_with_mnemonic (_("_Paste"));
  gtk_widget_show (seqed_widget_context_menu_edit_paste);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_paste", 
		     seqed_widget_context_menu_edit_paste);
  
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_paste);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_paste),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_paste),
		    seqed_widget);
  edit_paste_image = gtk_image_new_from_stock ("gtk-paste", GTK_ICON_SIZE_MENU);
  gtk_widget_show (edit_paste_image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (seqed_widget_context_menu_edit_paste), edit_paste_image);

  /************* EDIT COPY CUT PASTE SEPARATOR *************
   */
  seqed_widget_context_menu_edit_copy_cut_paste_separator = gtk_separator_menu_item_new ();
  gtk_widget_show (seqed_widget_context_menu_edit_copy_cut_paste_separator);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_copy_cut_paste_separator", 
		     seqed_widget_context_menu_edit_copy_cut_paste_separator);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_copy_cut_paste_separator);
  gtk_widget_set_sensitive (seqed_widget_context_menu_edit_copy_cut_paste_separator, FALSE);


  /************* EDIT ---> IMPORT RAW TEXT *************
   */
  seqed_widget_context_menu_edit_import_raw_text = gtk_menu_item_new_with_mnemonic (_("_Import Raw Text"));
  gtk_widget_show (seqed_widget_context_menu_edit_import_raw_text);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_import_raw_text", 
		     seqed_widget_context_menu_edit_import_raw_text);

  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_import_raw_text);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_import_raw_text),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_import_raw_text),
		    seqed_widget);


  /************* EDIT ---> FIND_REPLACE *************
   */
  seqed_widget_context_menu_edit_find_replace = gtk_menu_item_new_with_mnemonic (_("_Find Replace"));
  gtk_widget_show (seqed_widget_context_menu_edit_find_replace);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_find_replace", 
		     seqed_widget_context_menu_edit_find_replace);

  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_find_replace);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_find_replace),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_find_replace),
		    seqed_widget);

  /************* FIND REPLACE SEPARATOR *************
   */
  seqed_widget_context_menu_edit_find_replace_separator = gtk_separator_menu_item_new ();
  gtk_widget_show (seqed_widget_context_menu_edit_find_replace_separator);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_find_replace_separator", 
		     seqed_widget_context_menu_edit_find_replace_separator);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_find_replace_separator);
  gtk_widget_set_sensitive (seqed_widget_context_menu_edit_find_replace_separator, FALSE);


  /************* EDIT ---> ANNOTATIONS *************
   */
  seqed_widget_context_menu_edit_annotations = gtk_menu_item_new_with_mnemonic (_("_Annotations"));
  gtk_widget_show (seqed_widget_context_menu_edit_annotations);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations",
		     seqed_widget_context_menu_edit_annotations);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_annotations);

  seqed_widget_context_menu_edit_annotations_menu = gtk_menu_new ();
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations_menu",
		     seqed_widget_context_menu_edit_annotations_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (seqed_widget_context_menu_edit_annotations),
			     seqed_widget_context_menu_edit_annotations_menu);
  
  /************* EDIT ---> ANNOTATIONS -> MONOMER *************
   */
  seqed_widget_context_menu_edit_annotations_menu_monomer = gtk_menu_item_new_with_mnemonic (_("_Monomer"));
  gtk_widget_show (seqed_widget_context_menu_edit_annotations_menu_monomer);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations_menu_monomer",
		     seqed_widget_context_menu_edit_annotations_menu_monomer);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_annotations_menu),
		     seqed_widget_context_menu_edit_annotations_menu_monomer);

  seqed_widget_context_menu_edit_annotations_menu_monomer_menu = gtk_menu_new ();
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations_menu_monomer_menu",
		     seqed_widget_context_menu_edit_annotations_menu_monomer_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (seqed_widget_context_menu_edit_annotations_menu_monomer),
			     seqed_widget_context_menu_edit_annotations_menu_monomer_menu);
  
  /************* EDIT ---> ANNOTATIONS -> MONOMER -> SINGLE *************
   */
  seqed_widget_context_menu_edit_annotations_menu_monomer_menu_single = gtk_menu_item_new_with_mnemonic (_("_Single"));
  gtk_widget_show (seqed_widget_context_menu_edit_annotations_menu_monomer_menu_single);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations_menu_monomer_menu_single",
		     seqed_widget_context_menu_edit_annotations_menu_monomer_menu_single);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_annotations_menu_monomer_menu),
		     seqed_widget_context_menu_edit_annotations_menu_monomer_menu_single);  
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_annotations_menu_monomer_menu_single),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_annotations_monomer_single),
		    seqed_widget);
  
  /************* EDIT ---> ANNOTATIONS -> MONOMER -> RANGE *************
   */
  seqed_widget_context_menu_edit_annotations_menu_monomer_menu_range = gtk_menu_item_new_with_mnemonic (_("_Range"));
  gtk_widget_show (seqed_widget_context_menu_edit_annotations_menu_monomer_menu_range);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations_menu_monomer_menu_range",
		     seqed_widget_context_menu_edit_annotations_menu_monomer_menu_range);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_annotations_menu_monomer_menu),
		     seqed_widget_context_menu_edit_annotations_menu_monomer_menu_range);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_annotations_menu_monomer_menu_range),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_annotations_monomer_range),
		    seqed_widget);
  
  /************* EDIT ---> ANNOTATIONS -> POLYMER *************
   */
  seqed_widget_context_menu_edit_annotations_menu_polymer = gtk_menu_item_new_with_mnemonic (_("_Polymer"));
  gtk_widget_show (seqed_widget_context_menu_edit_annotations_menu_polymer);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations_menu_polymer",
		     seqed_widget_context_menu_edit_annotations_menu_polymer);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_annotations_menu),
		     seqed_widget_context_menu_edit_annotations_menu_polymer);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_annotations_menu_polymer),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_annotations_polymer),
		    seqed_widget);
  
  /************* EDIT ANNOTATIONS SEPARATOR *************
   */
  seqed_widget_context_menu_edit_annotations_separator = gtk_separator_menu_item_new ();
  gtk_widget_show (seqed_widget_context_menu_edit_annotations_separator);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_annotations_separator", 
		     seqed_widget_context_menu_edit_annotations_separator);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_annotations_separator);
  gtk_widget_set_sensitive (seqed_widget_context_menu_edit_annotations_separator, FALSE);

  /************* EDIT ---> LIST COMPLETIONS *************
   */
  seqed_widget_context_menu_edit_list_completions = gtk_menu_item_new_with_mnemonic (_("_List Completions"));
  gtk_widget_show (seqed_widget_context_menu_edit_list_completions);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_list_completions", 
		     seqed_widget_context_menu_edit_list_completions);

  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), 
		     seqed_widget_context_menu_edit_list_completions);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_list_completions),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_list_completions),
		    seqed_widget);

  /************* EDIT ---> SELECT ALL *************
   */
  seqed_widget_context_menu_edit_selectall = gtk_menu_item_new_with_mnemonic (_("Select _All"));
  gtk_widget_show (seqed_widget_context_menu_edit_selectall);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_edit_selectall", 
		     seqed_widget_context_menu_edit_selectall);

  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_edit_menu), seqed_widget_context_menu_edit_selectall);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_edit_selectall),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_edit_select_all),
		    seqed_widget);

  /************* SEPARATOR *************
   */
  separator11 = gtk_separator_menu_item_new ();
  gtk_widget_show (separator11);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu), separator11);
  gtk_widget_set_sensitive (separator11, FALSE);

  /************* CHEMISTRY *************
   */
  seqed_widget_context_menu_chemistry = gtk_menu_item_new_with_mnemonic (_("_Chemistry"));
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu), seqed_widget_context_menu_chemistry);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_chemistry", 
		     seqed_widget_context_menu_chemistry);
  gtk_widget_show (seqed_widget_context_menu_chemistry);
  
  
  seqed_widget_context_menu_chemistry_menu = gtk_menu_new ();
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_chemistry_menu", 
		     seqed_widget_context_menu_chemistry_menu);
  
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (seqed_widget_context_menu_chemistry), 
			     seqed_widget_context_menu_chemistry_menu);
  

  /************* CHEMISTRY ---> MODIFICATIONS (MONOMER) *************
   */
  seqed_widget_context_menu_chemistry_monomer_modif = gtk_menu_item_new_with_mnemonic (_("_Monomer Modifications"));
  gtk_widget_show (seqed_widget_context_menu_chemistry_monomer_modif);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_chemistry_monomer_modif", 
		     seqed_widget_context_menu_chemistry_monomer_modif);
  
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_chemistry_menu), 
		     seqed_widget_context_menu_chemistry_monomer_modif);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_chemistry_monomer_modif),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_chemistry_monomer_modif),
		    seqed_widget);

  /************* CHEMISTRY ---> MODIFICATIONS (POLYMER) *************
   */
  seqed_widget_context_menu_chemistry_polymer_modif = gtk_menu_item_new_with_mnemonic (_("_Polymer Modifications"));
  gtk_widget_show (seqed_widget_context_menu_chemistry_polymer_modif);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_chemistry_polymer_modif", 
		     seqed_widget_context_menu_chemistry_polymer_modif);
  
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu_chemistry_menu), 
		     seqed_widget_context_menu_chemistry_polymer_modif);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_chemistry_polymer_modif),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_chemistry_polymer_modif),
		    seqed_widget);

  /************* SEPARATOR *************
   */
  separator11 = gtk_separator_menu_item_new ();
  gtk_widget_show (separator11);
  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu), separator11);
  gtk_widget_set_sensitive (separator11, FALSE);


  /************* SELF READ SEQUENCE TO FILE *************
   */
  seqed_widget_context_menu_self_read_sequence_to_file = 
    gtk_menu_item_new_with_mnemonic (_("_Self Read Sequence To File"));

  gtk_widget_show (seqed_widget_context_menu_self_read_sequence_to_file);
  g_object_set_data (G_OBJECT (PXM_SEQED_WIDGET (seqed_widget)->canvas), 
		     "seqed_widget_context_menu_self_read_sequence_to_file", 
		     seqed_widget_context_menu_self_read_sequence_to_file);

  gtk_container_add (GTK_CONTAINER (seqed_widget_context_menu), 
		     seqed_widget_context_menu_self_read_sequence_to_file);
  gtk_tooltips_set_tip (tooltips, 
			seqed_widget_context_menu_self_read_sequence_to_file, 
			_("Self read the sequence (or the selection portion of it) to a file."), NULL);
  g_signal_connect (G_OBJECT (seqed_widget_context_menu_self_read_sequence_to_file),
		    "activate",
		    G_CALLBACK (polyxmass_seqed_widget_context_menu_self_read_sequence_to_file),
		    seqed_widget);

  return seqed_widget_context_menu;
}









/************* EDIT ---> COPY *************
 */
void
polyxmass_seqed_widget_context_menu_edit_copy (GtkMenuItem *menuitem,
					       gpointer data)
{
  polyxmass_seqed_widget_clipboard_clipboard_copy (GTK_WIDGET (data));
  
  return;
}

/************* EDIT ---> CUT *************
 */
void
polyxmass_seqed_widget_context_menu_edit_cut (GtkMenuItem *menuitem,
					      gpointer data)
{
  polyxmass_seqed_widget_clipboard_cut (GTK_WIDGET (data));
  
  return;
}

/************* EDIT ---> PASTE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_paste (GtkMenuItem *menuitem,
						gpointer data)
{
  polyxmass_seqed_widget_clipboard_clipboard_paste (GTK_WIDGET (data));
  
  return;
}

/************* EDIT ---> IMPORT RAW TEXT *************
 */
void
polyxmass_seqed_widget_context_menu_edit_import_raw_text (GtkMenuItem *menuitem,
						gpointer data)
{
  
  polyxmass_seqed_widget_import_raw_text_file (GTK_WIDGET (data));
    
  return;
}


/************* EDIT ---> FIND_REPLACE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_find_replace (GtkMenuItem *menuitem,
						       gpointer data)
{
  if (NULL == polyxmass_findrep_opt_setup_wnd (GTK_WIDGET (data)))
    {
      g_critical (_("%s@%d: failed to display the find/replace options window.\n"),
		  __FILE__, __LINE__);
    }
  
  return;
}


/************* EDIT ---> ANNOTATIONS -> MONOMER -> SINGLE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_annotations_monomer_single (GtkMenuItem *menuitem,
								     gpointer data)
{
  GtkWidget *seqed_widget = data;


  g_assert (seqed_widget != NULL);
  

  

  /* We want to see/edit the notes for currently selected monomer or
     monomer below mouse cursor when the right mouse button was
     clicked. If -1 == last_point_3_idx, we just do not do anything.
  */
  if (PXM_SEQED_WIDGET (seqed_widget)->last_point_3_idx == -1)
    return;
  
  if (NULL == polyxmass_note_setup_wnd (seqed_widget,
					NOTE_TARGET_MONOMER_SINGLE,
					-1,
					-1,
					PXM_SEQED_WIDGET (seqed_widget)->last_point_3_idx))
    {
      g_critical (_("%s@%d: failed to display the monomer note editing window.\n"),
		  __FILE__, __LINE__);
    }
  
  return;
}


/************* EDIT ---> ANNOTATIONS -> MONOMER -> RANGE *************
 */
void
polyxmass_seqed_widget_context_menu_edit_annotations_monomer_range (GtkMenuItem *menuitem,
								    gpointer data)
{
  GtkWidget *seqed_widget = data;

  gint start = 0;
  gint end = 0;
  gint clicked = 0;
  

  g_assert (seqed_widget != NULL);
  

  clicked = PXM_SEQED_WIDGET (seqed_widget)->last_point_3_idx;

  /* The user wants to edit the notes in a range of monomers. The range
     of monomer into which the notes are to be edited is defined as 
     the current selection. If there is no selection, than we should 
     alert the user and return without doing anything.
  */

  /* Also, we will have to make sure that the monomer onto which
     the cursor was lying when the right click occurred is indeed in
     the currently selected region, because this monomer is the one
     from which the PxmNotes properties are going to be displayed in
     the window to display.
  */
  
  if (FALSE == 
      polyxmass_seqed_widget_get_selection_indices (seqed_widget,
						    &start,
						    &end))
    {
      g_critical (_("%s@%d: please, select the range first.\n"),
	     __FILE__, __LINE__);
      
      return;
    }
  
  /* We want to see/edit the notes for currently selected monomer or
     monomer below mouse cursor when the right mouse button was
     clicked. If -1 == last_point_3_idx, we just do not do anything.
  */
  
  /* Remember that the function above returns an end index incremented
     by one value, so we have to decrement it.
  */
  end--;
  
  if (clicked > end || clicked < start)
    {
      g_critical (_("%s@%d: please, click one monomer of the selected range.\n"),
	     __FILE__, __LINE__);
      
      return;
    }

  if (NULL == polyxmass_note_setup_wnd (seqed_widget,
					NOTE_TARGET_MONOMER_RANGE,
					start,
					end,
					PXM_SEQED_WIDGET (seqed_widget)->last_point_3_idx))
    {
      g_critical (_("%s@%d: failed to display the monomer note editing window.\n"),
		  __FILE__, __LINE__);
    }
  
  return;
}


/************* EDIT ---> ANNOTATIONS -> POLYMER *************
 */
void
polyxmass_seqed_widget_context_menu_edit_annotations_polymer (GtkMenuItem *menuitem,
							      gpointer data)
{
  GtkWidget *seqed_widget = data;




  g_assert (seqed_widget != NULL);
  

  /* We want to see/edit the notes for currently selected monomer or
     monomer below mouse cursor when the right mouse button was
     clicked.
  */
  if (NULL == polyxmass_note_setup_wnd (seqed_widget,
					NOTE_TARGET_POLYMER,
					-1,
					-1,
					-1))
    {
      g_critical (_("%s@%d: failed to display the polymer note editing window.\n"),
		  __FILE__, __LINE__);
    }
  
  return;
}




/************* EDIT ---> LIST COMPLETIONS *************
 */
void
polyxmass_seqed_widget_context_menu_edit_list_completions (GtkMenuItem *menuitem,
							   gpointer data)
{
  if (FALSE == polyxmass_seqed_widget_kbd_check_complete_elab_code (GTK_WIDGET (data)))
    g_error (_("%s@%d: failed to check complete elab code\n"),
	     __FILE__, __LINE__);
  
  return;
}

/************* EDIT ---> SELECT ALL *************
 */
void
polyxmass_seqed_widget_context_menu_edit_select_all (GtkMenuItem *menuitem,
						     gpointer data)
{
  polyxmass_seqed_widget_select_sequence (GTK_WIDGET (data), -1, -1);
  
  return;
}

/************* SELF READ SEQUENCE TO FILE *************
 */
void
polyxmass_seqed_widget_context_menu_self_read_sequence_to_file (GtkMenuItem *menuitem,
								gpointer data)
{
  polyxmass_seqed_widget_self_read_configuration (GTK_WIDGET (data));
  
  return ;
}

/************* CHEMISTRY ---> MODIFICATIONS (MONOMER) *************
 */
void
polyxmass_seqed_widget_context_menu_chemistry_monomer_modif (GtkMenuItem *menuitem,
						   gpointer data)
{
  polyxmass_seqed_widget_mnm_modif_wnd_setup (GTK_WIDGET (data));
}

/************* CHEMISTRY ---> MODIFICATIONS (POLYMER) *************
 */
void
polyxmass_seqed_widget_context_menu_chemistry_polymer_modif (GtkMenuItem *menuitem,
						   gpointer data)
{
   polyxmass_seqed_widget_plm_modif_wnd_setup (GTK_WIDGET (data));
}


