#!/bin/sh
# Run this to generate all the initial makefiles, etc.

cp -uv /usr/share/misc/config.sub ./ && \
cp -uv /usr/share/misc/config.guess ./ && \
intltoolize --automake --force --copy && \
gettextize --force --copy --intl --no-changelog && \
aclocal -I m4 && \
#aclocal && \
autoheader --force && \
automake --copy --add-missing --force-missing && \
autoconf --force && \

# removed the -Werror flag otherwise the ./configure script would
# fail with silly tests failing.

if [ "$1" == "noopt" ]
    then
    echo "using optimization level 0"
    CFLAGS="-g -O0 -Wall -D_REENTRANT" ./configure --enable-maintainer-mode --prefix=/usr --sysconfdir=/etc
else	
    echo "using optimization level 2"
    CFLAGS="-g -O2 -Wall -D_REENTRANT" ./configure --enable-maintainer-mode --prefix=/usr --sysconfdir=/etc
fi

rm -rf autom4te.cache

