/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef POLYXEDIT_ACIDOBASIC_H
#define POLYXEDIT_ACIDOBASIC_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"

gboolean
polyxedit_acidobasic_setup_framework (PxmEditCtxt *editctxt);

gboolean
polyxedit_acidobasic_reload_data (PxmEditCtxt *editctxt);


/* LOCATING FUNCTIONS
 */
PxmMonomer *
polyxedit_acidobasic_get_monomer (gchar *code, PxmEditCtxt *editctxt);

PxmModif *
polyxedit_acidobasic_get_modif (gchar *name, PxmEditCtxt *editctxt);



/* CALCULATIONS FUNCTIONS
 */
gint
polyxedit_acidobasic_chemgroup_account_plm_end_modif (PxmChemgroup *chemgroup,
						      PxmPlmChement chement,
						      gdouble ph,
						      PxmCalcOpt *calcopt,
						      gint mnm_index,
						      PxmEditCtxt *editctxt,
						      gdouble *neg_charge,
						      gdouble *pos_charge);

gint
polyxedit_acidobasic_chemgroup_account_monomer_modif (PxmMonomer *monomer,
						      PxmChemgroup *chemgroup,
						      gdouble ph,
						      PxmCalcOpt *calcopt,
						      gint mnm_index,
						      PxmEditCtxt *editctxt,
						      gdouble *neg_charge,
						      gdouble *pos_charge);

gint
polyxedit_acidobasic_polseq_calculate_net_charge (PxmEditCtxt *editctxt,
						gdouble ph,
						PxmCalcOpt *calcopt,
						gdouble *negative_charges,
						gdouble *positive_charges);








#endif /* POLYXEDIT_ACIDOBASIC_H */
