#ifndef __IRC_H
#define __IRC_H

#define DEFAULT_IRC_PROFILE "I eat pork"
#define DEFAULT_IRC_PORT	"6667"

#include <pork_queue.h>

#define IRC_CHAN_OP			0x01
#define IRC_CHAN_VOICE		0x02

enum {
	MODE_PLUS,
	MODE_MINUS
};

typedef struct {
	queue_t *inq;
	queue_t *outq;
	char *server;
	char *chanmodes;
	char *chantypes;
	int sock;
	in_port_t port;
	char umode[24];
	void *data;
	int nick_len;
	int kick_len;
	int topic_len;
	hash_t callbacks;
} irc_session_t;

struct irc_input {
	char *tokens[16];
	char *args;
	char *cmd;
	char *orig;
	int numeric;
	u_int32_t num_tokens;
};

struct callback_handler {
	char *str;
	int (*handler)(struct pork_acct *acct, struct irc_input *in);
};

int irc_send(irc_session_t *session, char *command);
int irc_flush_outq(irc_session_t *session);
int irc_connect(const char *server, char *port, int *sock);
int irc_set_chan_mode(irc_session_t *session, char *chan, char *mode_str);
int irc_set_user_mode(irc_session_t *session, char *mode_str);
int irc_send_pong(irc_session_t *session, char *dest);
int irc_send_raw(irc_session_t *session, char *command);
int irc_send_join(irc_session_t *session, char *channel, char *key);
int irc_send_login(irc_session_t *session);
int irc_send_privmsg(irc_session_t *session, char *dest, char *msg);
int irc_send_names(irc_session_t *session, char *chan);
int irc_send_who(irc_session_t *session, char *dest);
int irc_send_whois(irc_session_t *session, char *dest);
int irc_send_whowas(irc_session_t *session, char *dest);
int irc_send_nick(irc_session_t *session, char *nick);
int irc_send_kick(irc_session_t *session, char *chan, char *nick, char *reason);
int irc_send_part(irc_session_t *session, char *chan);
int irc_send_quit(irc_session_t *session, char *reason);
int irc_send_topic(irc_session_t *session, char *chan, char *topic);
int irc_send_notice(irc_session_t *session, char *dest, char *msg);
int irc_kick(irc_session_t *session, char *chan, char *user, char *msg);
int irc_set_away(irc_session_t *session, char *msg);

int irc_input_dispatch(irc_session_t *session);
char *irc_text_filter(char *str);

int irc_callback_init(irc_session_t *session);
int irc_callback_clear(irc_session_t *session);
int irc_callback_add_defaults(irc_session_t *session);
int irc_callback_add(	irc_session_t *session,
						char *str,
						int (*handler)(struct pork_acct *, struct irc_input *));
#endif
