#include "policyd.h"


/*
 *
 *
 *                           Policy Daemon
 *
 *  policy daemon is used in conjuction with postfix to combat spam.
 *
 *  Copyright (C) 2004 Cami Sardinha (cami@mweb.co.za)
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the  GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  This program  is  distributed  in the hope that  it will be useful, but
 *  WITHOUT  WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free  Software Foundation Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */


/*
 * function: greylist_check
 *  purpose: check if triplet exists in mysql
 *   return: 0 for new record, 1 for update
 */
int
greylist_check(int fd)
{

  if(DEBUG > 0)
    logmessage("DEBUG: fd: %d checking greylist\n", fd);
  
  memset(mysqlquery_array[fd], 0x00, 512);

  /* store current time */
  timenow=gettime();
    
     mysql_array[fd][0] = -2;
  mysql_optarray[fd][0] = OPTINOUTALL;
  
  /* opt-in/opt-out? */
  if(OPTINOUT == 1)
  {

    /* build up & execute query */
    snprintf(mysqlquery_array[fd], 512,
      "SELECT _optin FROM policy WHERE _rcpt='%s' OR _rcpt='%s' ORDER BY _priority DESC LIMIT 1",
      triplet_array[fd][2], host_array[fd][2]);
    if(db_optquery(fd) == -1)
      return(db_failure(fd, "greylist"));

    /* user is opted out */
    if(mysql_optarray[fd][0] == 0)
    {
      logmessage("rcpt=%lu, greylist=optout, host=%s (%s), from=%s, to=%s, size=%s\n",
	rcpt_count,
        host_array[fd][0],      /* host */
        host_array[fd][1],      /* hostname */
        triplet_array[fd][1],   /* from */
        triplet_array[fd][2],   /* rcpt */
        triplet_array[fd][3]    /* size */
      );

      return (0);
    }
  }

  /* build up & execute query */
  snprintf(mysqlquery_array[fd], 512,
    "SELECT _count,_datenew,_datelast FROM triplet WHERE _host='%s' AND _from='%s' AND _rcpt='%s'",
      triplet_array[fd][0], triplet_array[fd][1], triplet_array[fd][2]);
  if(db_doquery(fd) == -1)
    return(db_failure(fd, "greylist"));

  /* update the greylist xheader */
  if(GREYLIST_X_HEADER==1)
  {
    snprintf(xgreylist_array[fd], 128,
      "%s host: %s count: %d size: %s\n\n",
      POSTFIX_X_HEADER, host_array[fd][0], mysql_array[fd][0], triplet_array[fd][3]);
  }


  if(mysql_array[fd][0]==-2)
  {
    /* build up & execute query */
    snprintf(mysqlquery_array[fd], 512,
      "INSERT DELAYED INTO triplet (_datenew,_datelast,_host,_from,_rcpt) VALUES (%d,%d,'%s','%s','%s')",
      timenow, timenow, triplet_array[fd][0], triplet_array[fd][1], triplet_array[fd][2]);
    if(db_doquery(fd) == -1)
      return(db_failure(fd, "greylist"));

    /* not in training mode, reject if this is the first attempt */
    if(TRAINING_MODE == 0)
    {
      logmessage("rcpt=%lu, greylist=new, host=%s (%s), from=%s, to=%s, size=%s\n",
	rcpt_count,
        host_array[fd][0],      /* host */
        host_array[fd][1],      /* hostname */
        triplet_array[fd][1],   /* from */
        triplet_array[fd][2],   /* rcpt */
        triplet_array[fd][3]    /* size */
      );
    }
    
    /* in training mode, always accept */
    if(TRAINING_MODE == 1)
    {
      logmessage("rcpt=%lu, greylist=new_train, host=%s (%s), from=%s, to=%s, size=%s\n",
	rcpt_count,
        host_array[fd][0],      /* host */
        host_array[fd][1],      /* hostname */
        triplet_array[fd][1],   /* from */
        triplet_array[fd][2],   /* rcpt */
        triplet_array[fd][3]    /* size */
      );

      /* accept */
      return (0);
    }
    
    /* reject */
    return (-1);
    
  } else {
    
    /* been 300 seconds (5 minutes) since triplet creation? */
    if(timenow < (mysql_array[fd][1]+TRIPLET_TIME))
    {
      /* not in training mode */
      if(TRAINING_MODE == 0)
      {
        logmessage("rcpt=%lu, greylist=abuse, host=%s (%s), from=%s, to=%s, size=%s\n", 
	  rcpt_count,
          host_array[fd][0],      /* host */
          host_array[fd][1],      /* hostname */
          triplet_array[fd][1],   /* from */
          triplet_array[fd][2],   /* rcpt */
          triplet_array[fd][3]    /* size */
        );

        return (-1);
      }
    }
    
    
    /* implement autowhitelisting */
    if((AUTO_WHITE_LISTING==1) && (AUTO_WHITELIST_NUMBER==1)) 
    {
      /* expire auto-whitelisted hosts if enabled */
      int expire=0;
      if(AUTO_WHITELIST_EXPIRE > 0)
	expire=timenow+AUTO_WHITELIST_EXPIRE;

      if(AUTO_WHITELIST_NETBLOCK==1)
      {
        /* build up & execute query */
        snprintf(mysqlquery_array[fd], 512,
          "INSERT DELAYED INTO whitelist (_whitelist,_description,_expire) VALUES ('%s','# autowhitelisted host',%d)",
          triplet_array[fd][0], expire);
      } else {
        /* build up & execute query */
        snprintf(mysqlquery_array[fd], 512,
          "INSERT DELAYED INTO whitelist (_whitelist,_description,_expire) VALUES ('%s','# autowhitelisted host',%d)",
          host_array[fd][0], expire);
      }
      
      /* auto whitelist host */
      if(db_doquery(fd) == -1)
	return(db_failure(fd, "greylist"));

      /* build up & execute query */
      snprintf(mysqlquery_array[fd], 512,
        "DELETE QUICK from triplet WHERE _host='%s'", triplet_array[fd][0]);

      /* clean up triplets since hosts are whitelisted */
      if(db_doquery(fd) == -1)
	return(db_failure(fd, "greylist"));

      logmessage("rcpt=%lu, greylist=awl, host=%s (%s), from=%s, to=%s, size=%s, expire: %d\n",
        rcpt_count,
        host_array[fd][0],      /* host */
        host_array[fd][1],      /* hostname */
        triplet_array[fd][1],   /* from */
        triplet_array[fd][2],   /* rcpt */
        triplet_array[fd][3],   /* size */
	expire
      );

      return(0);
    }


    /* build up & execute query */
    snprintf(mysqlquery_array[fd], 512,
      "UPDATE triplet SET _datelast='%d',_count=_count+1 WHERE _host='%s' AND _from='%s' AND _rcpt='%s'",
      timenow, triplet_array[fd][0], triplet_array[fd][1], triplet_array[fd][2]);
    if(db_doquery(fd) == -1)
      return(db_failure(fd, "greylist"));
    
    /* training mode */
    if(TRAINING_MODE == 0)
    {
      /* yes, it has.. update */
      logmessage("rcpt=%lu, greylist=update, host=%s (%s), from=%s, to=%s, size=%s\n",
	rcpt_count,
        host_array[fd][0],      /* host */
        host_array[fd][1],      /* hostname */
        triplet_array[fd][1],   /* from */
        triplet_array[fd][2],   /* rcpt */
        triplet_array[fd][3]    /* size */
      );
    }
    
    /* training mode */
    if(TRAINING_MODE == 1)
    {
      /* yes, it has.. update */
      logmessage("rcpt=%lu, greylist=update_train, host=%s (%s), from=%s, to=%s, size=%s\n",
	rcpt_count,
        host_array[fd][0],      /* host */
        host_array[fd][1],      /* hostname */
        triplet_array[fd][1],   /* from */
        triplet_array[fd][2],   /* rcpt */
        triplet_array[fd][3]    /* size */
      );
    }

    return (0);
  }
}
 
/* EOF */
