/*
CGI.cc
*/

#include "CGI.h"

CGI::CGI (const char *UPLOADBASEDIRATTACHS, const char *aSEP_CGI_VAR)
  {
  CodeUpload = 0;
  SEP_CGI_VAR = xstrdup (aSEP_CGI_VAR);
  beginmailbox = NULL;
  stservice    = NULL;
  stcmd        = NULL;
  stsubcmd     = NULL;
  stlang       = NULL;
  user         = NULL;
  connid       = NULL;
  validator    = NULL;
  parm1        = NULL;
  parm2        = NULL;
  parm3        = NULL;
  parm4        = NULL; 
  Num_Cookies  = parse_cookies (&cookies);
  CodeUpload   = read_cgi_input(&entries, (char *)UPLOADBASEDIRATTACHS);
  stservice    = GetEntry("service");
  stcmd        = GetEntry("cmd");
  stsubcmd     = GetEntry("subcmd");
  beginmailbox = GetEntry("beginmailbox"); if (!IsEmpty(beginmailbox)) unescape_url (beginmailbox);
  stlang       = GetEntry("lang");         if (!IsEmpty(stlang))  unescape_url (stlang);
  user         = GetEntry("user");         if (!IsEmpty(user))    unescape_url (user);
  connid       = GetEntry("connid");       if (!IsEmpty(connid))  unescape_url (connid);
  validator    = GetEntry("validator");    if (!IsEmpty(validator)) unescape_url (validator);
  pageid       = GetEntry("pageid");       if (!IsEmpty(pageid))  unescape_url (pageid);
  lastcmd      = GetEntry("lastcmd");      if (!IsEmpty(lastcmd)) unescape_url (lastcmd);
  parm1        = GetEntry("parm1");        if (!IsEmpty(parm1))   unescape_url (parm1);
  parm2        = GetEntry("parm2");        if (!IsEmpty(parm2))   unescape_url (parm2);    
  parm3        = GetEntry("parm3");        if (!IsEmpty(parm3))   unescape_url (parm3);
  parm4        = GetEntry("parm4");        if (!IsEmpty(parm4))   unescape_url (parm4);
  if ((strcmp (stcmd,  "") == 0)  || (stcmd == NULL))
    {
    Parse_PATH_INFO (getenv("PATH_INFO"));
    }
  }      
  
int CGI::getNumCookies (void)
  {
  return Num_Cookies;
  }
  
const char *CGI::get_Cookie (const char *id)
  {
  node *window;
  int cont;
  cont = 1;
  window = cookies.head;
  if ((window == NULL) || (id == NULL)) {return "";}
  while ((window != NULL) && (cont < 10))
    {
    ++cont;
    if (strcmp (window->entry.name, id) == 0) {return xstrdup (window->entry.value);}
    window = window->next;
    }
  return "";  
  }
       
const char *CGI::get_PATHINFO (void)
  {
  char *buffer = getenv("PATH_INFO");  
  if (buffer == NULL) return "";
  return xstrdup(buffer);      
  }   

const char *CGI::get_USERAGENT (void)
  {
  char *buffer = getenv("HTTP_USER_AGENT");  
  if (buffer == NULL) return "";
  return xstrdup(buffer);      
  }   
  
int CGI::getCodeUpload (void)
  {
  return CodeUpload;
  }           

CGI::~CGI ()
  {
  list_clear (&cookies);
  list_clear(&entries);
  if (THEPATH_INFO != NULL) free (THEPATH_INFO);
  if (stservice != NULL) free (stservice);
  if (stcmd != NULL)     free (stcmd);
  if (stsubcmd != NULL)  free (stsubcmd);
  if (stlang!= NULL)     free (stlang);
  if (user != NULL)      free (user);
  if (beginmailbox != NULL)      free (beginmailbox);
  if (connid != NULL)    free (connid);
  if (validator != NULL) free (validator);
  if (pageid != NULL)    free (pageid);
  if (lastcmd != NULL)   free (lastcmd);
  if (parm1 != NULL)     free (parm1);
  if (parm2 != NULL)     free (parm2);
  if (parm3 != NULL)     free (parm3);
  if (parm4 != NULL)     free (parm4);   
  }
  
char *CGI::GetEntry (const char *name)
  {
  if (cgi_val (entries, (char *)name) == NULL) return "";
  else return cgi_val (entries, (char *)name);
  } 
  
const char *CGI::GetMultipleEntries (const char *name, const char *SEP)
  {
  TBuffer abuf;
  int i;
  char **mat, *pc;
  abuf[0] = '\0';
  mat = cgi_val_multi (entries, (char *)name);
  if (mat != NULL)
    {
    i = 0;
    pc = mat[i];
    while (pc != NULL)
      {
      if (strlen(abuf) + strlen(mat[i]) + 1 < CMAXBUFFER) 
        {
        xstrncat (abuf, CMAXBUFFER, mat[i]);
        xstrncat (abuf, CMAXBUFFER, SEP);
        }
      ++i;
      pc = mat[i];
      }
    abuf[strlen(abuf) - 1] = '\0';  
    } 
  else xstrncpy (abuf, CMAXBUFFER, " ");
  return xstrdup(abuf);
  }   
  
const char *CGI::GetEntryDef (const char *name, const char *def)
  {
  char *pc;
  pc = cgi_val (entries, (char *)name);
  if (pc == NULL) 
    {
    return xstrdup(def);
    }
  else 
    {
    if (strcmp(pc, "") == 0) 
      {
      return xstrdup(def);
      }
    else 
      {
      return pc;
      }
    }
  } 
  
bool CGI::IsNullEntry (const char *name)
  {
  return !is_field_exists (entries, (char *)name);
  }
  
bool CGI::GetEntryBool (const char *name)
  {
  char *pc;
  pc = cgi_val (entries, (char *)name);
  if (pc == NULL) 
    {
    return false;
    }
  else 
    {
    if (strcmp(pc, "") == 0) 
      {
      return false;
      }
    else 
      {
      return true;
      }
    }
  } 
    
void CGI::PrintAllEntries()
  {
  printf ("Content-type: text/html\n\n");
  print_cgi_env ();
  print_entries (entries);
  exit (0);
  }

void CGI::Parse_PATH_INFO (const char *apath)
  {
  bool EncontradoEscape;
  int numtoken;
  TBuffer token;
  char letra[2];
  //THEPATH_INFO = /usr/local/apache/htdocs/filebrowser/cwd/noop/spa/prucor2/post.uv.es@BjEJgvQvKXlR9arM7bm7Qb0l/0/2/500/0/\/tony\//tony/
  //THEPATH_INFO = /cmd/spa/noprotes/xdsd4565643ghgt/save/move/list/1
  //1.stcmd, 2.stsubcmd, 3.stlang, 4.user, 5.connid, 6.validator, 7.pageid, 8.lastcmd
  //     9.parm1, 10.parm2, 11.parm3, 12.parm4
  if (apath == NULL) THEPATH_INFO = xstrdup("/");
  else THEPATH_INFO = xstrdup(apath);
  numtoken = 0; initStr (token); letra[1] = '\0';
  EncontradoEscape = false;
  for (xuint i=0; i<strlen(THEPATH_INFO); ++i)
    {
    char c;
    c = THEPATH_INFO[i];
    switch (c) 
      {
      case '\\':
        {
        if (EncontradoEscape == true)
          {
          EncontradoEscape = false;
          letra[0] = c;
          xstrncat (token, CMAXBUFFER, letra);
          break;
          }        
        EncontradoEscape = true;
        break;
        }
      case '/':
        {
        if (EncontradoEscape == true)
          {
          EncontradoEscape = false;
          letra[0] = c;
          xstrncat (token, CMAXBUFFER, letra);
          break;
          }
        ++numtoken;
        if (numtoken > 1)
          {
          switch (numtoken)
            {
            case 2: if ((strcmp (stservice,  "") == 0) || (stservice == NULL)) 
                       stservice=  xstrdup (token); break;                                               
            case 3: if ((strcmp (stcmd,  "") == 0) || (stcmd == NULL)) 
                       stcmd=  xstrdup (token); break;                 
            case 4: if ((strcmp (stsubcmd,  "") == 0) || (stsubcmd == NULL)) 
                       stsubcmd=  xstrdup (token); break;                 
            case 5: if ((strcmp (stlang, "") == 0) || (stlang == NULL))  
                       stlang= xstrdup (token); break;
            case 6: if ((strcmp (user,   "") == 0) || (user == NULL))  
                       user=   xstrdup (token); break;
            case 7: if ((strcmp (connid, "") == 0) || (connid == NULL))  
                       connid= xstrdup (token); break;
            case 8: if ((strcmp (validator, "") == 0) || (validator == NULL))  
                       validator= xstrdup (token); break;
            case 9: if ((strcmp (pageid, "") == 0) || (pageid == NULL))  
                       pageid= xstrdup (token); break;     
            case 10:if ((strcmp (lastcmd, "") == 0) || (lastcmd == NULL))  
                       lastcmd= xstrdup (token); break;                            
            case 11:if ((strcmp (parm1,  "") == 0) || (parm1 == NULL))
                       parm1=  xstrdup (token); break;
            case 12:if ((strcmp (parm2,  "") == 0) || (parm2 == NULL))  
                       parm2=  xstrdup (token); break;
            case 13:if ((strcmp (parm3,  "") == 0) || (parm3 == NULL))  
                       parm3=  xstrdup (token); break;
            case 14:if ((strcmp (parm4,  "") == 0) || (parm4 == NULL))  
                       parm4=  xstrdup (token); break;
            }
          initStr (token);
          }
        break;
        }
      default:
        {
        EncontradoEscape = false;
        letra[0] = c;
        xstrncat (token, CMAXBUFFER, letra);
        break;
        }
      }
    }
  if (strlen(token) > 0)
    {
    ++numtoken;
    if (numtoken > 1)
      {
      switch (numtoken)
        {
        case 2: if ((strcmp (stservice,  "") == 0)  || (stservice == NULL))  
                  stservice = xstrdup (token); break;                
        case 3: if ((strcmp (stcmd,  "") == 0)  || (stcmd == NULL))  
                  stcmd = xstrdup (token); break;
        case 4: if ((strcmp (stsubcmd,  "") == 0)  || (stsubcmd == NULL))  
                  stsubcmd = xstrdup (token); break;
        case 5: if ((strcmp (stlang,  "") == 0) || (stlang == NULL))  
                  stlang = xstrdup (token); break;
        case 6: if ((strcmp (user,  "") == 0)   || (user == NULL))     
                  user = xstrdup (token); break;
        case 7: if ((strcmp (connid,  "") == 0) || (connid == NULL))   
                  connid = xstrdup (token); break;
        case 8: if ((strcmp (validator,  "") == 0) || (validator == NULL))   
                 validator = xstrdup (token); break;
        case 9: if ((strcmp (pageid,  "") == 0) || (pageid == NULL))   
                 pageid = xstrdup (token); break;                 
        case 10:if ((strcmp (lastcmd,  "") == 0) || (lastcmd == NULL))   
                 lastcmd = xstrdup (token); break;                         
        case 11: if ((strcmp (parm1,  "") == 0)  || (parm1 == NULL))
                  parm1 = xstrdup (token); break;
        case 12:if ((strcmp (parm2,  "") == 0)  || (parm2 == NULL))    
                  parm2 = xstrdup (token); break;
        case 13:if ((strcmp (parm3,  "") == 0)  || (parm3 == NULL))    
                  parm3 = xstrdup (token); break;
        case 14:if ((strcmp (parm4,  "") == 0)  || (parm4 == NULL))    
                  parm4 = xstrdup (token); break;
        }
      initStr (token);
      }
    }
  }                 

const char *CGI::getService ()
  {
  if (stservice == NULL) return xstrdup ("");  
  return xstrdup (stservice);
  } 
  
const char *CGI::getCmd ()
  {
  if (stcmd == NULL) return xstrdup ("");  
  return xstrdup (stcmd);
  } 

const char *CGI::getSubCmd ()
  {
  if (stsubcmd == NULL) return xstrdup ("");  
  return xstrdup (stsubcmd);
  } 
  
const char *CGI::getLang ()
  {
  if (stlang == NULL) return xstrdup ("eng");
  if (strcmp (stlang,  "") == 0) return xstrdup ("eng");
  return xstrdup (stlang);
  }   
  
const char *CGI::getUser ()
  {
  if (user == NULL) return xstrdup ("");
  return xstrdup (user);
  } 

const char *CGI::getConnid ()
  {
  if (connid == NULL) return xstrdup ("-1");
  if (strcmp (connid,  "") == 0) return xstrdup ("-1");  
  return xstrdup (connid);
  } 

const char *CGI::getValidator ()
  {
  if (validator == NULL) return xstrdup ("-1");
  if (strcmp (validator,  "") == 0) return xstrdup ("-1");  
  if (xatoidef (validator, -1) == -1) return xstrdup ("-1");
  return xstrdup (validator);
  } 
  
const char *CGI::getPageId ()
  {
  if (pageid == NULL) return xstrdup ("-1");
  if (strcmp (pageid,  "") == 0) return xstrdup ("-1");  
  if (xatoidef (pageid, -1) == -1) return xstrdup ("-1");
  return xstrdup (pageid);
  }   
  
const char *CGI::getLastCmd ()
  {
  if (lastcmd == NULL) return xstrdup ("-1");
  if (strcmp (lastcmd,  "") == 0) return xstrdup ("-1");  
  if (xatoidef (lastcmd, -1) == -1) return xstrdup ("-1");
  return xstrdup (lastcmd);
  }     

const char *CGI::getParm1 ()
  {
  if (parm1 == NULL) return xstrdup ("");
  return xstrdup (parm1);
  } 

const char *CGI::getParm2 ()
  {
  if (parm2 == NULL) return xstrdup ("");  
  return xstrdup (parm2);
  } 

const char *CGI::getParm3 ()
  {
  if (parm3 == NULL) return xstrdup ("");  
  return xstrdup (parm3);
  } 

const char *CGI::getParm4 ()
  {
  if (parm4 == NULL) return xstrdup ("");  
  return xstrdup (parm4);
  }   
  
    
const char *CGI::get_REMOTE_ADDR (const char *def)
  {
  char *buffer = getenv("REMOTE_ADDR");  
  if (buffer == NULL) return xstrdup(def);
  return xstrdup(buffer);
  }

const char *CGI::get_COOKIE (void)
  {
  char *buffer = getenv("COOKIE");  
  if (buffer == NULL) return xstrdup("");
  return xstrdup(buffer);
  }

const char *CGI::Env2File (void)
  {
  return env2file (entries, SEP_CGI_VAR);
  }


