/*
HTMLBasic.h
*/

#ifndef __HTMLBASIC_H
#define __HTMLBASIC_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "Config.h"
#include "Utils.h"
#include "XSocket.h"
#include "XVector.h"
#include "XString.h"
#include "Skin.h"
#include "Language.h"
#include "UserOptions.h"
#include "Addressbook.h"
#include "ClientNNTP.h"
#include "JavaScripts.h"

class HTMLBasic
  {
  private:
    FILE *fout;
    int iout;
    XSocket *OneSocket;
    XString XBuffer;
  protected:
    long MAXMSGSFORPAGE;
  public:
    HTMLBasic (void);
    HTMLBasic (FILE *FR);
    HTMLBasic (int FR);
    HTMLBasic (XSocket *aXS);
    virtual ~HTMLBasic (void);
    void PrintStatusLine (const char *user, UserOptions *uo, bool displayClock);
    void setMAXMSGSFORPAGE (long maxmsgs);
    int WRITE (const char *fmt, ...);    
    int pcWRITE (const char *pc);
    int pcWRITEBuffer (const char *pc, xulong len);
    void printCookie (const char *cookieline);
    void Head (const char *contenttype, const char *name, const char *filename);
    void HeadInline (const char *contenttype, const char *filename, xulong len);
    void HTMLBegin (void);
    void Title (const char *title, const char *bgcolor, const char *txtcolor, const char *img_bg, bool include_js, int refresh_time, const char *newurl);
    void HTMLEnd (const char *bgtablecopyrightcolor);
    void EmulatePageNotFound (void);    
    void BeginTable (int border, int cellpadding, int cellspacing, int widthpercent);
    void EndTable (void);
    void BeginTR (void);
    void BeginTR (const char *bgcolor);
    void EndTR (void);
    void BeginTD (void);
    void BeginTDCenter (void);
    void BeginTDColSpanCenter (int acolspan);
    void BeginTDColSpan (int acolspan);    
    void BeginTD (const char *bgcolor);
    void BeginTD (const char *bgcolor, int widthpercent);
    void BeginTD (const char *bgcolor, const char *align);            
    void BeginTD (const char *bgcolor, const char *align, int colspan);    
    void BeginTD (int widthpercent);
    void BeginTD (int widthpercent, const char *facefont, int sizefont, const char *align);    
    void BeginTD (bool nowrap, int widthpercent, int rowspan, const char *facefont, int sizefont, const char *align);
    void EndTD (void);
    void EmptyCellx1 (void);
    void EmptyCellx2 (void);
    void BeginFont (const char *face, int size, const char *color);    
    void EndFont (void);
    void BeginBold (void);
    void EndBold (void);
    void BeginItalic (void);
    void EndItalic (void);
    void BeginUnderline (void);
    void EndUnderline (void);
    void BR (void);
    void Small (const char *linea);
    void Rectangle (const char *linea);
    void RedRectangle (const char *linea);    
    void BeginNOBR (void);
    void EndNOBR(void);
    void JavaScript (const char *codigo);
    void H1 (const char *linea);
    void H2 (const char *linea);
    void H3 (const char *linea);
    void H4 (const char *linea);
    void H5 (const char *linea);
    void Text (const char *linea);
    void Label (const char *linea);
    void RedLabel (const char *linea);
    void GreenLabel (const char *linea);
    void URL (const char *caption, const char *url);
    void Image (const char *urlimage, const char *label, const char *size);    
    void URLIMAGE (const char *label, const char *url, const char *urlimage);
    void PrintString (const char *linea);
    void pr (const char *linea);    
    void Redirect (const char *newurl);
    void Linea (void);
    void Error (const char *error);
    void Msg (const char *msg);
    void ErrorPage (const char *error);
    void MsgPage (const char *msg, const char *lang);    
    void soErrorPage (const char *error);
    void ErrorPageServicePwInvalid (const char *stlang, const char *user, const char *connid, UserOptions *uo);
    void Ok (const char *linea);
    void OkPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *okmsg);
    void OkPageTitle (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *okmsg, const char *title);    
    void OkPage_ReturnToBack (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *okmsg);
    void BeginPre (void);
    void EndPre (void);
    void BeginCenter (void);
    void EndCenter (void);
    void BeginFormPost (const char *name, const char *action);
    void BeginFormPostMultipartFormData (const char *name, const char *action);
    void BeginFormGet (const char *name, const char *action);
    void EndForm (void);
    void FormHiddenQuoted (const char *name, const char *value);    
    void FormHidden (const char *name, const char *value);
    void FormHidden (const char *name, int value);    
    void FormEdit (int max, int size, const char *name, const char *value);
    void FormFile (int max, int size, const char *name, const char *value, const char *accept);
    void FormTextArea (int rows, int cols, const char *name, const char *value, bool readonly);    
    void FormPassword (int max, int size, const char *name, const char *value);
    void FormCheckbox (const char *name, const char *value, bool checked);
    void JSFormCheckbox (const char *name, const char *value, const char *onclick, bool checked);
    void FormImage (const char *name, const char *src);
    void FormButton (const char *name, const char *value);
    void FormButton (const char *name, const char *value, const char *onclick);
    void FormReset (const char *value);
    void FormBeginSelect (const char *formname, const char *selectname, const char *submitbutton, bool use_javascript);
    void FormBeginMultipleSelect (const char *formname, const char *selectname, const char *submitbutton, bool use_javascript);    
    void FormAddOptionSelect (bool selected, const char *value, const char *label);
    void FormEndSelect ();
    void dumpSL (StringList *SL, bool PutNewLines);
    void dumpPChar (const char *pc);    
    void dumpFile (TBuffer fn, TBuffer ContentType);
    void PrintBadCookiePage (const char *stlang, const char *user, const char *connid, UserOptions *uo);
    void PrintInvalidCommand (const char *stlang, const char *user, const char *connid, UserOptions *uo);    
    void PrintInvalidPage (const char *stlang, const char *user, const char *connid, UserOptions *uo);
    void PrintConfirmPage (int service, const char *stcmd, const char *stlang, const char *tokentodelete,
                           const char *user, const char *connid, int validator, int pageid, UserOptions *uo);
    void PrintHelpPage (int service, const char *stcmd, const char *user);    
    void BotoneraTop (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo);
    void BotoneraHomePage (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo);    
    };
  
#endif  
  
