/*                               
Service_Main.cc
*/

#include "Service_Main.h"
#include "Service_Cclient.h"
#include "Service_PopPass.h"
#include "Service_ForwardMail.h"
#include "Service_FileBrowser.h"
#include "Service_SecVirtual.h"
#include "Service_Databases.h"
#include "Service_Finger.h"
#include "Service_PersonalData.h"
#include "Service_UserAccounts.h"
#include "Service_Config.h"
#include "Service_Sieve.h"
#include "Service_Calendar.h"

extern Language *L;
extern CCLIENT *cclient;
extern Configuration *Conf;
extern Authentication *auth;
extern Skin *skin;

//retrieve the url for the Service icon
const char *GetService_Main_ICO_URL (void)
  {
  return skin->getI(L_MAIN);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Main_ICO_ALT (void)
  {
  return L->get(L_MAIN);
  }

//Retrieve the Service name
const char *GetService_Main_NAME (void)
  {
  return L->get(L_MAIN);
  }

//Retrieve the Service Description
const char *GetService_Main_DESCRIPTION (void)
  {
  return L->get(L_MAIN_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Main_BEGIN (TProgData *pd)
  {
  LOG ("Initializating Service Main for user=%s", pd->username);
  return true;
  }

//Entry point to service end
bool DoService_Main_END (TProgData *pd)
  {
  return true;
  }

//Entry point to execute a service command
bool DoService_Main_CMD (TProgData *pd)
  {
  TBuffer tmp;
  switch (pd->cmd)
    {
    case (CMD_SPECIAL_CHECK_COOKIE): 
      {
      CheckCookie (pd);
      return false;
      break;
      }
    case (CMD_MAIN_HELP):
      {
      pd->uo->InitStatusLine ();
      pd->html->PrintHelpPage (getiServiceFromCmd(pd->uo->getLastCmd()), pd->stsubcmd, pd->username);
      return false;
      break;
      }   
    case (CMD_MAIN_ABOUT):
      {
      pd->uo->InitStatusLine ();
      pd->html->PrintHelpPage (iSERVICE_MAIN, "about", pd->username);
      return false;
      break;
      }         
    case (CMD_MAIN_ROOT):       
    case (CMD_MAIN_HOME):
      {
      pd->uo->clearPila();
      pd->uo->InitStatusLine ();
      PrintHomePage (pd);
      return false;
      break;
      }              
    case (CMD_SPECIAL_INVALIDPAGE):
      {
      pd->html->PrintInvalidPage (pd->stlang, pd->username, pd->connid, pd->uo);
      return false;
      break;
      }              
    case (CMD_MAIN_LOGOUT):
      {
      LOG ("Logout from IP=%s, user=%s", pd->ipclient, pd->username);
      cclient->saveFlagsRCNewsFile ();
      cclient->CloseMailbox ();
      xsnprintf (tmp, CMAXBUFFER, "%s/%s?lang=%s", PATH_CGI, SERVICE_MAIN, pd->stlang);
      ClearCookie (pd);
      pd->html->Redirect(tmp);
      return true;
      break;
      }
    case (CMD_MAIN_CONF_ACT):
      {
      cgienv_GetSimpleVarDef (pd->envfile, "mailboxname", pd->parm2, "");
      pd->uo->InitStatusLine ();
      pd->html->PrintConfirmPage (iSERVICE_MAIN, pd->stsubcmd, pd->stlang, pd->parm2, pd->username, pd->connid, 
                                  pd->uo->getValidator(), pd->uo->getPageId(), pd->uo);
      return false;
      break;   
      }
    default: 
      {    
      LOG ("ERROR: Service_Main: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      return false;
      break;
      }         
    }
  }  

void CheckCookie (TProgData *pd)
  {      
  if (Conf->getInt ("main", "use_cookies", 0) == 1)
    {
    if (pd->cmd_counter == 1)  //LA PRIMERA VEZ SI EL BROWSER NO SOPORTA/ACEPTA COOKIES ME LO DEVUELVE VACIO
      {
      if (auth->isGoodCookie (pd->parm1) == false) pd->uo->setWorkingWithCookies (false);
      else pd->uo->setWorkingWithCookies (true);
      }
    else
      { 
      if (pd->uo->IsWorkingWithCookies () == true) 
        {
        if (auth->isGoodCookie (pd->parm1) == false) 
          {
          LOG ("SECURITY PROBLEM: Bad cookie from IP=%s, user=%s", pd->ipclient, pd->username);
          pd->html->PrintBadCookiePage (pd->stlang, pd->username, pd->connid, pd->uo);
          }
        }
      }
    }
  }

void ClearCookie (TProgData *pd)
  {
  if (Conf->getInt ("main", "use_cookies", 0) == 1)
    {
    if (pd->uo->IsWorkingWithCookies () == true) 
      {
      pd->html->printCookie (auth->cookie_getSetClearFullCookieLine());
      }
    }
  }
  
bool doLogin (TProgData *pd)
  {
  bool VALIDLOGIN = false;
  TBuffer tmp;
  
  //ENTRY EMPTY IN CGI imapserver FIELD. WE CORRECT IT.
  if ((pd->imapserver == NULL) || (strcmp (pd->imapserver, "") == 0) || (strcmp (pd->imapserver, " ") == 0))
    {
    xstrncpy (pd->imapserver, CMAXBUFFER, "#");
    LOG ("Field IMAP server EMPTY. Forcing '#'. IP=%s, User '%s'.", pd->ipclient, pd->username);
    }     
  //ENTRY # IN CGI imapserver FIELD AND WE MUST USE DB.
  if ((strcmp (pd->imapserver, "#") == 0) && (Conf->getInt ("main", "usedbforconf", 0) == 1))
    {
    //USER DO NOT EXIST IN DB. DEFAULT TO SECTION def_user_not_in_db
    if (exist_user (Conf->getString ("main", "dbfile", "/var/"APPNAME"/"APPNAME".db", CMAXBUFFER), pd->username) == 0)
      {
      TBuffer xbuf;
      xstrncpy (xbuf, CMAXBUFFER, Conf->getString ("main", "def_user_not_in_db", "", CMAXBUFFER));
      AddSuffixToIPName (xbuf);
      pd->uo->setImapServer (Conf->getString (xbuf, "imapserver", "imap.xx.xx", CMAXIPNAME));
      pd->uo->setImapPort   (Conf->getInt    (xbuf, "imapport", DEFIMAPPORT));
      pd->uo->setMailDomain (Conf->getString (xbuf, "maildomain", "xx.xx", CMAXIPNAME));
      pd->uo->setSMTPServer (Conf->getString (xbuf, "smtpserver", "smtp.xx.xx", CMAXIPNAME));  
      pd->uo->setAuthSMTP   (Conf->getInt    (xbuf, "authsmtp", 0));
      pd->uo->setNNTPServer (Conf->getString (xbuf, "nntpserver", "news", CMAXIPNAME));        
      cclient->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
      pd->uo->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
      cclient->setPathToRemoteFolder (Conf->getString (xbuf, "remotepath", "", CMAXBUFFER));
      pd->uo->setPoppassPort    (Conf->getInt    (xbuf, "poppassport", DEFPOPPASSPORT));          
      pd->uo->setPoppassServer  (Conf->getString (xbuf, "poppassserver", "poppass.xx.xx", CMAXIPNAME));
      pd->uo->setForwardsPort   (Conf->getInt    (xbuf, "forwardsport", DEFFORWARDPORT));
      pd->uo->setForwardsServer (Conf->getString (xbuf, "forwardsserver", "forwards.xx.xx", CMAXIPNAME));
      pd->uo->setSievePort    (Conf->getInt    (xbuf, "sieveport", DEFSIEVEPORT));
      pd->uo->setSieveServer  (Conf->getString (xbuf, "sieveserver", "sieve.xx.xx", CMAXIPNAME));
      pd->uo->setDeniedServices (Conf->getString (xbuf, "deniedservices", "", CMAXBUFFER));
      pd->uo->setTrueEmail ("");
      }
    //USER EXISTS IN DB
    else
      {
      TBuffer xbuf, aliasemail;
      int aimapport;
      IPNAME asmtpserver, amaildomain;
      db_get_data_from_user (Conf->getString ("main", "dbfile", "/var/"APPNAME"/"APPNAME".db", CMAXBUFFER), pd->username, 
                             pd->imapserver, &aimapport, asmtpserver, amaildomain, aliasemail);
      xstrncpy (xbuf, CMAXBUFFER, pd->imapserver);
      AddSuffixToIPName (xbuf);
      pd->uo->setImapServer (xbuf);
      pd->uo->setImapPort   (aimapport);
      pd->uo->setSMTPServer (asmtpserver);
      pd->uo->setAuthSMTP   (Conf->getInt    (xbuf, "authsmtp", 0));
      pd->uo->setMailDomain (amaildomain);
      pd->uo->setNNTPServer (Conf->getString (xbuf, "nntpserver", "news", CMAXIPNAME));        
      cclient->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
      pd->uo->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
      cclient->setPathToRemoteFolder (Conf->getString (xbuf, "remotepath", "", CMAXBUFFER));
      pd->uo->setPoppassPort    (Conf->getInt    (xbuf, "poppassport", DEFPOPPASSPORT));
      pd->uo->setPoppassServer  (Conf->getString (xbuf, "poppassserver", "poppass.xx.xx", CMAXIPNAME));
      pd->uo->setForwardsPort   (Conf->getInt    (xbuf, "forwardsport", DEFFORWARDPORT));
      pd->uo->setForwardsServer (Conf->getString (xbuf, "forwardsserver", "forwards.xx.xx", CMAXIPNAME));
      pd->uo->setSievePort    (Conf->getInt    (xbuf, "sieveport", DEFSIEVEPORT));
      pd->uo->setSieveServer  (Conf->getString (xbuf, "sieveserver", "sieve.xx.xx", CMAXIPNAME));
      pd->uo->setDeniedServices (Conf->getString (xbuf, "deniedservices", "", CMAXBUFFER));
      pd->uo->setTrueEmail (aliasemail);
      }        
    }    
  //ENTRY # IN CGI imapserver FIELD AND WE DO NOT MUST USE DB. DEFAULT TO SECTION def_user_not_in_db
  else if ((strcmp (pd->imapserver, "#") == 0) && (Conf->getInt ("main", "usedbforconf", 0) == 0))
    {
    TBuffer xbuf;
    xstrncpy (xbuf, CMAXBUFFER, Conf->getString ("main", "def_user_not_in_db", "", CMAXBUFFER));
    AddSuffixToIPName (xbuf);
    pd->uo->setImapServer (Conf->getString (xbuf, "imapserver", "imap.xx.xx", CMAXIPNAME));
    pd->uo->setImapPort   (Conf->getInt    (xbuf, "imapport", DEFIMAPPORT));
    pd->uo->setMailDomain (Conf->getString (xbuf, "maildomain", "xx.xx", CMAXIPNAME));
    pd->uo->setSMTPServer (Conf->getString (xbuf, "smtpserver", "smtp.xx.xx", CMAXIPNAME));  
    pd->uo->setAuthSMTP   (Conf->getInt    (xbuf, "authsmtp", 0));
    pd->uo->setNNTPServer (Conf->getString (xbuf, "nntpserver", "news", CMAXIPNAME));        
    cclient->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
    pd->uo->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
    cclient->setPathToRemoteFolder (Conf->getString (xbuf, "remotepath", "", CMAXBUFFER));
    pd->uo->setPoppassPort    (Conf->getInt    (xbuf, "poppassport", DEFPOPPASSPORT));
    pd->uo->setPoppassServer  (Conf->getString (xbuf, "poppassserver", "poppass.xx.xx", CMAXIPNAME));
    pd->uo->setForwardsPort   (Conf->getInt    (xbuf, "forwardsport", DEFFORWARDPORT));
    pd->uo->setForwardsServer (Conf->getString (xbuf, "forwardsserver", "forwards.xx.xx", CMAXIPNAME));
    pd->uo->setSievePort    (Conf->getInt    (xbuf, "sieveport", DEFSIEVEPORT));
    pd->uo->setSieveServer  (Conf->getString (xbuf, "sieveserver", "sieve.xx.xx", CMAXIPNAME));
    pd->uo->setDeniedServices (Conf->getString (xbuf, "deniedservices", "", CMAXBUFFER));    
    pd->uo->setTrueEmail ("");
    }        
  //TEXT ENTRY IN CGI imapserver FIELD
  else
    {
    TBuffer xbuf;
    xstrncpy (xbuf, CMAXBUFFER, pd->imapserver);
    AddSuffixToIPName (xbuf);
    //EXISTS imapserver SECTION
    if (Conf->IsThereSection (xbuf) == true)
      {
      pd->uo->setImapServer (Conf->getString (xbuf, "imapserver", "imap.xx.xx", CMAXIPNAME));
      pd->uo->setImapPort   (Conf->getInt    (xbuf, "imapport", DEFIMAPPORT));
      pd->uo->setMailDomain (Conf->getString (xbuf, "maildomain", "xx.xx", CMAXIPNAME));
      pd->uo->setSMTPServer (Conf->getString (xbuf, "smtpserver", pd->uo->getImapServer(), CMAXIPNAME));  
      pd->uo->setAuthSMTP   (Conf->getInt    (xbuf, "authsmtp", 0));
      pd->uo->setNNTPServer (Conf->getString (xbuf, "nntpserver", "news", CMAXIPNAME));        
      cclient->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
      pd->uo->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
      cclient->setPathToRemoteFolder (Conf->getString (xbuf, "remotepath", "", CMAXBUFFER));
      pd->uo->setPoppassPort    (Conf->getInt    (xbuf, "poppassport", DEFPOPPASSPORT));
      pd->uo->setPoppassServer  (Conf->getString (xbuf, "poppassserver", "poppass.xx.xx", CMAXIPNAME));
      pd->uo->setForwardsPort   (Conf->getInt    (xbuf, "forwardsport", DEFFORWARDPORT));
      pd->uo->setForwardsServer (Conf->getString (xbuf, "forwardsserver", "forwards.xx.xx", CMAXIPNAME));
      pd->uo->setSievePort    (Conf->getInt    (xbuf, "sieveport", DEFSIEVEPORT));
      pd->uo->setSieveServer  (Conf->getString (xbuf, "sieveserver", "sieve.xx.xx", CMAXIPNAME));
      pd->uo->setDeniedServices (Conf->getString (xbuf, "deniedservices", "", CMAXBUFFER));
      pd->uo->setTrueEmail ("");
      }
    //DO NOT EXIST imapserver SECTION IN interdaemon.cfg FILE
    else
      {
      //WE DO NOT ALLOW LOGINS IF imapserver SECTION DO NOT EXIST
      if (Conf->getInt ("main", "allowotherimapservers", 0) == 0)
        {
        LOG ("IMAP server '%s' is not allowed. IP=%s, User=%s. Exiting.", pd->imapserver, pd->ipclient, pd->username);
        pd->html->ErrorPage (L->get(L_NOTALLOWED_IMAPSERVER));
        exit(0);
        }
      //WE ALLOW LOGINS TO EVERY imapserver, BUT OVERWRITING SOME FIELDS
      else
        {
        pd->uo->setImapServer (xbuf);
        if (strcmp (Conf->getString ("*", "imapport", "*", CMAXIPNAME), "*") == 0)  
          {pd->uo->setImapPort (DEFIMAPPORT);}
        else 
          {pd->uo->setImapPort (Conf->getInt ("*", "imapport", DEFIMAPPORT));}
        if (strcmp (Conf->getString ("*", "smtpserver", "*", CMAXIPNAME), "*") == 0)  
          {pd->uo->setSMTPServer (pd->imapserver);}
        else 
          {pd->uo->setSMTPServer (Conf->getString ("*", "smtpserver", "smtp.xx.xx", CMAXIPNAME));}                                  
        if (strcmp (Conf->getString ("*", "authsmtp", "*", 0), "*") == 0)  
          {pd->uo->setAuthSMTP (0);}
        else 
          {pd->uo->setAuthSMTP (Conf->getInt ("*", "authsmtp", 0));}
        if (strcmp (Conf->getString ("*", "nntpserver", "*", CMAXIPNAME), "*") == 0)  
          {pd->uo->setNNTPServer (pd->imapserver);}
        else 
          {pd->uo->setNNTPServer (Conf->getString ("*", "nntpserver", "news", CMAXIPNAME));}                                  
        if (strcmp (Conf->getString ("*", "maildomain", "*", CMAXIPNAME), "*") == 0)  
          {pd->uo->setMailDomain (pd->imapserver);}
        else                       
          {pd->uo->setMailDomain (Conf->getString ("*", "maildomain", "xx.xx", CMAXIPNAME));}                                                  
        cclient->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
        pd->uo->setMailboxPrefix (Conf->getString (xbuf, "mailboxprefix", "", CMAXBUFFER));
        cclient->setPathToRemoteFolder (Conf->getString (xbuf, "remotepath", "", CMAXBUFFER));
        pd->uo->setSievePort    (Conf->getInt    (xbuf, "sieveport", DEFSIEVEPORT));
        pd->uo->setSieveServer  (Conf->getString (xbuf, "sieveserver", "sieve.xx.xx", CMAXIPNAME));
        pd->uo->setDeniedServices (Conf->getString (xbuf, "deniedservices", "", CMAXBUFFER));
        pd->uo->setTrueEmail ("");
        }
      }
    }   
  sm_setproctitle (PROGNAME, true, "%s   (Before IMAPValidate)", pd->username);  

  //DEBUG ("--%s--%d--%s--%s--",  pd->uo->getImapServer(), pd->uo->getImapPort(), pd->username, pd->password);
  xstrncpy (pd->connid, CMAXBUFFER, make_session_id (pd->imapserver, tmp));
  auth = new Authentication("login", pd->uo->getImapServer(), pd->uo->getImapPort(), pd->username, pd->password, pd->connid);
  VALIDLOGIN = auth->doFirstAuthentication();

  sm_setproctitle (PROGNAME, true, "%s   (After IMAPValidate)", pd->username);  
  cclient->setNNTPServer (pd->uo->getNNTPServer());
  return VALIDLOGIN;
  }

//WE ADD A DEFAULT SUFFIX TO IMAPSERVER IF THIS HAVE NOT IT (post -> post.uv.es).
void AddSuffixToIPName (TBuffer server)
  {
  if (strchr (server, '.') == NULL) 
    {
    xstrncat (server, CMAXBUFFER, Conf->getString ("main", "defaultipdomain", "", CMAXIPNAME)); 
    }
  }   

void PrintHomePage (TProgData *pd)
  {
  TBuffer tmp;
  int pageid, validator, actualcmd; 
  long unread_msgs;

  validator = pd->uo->getValidator();
  pageid    = pd->uo->getPageId();
  actualcmd = CMD_CCLIENT_MG_DISPLAY;

  pd->html->Head ("text/html", "", "");
  pd->html->HTMLBegin ();                
  pd->html->Title (L->get(TIT_SERVICES), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
                   skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);
  
  pd->html->BotoneraHomePage (actualcmd, pd->stlang, pd->username, pd->connid, pd->uo); 
  
  pd->html->Linea();
  
  pd->html->WRITE ("<CENTER><TABLE BGCOLOR=\"#FFFFFF\" BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"5\" WIDTH=\"100%%\">\n");
    
  //BUTTON OPEN MAIL
  pd->html->WRITE ("<TR>\n");   

  //***********************
  //This is the left column (for Personal Data Service, Identification)
  //***********************

  pd->html->WRITE ("<TD WIDTH=\"30%%\" rowspan=\"30\" align=\"center\">\n");
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_PERSONALDATA, NULL))
    {  
    if (pd->uo->getDisplayPersonalInfo() == true)
      {
      TBuffer tokeninfo;
      DoService_PersonalData_BEGIN (pd);      
      pd->html->WRITE ("<CENTER>\n");
         
      if (getPersonalInfo ("URLFOTO", tokeninfo))    
        {pd->html->WRITE ("<IMG BORDER=\"0\" width=\"70\" height=\"90\" SRC=\"%s\">", tokeninfo);}
      
      if (getPersonalInfo ("NAME", tokeninfo))        
        {pd->html->WRITE ("<BR><B>%s</B>", tokeninfo);} 

      pd->html->WRITE ("</CENTER>\n");
      }
    }
  pd->html->WRITE ("</TD>\n");   
 
    
  //BUTTON MAIL  
  pd->html->WRITE ("<TD align=\"left\">\n");
  pd->html->WRITE ("<A HREF=\"%s/%s/mb_change/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
  pd->html->Image (GetService_Cclient_ICO_URL(), GetService_Cclient_ICO_ALT(), skin->getISize());
  unread_msgs = cclient->getMsgsUnreadIMAPINBOX ();
  pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></A>", skin->getSkinAtribProp("FONT_TABLE"), GetService_Cclient_NAME());
  switch (unread_msgs)
    {
    case -1: /*ERROR*/ 
             break;
    case 0:  pd->html->WRITE ("  <FONT SIZE=\"-1\">(%s)</FONT>\n", L->get(MSG_NEWMSGS_0));
             break;
    case 1:  pd->html->WRITE ("  <FONT SIZE=\"-1\">(%s)</FONT>\n", L->get(MSG_NEWMSGS_1));
             break;
    default: xsnprintf (tmp, CMAXBUFFER, L->get(MSG_NEWMSGS_n), unread_msgs);
             pd->html->WRITE ("  <FONT SIZE=\"-1\">(%s)</FONT>\n", tmp);
             break;                
    }
  pd->html->WRITE ("</FONT></TD>\n"); 
  pd->html->WRITE ("</TR>\n");   

  //BUTTON OPEN NEWS
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), -1, "nntp"))
    {
    pd->html->WRITE ("<TR>\n");                          
    pd->html->WRITE ("<TD align=\"left\">\n");    
    pd->html->WRITE ("<A HREF=\"%s/%s/mb_change/noop/%s/%s/%s/%d/%d/%d/:%s/\">", PATH_CGI, SERVICE_CCLIENT, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd, DEFAULTBEGINNNTPGROUP);
    pd->html->Image (skin->getI(L_NNTP), L->get(ALT_NNTP), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"),  L->get(L_NNTP));
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }
  
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_POPPASS, NULL))
    {
    //BUTTON CHANGE PW
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_POPPASS, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_PopPass_ICO_URL(),  GetService_PopPass_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_PopPass_NAME());
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }

  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_FORWARDMAIL, NULL))
    {
    //BUTTON MESSAGE FORWARDING
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_FORWARDMAIL, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_ForwardMail_ICO_URL(),  GetService_ForwardMail_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_ForwardMail_NAME());
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }
        
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_FILEBROWSER, NULL))
    {
    //ONLY DISPLAY THAT SERVICE IF THERE ARE DISKS TO MOUNT
    if (strcmp (pd->uo->getMountPoints(), "") != 0)
      {
      //BUTTON FILE MANAGER
      pd->html->WRITE ("<TR>\n");
      pd->html->WRITE ("<TD align=\"left\">\n");
      pd->html->WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_FILEBROWSER, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
      pd->html->Image (GetService_FileBrowser_ICO_URL(),  GetService_FileBrowser_ICO_ALT(), skin->getISize());
      pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_FileBrowser_NAME());
      pd->html->WRITE ("</A>\n");
      pd->html->WRITE ("</TD>\n");    
      pd->html->WRITE ("</TR>\n");
      }  
    }                     
    
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_SECVIRTUAL, NULL))
    {
    //BUTTON SECVIRTUAL
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/goto/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_SECVIRTUAL, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_SecVirtual_ICO_URL(),  GetService_SecVirtual_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_SecVirtual_NAME());
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }                         
    
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_USERACCOUNTS, NULL))
    {
    //BUTTON USERACCOUNTS
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/goto/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_USERACCOUNTS, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_UserAccounts_ICO_URL(),  GetService_UserAccounts_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_UserAccounts_NAME());    
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }                             
    
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_DATABASES, NULL))
    {
    //BUTTON URLS
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/mainpage/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_DATABASES, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_Databases_ICO_URL(), GetService_Databases_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_Databases_DESCRIPTION());
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }    
    
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_FINGER, NULL))
    {
    //BUTTON FINGER
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_FINGER, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_Finger_ICO_URL(),  GetService_Finger_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_Finger_NAME());
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }        
    
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_CALENDAR, NULL))
    {
    //BUTTON CALENDAR
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/year_show/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_Calendar_ICO_URL(),  GetService_Calendar_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_Calendar_NAME());
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }            
    
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), iSERVICE_CONFIG, NULL))
    {
    //BUTTON CONFIG
    pd->html->WRITE ("<TR>\n");
    pd->html->WRITE ("<TD align=\"left\">\n");
    pd->html->WRITE ("<A HREF=\"%s/%s/config/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    pd->html->Image (GetService_Config_ICO_URL(),  GetService_Config_ICO_ALT(), skin->getISize());
    pd->html->WRITE ("<FONT face=\"%s\" SIZE=\"-1\"><B>%s</B></FONT>\n", skin->getSkinAtribProp("FONT_TABLE"), GetService_Config_NAME());
    pd->html->WRITE ("</A>\n");
    pd->html->WRITE ("</TD>\n");    
    pd->html->WRITE ("</TR>\n");
    }            
    
  pd->html->WRITE ("</TABLE></CENTER>\n");
  
  pd->html->HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }

